/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Collections;
import java.util.Map;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;

public abstract class Operation<T> {
    public final CassandraClientMonitor.Counter failCounter;
    public final String stopWatchTagName;
    public FailoverPolicy failoverPolicy = FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;
    public ConsistencyLevelPolicy consistencyLevelPolicy;
    public String keyspaceName;
    public Map<String, String> credentials;
    protected T result;
    private HectorException exception;
    private CassandraHost cassandraHost;
    protected long execTime;
    public final OperationType operationType;

    public Operation(OperationType operationType) {
        this.failCounter = operationType == OperationType.READ ? CassandraClientMonitor.Counter.READ_FAIL : CassandraClientMonitor.Counter.WRITE_FAIL;
        this.operationType = operationType;
        this.stopWatchTagName = operationType.name();
    }

    public Operation(OperationType operationType, Map<String, String> credentials) {
        this(operationType, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, null, credentials);
    }

    public Operation(OperationType operationType, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        this(operationType, failoverPolicy, null, credentials);
    }

    public Operation(OperationType operationType, FailoverPolicy failoverPolicy, String keyspaceName, Map<String, String> credentials) {
        this.failCounter = operationType == OperationType.READ ? CassandraClientMonitor.Counter.READ_FAIL : CassandraClientMonitor.Counter.WRITE_FAIL;
        this.operationType = operationType;
        this.stopWatchTagName = operationType.name();
        this.failoverPolicy = failoverPolicy;
        this.keyspaceName = keyspaceName;
        this.credentials = Collections.unmodifiableMap(credentials);
    }

    public void applyConnectionParams(String keyspace, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        this.keyspaceName = keyspace;
        this.consistencyLevelPolicy = consistencyLevelPolicy;
        this.failoverPolicy = failoverPolicy;
        this.credentials = credentials;
    }

    public void setResult(T executionResult) {
        this.result = executionResult;
    }

    public T getResult() {
        return this.result;
    }

    public ExecutionResult<T> getExecutionResult() {
        return new ExecutionResult<T>(this.result, this.execTime, this.cassandraHost);
    }

    public abstract T execute(Cassandra.Client var1) throws Exception;

    public void executeAndSetResult(Cassandra.Client cassandra, CassandraHost cassandraHost) throws Exception {
        this.cassandraHost = cassandraHost;
        long startTime = System.nanoTime();
        this.setResult(this.execute(cassandra));
        this.execTime = System.nanoTime() - startTime;
    }

    public void setException(HectorException e) {
        this.exception = e;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public HectorException getException() {
        return this.exception;
    }

    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }
}

