/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.BatchSizeHint;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;

public final class BatchMutation<K> {
    private final Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap;
    private final Serializer<K> keySerializer;
    private BatchSizeHint sizeHint;

    public BatchMutation(Serializer<K> serializer, BatchSizeHint sizeHint) {
        this.keySerializer = serializer;
        this.sizeHint = sizeHint;
        this.mutationMap = null == sizeHint ? new HashMap<ByteBuffer, Map<String, List<Mutation>>>() : new HashMap<ByteBuffer, Map<String, List<Mutation>>>(sizeHint.getNumOfRows());
    }

    public BatchMutation(Serializer<K> serializer) {
        this(serializer, null);
    }

    private BatchMutation(Serializer<K> serializer, Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap, BatchSizeHint sizeHint) {
        this.keySerializer = serializer;
        this.mutationMap = mutationMap;
        this.sizeHint = sizeHint;
    }

    public BatchMutation<K> addInsertion(K key, List<String> columnFamilies, Column column) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setColumn(column));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addSuperInsertion(K key, List<String> columnFamilies, SuperColumn superColumn) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setSuper_column(superColumn));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addCounterInsertion(K key, List<String> columnFamilies, CounterColumn counterColumn) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setCounter_column(counterColumn));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addSuperCounterInsertion(K key, List<String> columnFamilies, CounterSuperColumn counterSuperColumn) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setCounter_super_column(counterSuperColumn));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addDeletion(K key, List<String> columnFamilies, Deletion deletion) {
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    private void addMutation(K key, List<String> columnFamilies, Mutation mutation) {
        Map<String, List<Mutation>> innerMutationMap = this.getInnerMutationMap(key);
        for (String columnFamily : columnFamilies) {
            AbstractList mutList = innerMutationMap.get(columnFamily);
            if (mutList == null) {
                mutList = this.sizeHint == null ? new LinkedList<Mutation>() : new ArrayList<Mutation>(this.sizeHint.getNumOfColumns());
                innerMutationMap.put(columnFamily, mutList);
            }
            mutList.add((Mutation)mutation);
        }
    }

    private Map<String, List<Mutation>> getInnerMutationMap(K key) {
        Map<String, List<Mutation>> innerMutationMap = this.mutationMap.get(this.keySerializer.toByteBuffer(key));
        if (innerMutationMap == null) {
            innerMutationMap = new HashMap<String, List<Mutation>>();
            this.mutationMap.put(this.keySerializer.toByteBuffer(key), innerMutationMap);
        }
        return innerMutationMap;
    }

    public Map<ByteBuffer, Map<String, List<Mutation>>> getMutationMap() {
        return this.mutationMap;
    }

    public BatchMutation<K> makeCopy() {
        return new BatchMutation<K>(this.keySerializer, this.mutationMap, this.sizeHint);
    }

    public boolean isEmpty() {
        return this.mutationMap.isEmpty();
    }

    public int getSize() {
        return this.mutationMap.size();
    }
}

