/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.factory;

import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.client.HThriftClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.security.SSLHelper;
import me.prettyprint.cassandra.service.CassandraHost;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HThriftClientFactoryImpl
implements HClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HThriftClientFactoryImpl.class);
    private TSSLTransportFactory.TSSLTransportParameters params;

    @Override
    public HClient createClient(CassandraHost ch) {
        this.params = SSLHelper.getTSSLTransportParameters();
        log.info("SSL enabled for client<->server communications.");
        log.info("Properties:");
        log.info("  ssl.truststore = {}", (Object)System.getProperty("ssl.truststore"));
        log.info("  ssl.protocol = {}", (Object)System.getProperty("ssl.protocol"));
        log.info("  ssl.store.type = {}", (Object)System.getProperty("ssl.store.type"));
        log.info("  ssl.cipher.suites = {}", (Object)System.getProperty("ssl.cipher.suites"));
        if (log.isDebugEnabled()) {
            log.debug("Creation of new client for host: " + ch.getIp());
        }
        return this.params == null ? new HThriftClient(ch) : new HThriftClient(ch, this.params);
    }
}

