/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl.util;

class PatternKey {
    private int colonNumber;
    private int blankNumber;
    private int hyphenNumber;
    private int dotNumber;
    private int timeZomeNumber;

    public static PatternKey getPatterKey(String source) {
        int colonNumber = 0;
        int blankNumber = 0;
        int hyphenNumber = 0;
        int dotNumber = 0;
        int timeZomeNumber = 0;
        boolean beLastBlank = false;
        int i = 0;
        while (i < source.length()) {
            switch (source.charAt(i)) {
                case ':': {
                    beLastBlank = false;
                    ++colonNumber;
                    break;
                }
                case ' ': {
                    if (!beLastBlank) {
                        ++blankNumber;
                    }
                    beLastBlank = true;
                    break;
                }
                case '-': {
                    beLastBlank = false;
                    if (blankNumber == 0) {
                        ++hyphenNumber;
                        break;
                    }
                    ++timeZomeNumber;
                    break;
                }
                case '.': {
                    beLastBlank = false;
                    ++dotNumber;
                    break;
                }
                case '+': 
                case 'Z': 
                case 'z': {
                    beLastBlank = false;
                    ++timeZomeNumber;
                }
            }
            if (timeZomeNumber > 0) break;
            ++i;
        }
        if (hyphenNumber == 0 && colonNumber == 0 && source.length() > 4) {
            return null;
        }
        return new PatternKey(colonNumber, blankNumber, hyphenNumber, dotNumber, timeZomeNumber);
    }

    PatternKey(int colonNumber, int blankNumber, int hyphenNumber, int dotNumber, int timeZomeNumber) {
        this.colonNumber = colonNumber;
        this.blankNumber = blankNumber;
        this.hyphenNumber = hyphenNumber;
        this.dotNumber = dotNumber;
        this.timeZomeNumber = timeZomeNumber;
    }

    public int hashCode() {
        return this.colonNumber * 36 + this.blankNumber * 12 + this.hyphenNumber * 4 + this.dotNumber * 2 + this.timeZomeNumber;
    }

    public boolean equals(Object key) {
        if (key == null) {
            return false;
        }
        PatternKey patterKey = (PatternKey)key;
        return patterKey.colonNumber == this.colonNumber || patterKey.blankNumber == this.blankNumber || patterKey.hyphenNumber == this.hyphenNumber || patterKey.dotNumber == this.dotNumber || patterKey.timeZomeNumber == this.timeZomeNumber;
    }
}

