/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import org.eclipse.jdt.internal.ui.macbundler.BundleDescription;
import org.eclipse.jdt.internal.ui.macbundler.BundleWizardBasePage;
import org.eclipse.jdt.internal.ui.macbundler.ResourceInfo;
import org.eclipse.jdt.internal.ui.macbundler.Util;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BundleWizardPage2
extends BundleWizardBasePage {
    Text fWorkingDir;
    Table fClassPath;
    Table fResources;

    protected BundleWizardPage2(BundleDescription bd) {
        super("page2", bd);
    }

    @Override
    public void createContents(Composite parent) {
        Composite c = BundleWizardPage2.createComposite(parent, 2);
        BundleWizardPage2.createLabel(c, Util.getString("page2.workingDirectory.label"), 4);
        this.fWorkingDir = this.createText(c, "WorkingDir", 1);
        this.fClassPath = this.createTableGroup(parent, Util.getString("page2.addToClasspath.group.label"), true);
        this.fResources = this.createTableGroup(parent, Util.getString("page2.addToBundle.group.label"), false);
    }

    Table createTableGroup(Composite parent, String groupName, final boolean onClasspath) {
        Group g1 = BundleWizardPage2.createGroup(parent, groupName, 1);
        final Table table = new Table((Composite)g1, 66306);
        BundleWizardPage2.setHeightHint((Control)table, 80);
        Composite c1 = BundleWizardPage2.createComposite((Composite)g1, 3);
        final Button addButton1 = this.createButton(c1, 0, Util.getString("page2.addFile.button.label"));
        addButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(addButton1.getShell(), 0x10001000);
                fd.setText(Util.getString("page2.chooseFileDialog.title"));
                String path = fd.open();
                if (path != null) {
                    ResourceInfo ri = new ResourceInfo(path);
                    BundleWizardPage2.this.fBundleDescription.addResource(ri, onClasspath);
                    BundleWizardPage2.this.add(table, ri);
                }
            }
        });
        final Button addButton2 = this.createButton(c1, 0, Util.getString("page2.addFolder.button.label"));
        addButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fd = new DirectoryDialog(addButton2.getShell(), 0x10001000);
                fd.setText(Util.getString("page2.chooseFolder.dialog.title"));
                String path = fd.open();
                if (path != null) {
                    ResourceInfo ri = new ResourceInfo(path);
                    BundleWizardPage2.this.fBundleDescription.addResource(ri, onClasspath);
                    BundleWizardPage2.this.add(table, ri);
                }
            }
        });
        final Button removeButton = this.createButton(c1, 0, Util.getString("page2.remove.button.label"));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleWizardPage2.this.remove(table, onClasspath, removeButton);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                removeButton.setEnabled(table.getSelectionCount() > 0);
            }
        });
        return table;
    }

    private void add(Table t, ResourceInfo ri) {
        TableItem ti = new TableItem(t, 0);
        ti.setData((Object)ri);
        ti.setText(ri.fPath);
    }

    private void remove(Table table, boolean b, Button removeButton) {
        TableItem[] selection = table.getSelection();
        int i = 0;
        while (i < selection.length) {
            int ix;
            TableItem ti = selection[i];
            ResourceInfo ri = (ResourceInfo)ti.getData();
            if (this.fBundleDescription.removeResource(ri, b) && (ix = table.indexOf(ti)) >= 0) {
                table.remove(ix);
            }
            ++i;
        }
        removeButton.setEnabled(table.getSelectionCount() > 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int i;
        ResourceInfo[] ris;
        if (this.fWorkingDir != null) {
            this.fWorkingDir.setText(this.fBundleDescription.get("WorkingDir", ""));
        }
        if (this.fClassPath != null) {
            this.fClassPath.removeAll();
            ris = this.fBundleDescription.getResources(true);
            i = 0;
            while (i < ris.length) {
                this.add(this.fClassPath, ris[i]);
                ++i;
            }
        }
        if (this.fResources != null) {
            this.fResources.removeAll();
            ris = this.fBundleDescription.getResources(false);
            i = 0;
            while (i < ris.length) {
                this.add(this.fResources, ris[i]);
                ++i;
            }
        }
    }

    public boolean isPageComplete() {
        return true;
    }
}

