/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock.Key PREF_TEMPLATE = this.getReportKey("designer.preview.preference.template.description.preferencestore");
    private PixelConverter fPixelConverter;
    public static final String BUTTON_KEY = "buttons";
    public static final String TITLE_LABEL = Messages.getString((String)"report.designer.ui.preferences.template.title");
    public static final String TEMPLATE_IMAGE_LABEL = Messages.getString((String)"report.designer.ui.preferences.template.templatefolder");
    public static final String BROWSER_BUTTON = Messages.getString((String)"report.designer.ui.preferences.template.select");
    public static final String OPEN_DIALOG_TITLE = Messages.getString((String)"report.designer.ui.preferences.template.openDialogTitle");
    public static final String DIRCTORY = "templates";
    private Text resourceText;

    public TemplateConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_TEMPLATE};
        return keys;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Label title = new Label(parent, 0);
        title.setLayoutData((Object)new GridData(768));
        title.setText(TITLE_LABEL);
        new Label(parent, 0);
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        this.resourceText = this.addTextField(pageContent, TEMPLATE_IMAGE_LABEL, this.PREF_TEMPLATE, 0, 0);
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter(this, IDialogHelperProvider.class);
        IDialogHelper controlTypeHelper = null;
        if (helperProvider != null) {
            controlTypeHelper = helperProvider.createHelper(this, BUTTON_KEY);
        }
        if (controlTypeHelper != null) {
            controlTypeHelper.setContainer(this);
            controlTypeHelper.createContent(pageContent);
            controlTypeHelper.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TemplateConfigurationBlock.this.resourceText.setText(event.text);
                }
            });
        } else {
            new Label(pageContent, 0);
            Button browser = new Button(pageContent, 8);
            browser.setText(BROWSER_BUTTON);
            data = new GridData();
            browser.setLayoutData((Object)data);
            browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    dialog.setText(OPEN_DIALOG_TITLE);
                    String folderName = dialog.open();
                    if (folderName == null) {
                        return;
                    }
                    if (!(folderName = folderName.replace('\\', '/')).endsWith("/")) {
                        folderName = String.valueOf(folderName) + "/";
                    }
                    TemplateConfigurationBlock.this.resourceText.setText(folderName);
                }
            });
        }
        return pageContent;
    }
}

