/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.core.commands.SetConstraintCommand;
import org.eclipse.birt.report.designer.core.model.IMultipleAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.MultipleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IDelaySelectionDragTracker;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.MultipleFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.MultipleGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.layout.MultipleLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.widgets.Display;

public class MultipleEditPart
extends ReportElementEditPart
implements IMultipleAdapterHelper {
    private String guideLabel;

    public MultipleEditPart(Object model) {
        super(model);
    }

    public Command getCommand(Request request) {
        if ("orphan children".equals(request.getType())) {
            return this.getParent().getCommand(request);
        }
        return super.getCommand(request);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy(){

            @Override
            protected Command getAddCommand(Request req) {
                return UnexecutableCommand.INSTANCE;
            }

            public EditPart getTargetEditPart(Request request) {
                if ("create child".equals(request.getType()) && ((ReportItemHandle)this.getHost().getModel()).getCurrentView() != null) {
                    return null;
                }
                return super.getTargetEditPart(request);
            }
        });
    }

    @Override
    public void refreshFigure() {
        ((MultipleLayout)this.getFigure().getLayoutManager()).markDirty();
        ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), this.getConstraint());
    }

    protected Object getConstraint() {
        ReportItemConstraint constraint = new ReportItemConstraint();
        DesignElementHandle handle = (DesignElementHandle)this.getModelChildren().get(0);
        if (handle != null && handle != this.getModel()) {
            constraint.setMargin(HandleAdapterFactory.getInstance().getDesignElementHandleAdapter((Object)handle, null).getMargin(null));
        } else {
            constraint.setMargin(this.getMultipleAdapter().getMargin(null));
        }
        return constraint;
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected List getModelChildren() {
        return this.getModelAdapter().getChildren();
    }

    protected IFigure createFigure() {
        MultipleFigure layer = new MultipleFigure();
        return layer;
    }

    public MultipleAdapter getMultipleAdapter() {
        return (MultipleAdapter)this.getModelAdapter();
    }

    public boolean isMultiple() {
        return true;
    }

    @Override
    protected AbstractGuideHandle createGuideHandle() {
        MultipleGuideHandle handle = new MultipleGuideHandle((GraphicalEditPart)this);
        handle.addChildren(this.getMultipleAdapter().getViews());
        handle.setSelected(this.getMultipleAdapter().getCurrentViewNumber());
        return handle;
    }

    public void setCurrentView(int number) {
        this.getMultipleAdapter().setCurrentView(number);
        ((MultipleGuideHandle)this.getGuideHandle()).setSelected(number);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultipleEditPart.this.refreshVisuals();
            }
        });
    }

    public void removeView(int number) {
        this.getMultipleAdapter().removeView(number);
    }

    @Override
    protected void propertyChange(Map info) {
        Set set = info.keySet();
        if (set.contains("multiViews") && this.getMultipleAdapter().getViews().size() > 0) {
            this.refresh();
            UIUtil.resetViewSelection(this.getViewer(), true);
            return;
        }
        super.propertyChange(info);
    }

    @Override
    protected void contentChange(Map info) {
        int intValue;
        Object action = info.get("Content event type");
        if (action instanceof Integer && ((intValue = ((Integer)action).intValue()) == 10 || intValue == 12 || intValue == 11)) {
            this.markDirty(true);
            this.removeGuideFeedBack();
            if (this.getMultipleAdapter().getViews().size() == 0) {
                this.markDirty(true);
                EditPart part = this.getParent();
                ((ReportElementEditPart)this.getParent()).removeChild((EditPart)this);
                part.refresh();
                return;
            }
        }
        super.contentChange(info);
    }

    @Override
    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        MultipleResizePolicy policy = new MultipleResizePolicy();
        policy.setResizeDirections(20);
        return policy;
    }

    @Override
    public boolean isinterestSelection(Object object) {
        return this.getMultipleAdapter().getViews().contains(object);
    }

    @Override
    public boolean isinterest(Object model) {
        if (this.getMultipleAdapter().getViews().contains(model)) {
            return true;
        }
        return super.isinterest(model);
    }

    @Override
    public void notifyModelChange() {
        super.notifyModelChange();
        ((MultipleLayout)this.getFigure().getLayoutManager()).markDirty();
    }

    @Override
    public String getGuideLabel() {
        if (this.guideLabel == null) {
            this.guideLabel = ((ReportElementEditPart)this.getChildren().get(0)).getGuideLabel();
        }
        return this.guideLabel;
    }

    public Object getAdapter(Class key) {
        if (key == IDelaySelectionDragTracker.class) {
            return this.getParent().getAdapter(IDelaySelectionDragTracker.class);
        }
        return super.getAdapter(key);
    }

    @Override
    protected void updateLayoutPreference() {
        super.updateLayoutPreference();
        this.getFigure().invalidate();
        ((MultipleLayout)this.getFigure().getLayoutManager()).markDirty();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultipleEditPart.this.getFigure().invalidateTree();
                MultipleEditPart.this.getFigure().revalidate();
            }
        });
    }

    private static class MultipleResizePolicy
    extends ReportElementResizablePolicy {
        private MultipleResizePolicy() {
        }

        protected Command getResizeCommand(ChangeBoundsRequest request) {
            Command command = super.getResizeCommand(request);
            if (command instanceof SetConstraintCommand) {
                ((SetConstraintCommand)command).setModel((ReportItemHandle)this.getTrueHost().getModel());
            }
            return command;
        }

        private GraphicalEditPart getTrueHost() {
            GraphicalEditPart parent = (GraphicalEditPart)this.getHost();
            List list = parent.getChildren();
            if (list.size() == 0) {
                return parent;
            }
            return (GraphicalEditPart)list.get(0);
        }
    }
}

