/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.DragEditorGuide;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuide;
import org.eclipse.draw2d.geometry.Rectangle;

public class EditorRuler {
    private Rectangle leftSpace = new Rectangle();
    public static final String PROPERTY_CHILDREN = "children changed";
    public static final String PROPERTY_UNIT = "units changed";
    public static final String PROPERTY_LEFTMARGIN = "left margin";
    public static final String PROPERTY_RIGHTMARGIN = "right margin";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private int unit;
    private boolean horizontal;
    private List guides = new ArrayList();
    private EditorGuide left;
    private EditorGuide right;
    private boolean marginOff = false;

    public PropertyChangeSupport getListeners() {
        return this.listeners;
    }

    public void setListeners(PropertyChangeSupport listeners) {
        this.listeners = listeners;
    }

    public int getRightMargin() {
        if (this.right != null) {
            return this.right.getPosition();
        }
        return -1;
    }

    public void setRightMargin(int newMargin) {
        if (!this.marginOff) {
            if (this.right == null) {
                this.right = new EditorGuide(!this.isHorizontal(), 1);
                this.right.setPosition(newMargin);
                this.addGuide(this.right);
            } else {
                this.right.setPosition(newMargin);
            }
        }
    }

    public EditorRuler(boolean isHorizontal) {
        this(isHorizontal, 0);
    }

    public EditorRuler(boolean isHorizontal, int unit) {
        this.horizontal = isHorizontal;
        this.setUnit(unit);
    }

    public void addGuide(EditorGuide guide) {
        if (!this.guides.contains(guide)) {
            guide.setHorizontal(!this.isHorizontal());
            this.guides.add(guide);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public List getGuides() {
        return this.guides;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removeGuide(EditorGuide guide) {
        if (this.guides.remove(guide)) {
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setMarginOff(boolean marginOff) {
        this.marginOff = marginOff;
        if (marginOff) {
            this.removeGuide(this.left);
            this.removeGuide(this.right);
            this.left = null;
            this.right = null;
        }
    }

    public void setHidden(boolean isHidden) {
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            int oldUnit = this.unit;
            this.unit = newUnit;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldUnit, newUnit);
        }
    }

    public int getLeftMargin() {
        if (this.left != null) {
            return this.left.getPosition();
        }
        return -1;
    }

    public void setLeftMargin(int newMargin) {
        if (!this.marginOff) {
            if (this.left == null) {
                this.left = new EditorGuide(!this.isHorizontal(), 0);
                this.left.setPosition(newMargin);
                this.addGuide(this.left);
            } else {
                this.left.setPosition(newMargin);
            }
        }
    }

    public void setLeftSpace(Rectangle space) {
        if (!this.leftSpace.equals((Object)space)) {
            Rectangle oldSpace = this.leftSpace;
            this.leftSpace = space;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldSpace, space);
        }
    }

    public Rectangle getLeftSpace() {
        return this.leftSpace;
    }

    public void changeDragGuide(int position, boolean horizontal) {
        DragEditorGuide dragGuide = this.findDragEditorGuide();
        if (position <= 0) {
            if (dragGuide != null) {
                this.removeGuide(dragGuide);
            }
        } else if (dragGuide != null) {
            dragGuide.setPosition(position);
        } else {
            dragGuide = new DragEditorGuide(horizontal);
            dragGuide.setPosition(position);
            this.addGuide(dragGuide);
        }
    }

    private DragEditorGuide findDragEditorGuide() {
        int i = 0;
        while (i < this.guides.size()) {
            if (this.guides.get(i) instanceof DragEditorGuide) {
                return (DragEditorGuide)this.guides.get(i);
            }
            ++i;
        }
        return null;
    }
}

