/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.resource;

import com.ibm.icu.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.resource.ViewerResourceHandle;

public class BirtResources {
    private static String BACKSLASH = "\\";
    private static Map resourceMap = new HashMap();
    private static ThreadLocal threadLocal = new ThreadLocal();

    public static void setLocale(Locale locale) {
        if (locale == null) {
            threadLocal.set(Locale.getDefault());
        } else {
            threadLocal.set(locale);
        }
    }

    public static Locale getLocale() {
        Locale locale = (Locale)threadLocal.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMessage(String key) {
        ViewerResourceHandle resourceHandle = BirtResources.getResourceHandle();
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key);
        }
        return key;
    }

    public static String getMessage(String key, Object[] arguments) {
        ViewerResourceHandle resourceHandle = BirtResources.getResourceHandle();
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key, arguments);
        }
        return key;
    }

    public static String getJavaScriptMessage(String key) {
        return BirtResources.makeJavaScriptString(BirtResources.getMessage(key));
    }

    public static String getJavaScriptMessage(String key, Object[] arguments) {
        return BirtResources.makeJavaScriptString(BirtResources.getMessage(key, arguments));
    }

    public static String getHtmlMessage(String key) {
        return BirtResources.makeHtmlString(BirtResources.getMessage(key));
    }

    public static String getHtmlMessage(String key, Object[] arguments) {
        return BirtResources.makeHtmlString(BirtResources.getMessage(key, arguments));
    }

    @Deprecated
    public static String getString(String key) {
        return BirtResources.getMessage(key);
    }

    @Deprecated
    public static String getFormattedString(String key, Object[] arguments) {
        return MessageFormat.format((String)BirtResources.getString(key), (Object[])arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewerResourceHandle getResourceHandle() {
        Locale locale = BirtResources.getLocale();
        ViewerResourceHandle resourceHandle = (ViewerResourceHandle)((Object)resourceMap.get(locale));
        if (resourceHandle != null) {
            return resourceHandle;
        }
        Map map = resourceMap;
        synchronized (map) {
            if (resourceMap.get(locale) != null) {
                return (ViewerResourceHandle)((Object)resourceMap.get(locale));
            }
            resourceHandle = new ViewerResourceHandle(locale);
            resourceMap.put(locale, resourceHandle);
        }
        return resourceHandle;
    }

    public static String makeJavaScriptString(String s) {
        StringBuilder output = new StringBuilder(s.length());
        StringCharacterIterator it = new StringCharacterIterator(s);
        char c = it.first();
        while (c != '\uffff') {
            switch (c) {
                case '\b': {
                    output.append(String.valueOf(BACKSLASH) + "b");
                    break;
                }
                case '\t': {
                    output.append(String.valueOf(BACKSLASH) + "t");
                    break;
                }
                case '\n': {
                    output.append(String.valueOf(BACKSLASH) + "n");
                    break;
                }
                case '\f': {
                    output.append(String.valueOf(BACKSLASH) + "f");
                    break;
                }
                case '\r': {
                    output.append(String.valueOf(BACKSLASH) + "r");
                    break;
                }
                case '\"': 
                case '\'': 
                case '/': 
                case '\\': {
                    output.append(String.valueOf(BACKSLASH) + c);
                    break;
                }
                default: {
                    output.append(c);
                }
            }
            c = it.next();
        }
        return output.toString();
    }

    public static String makeHtmlString(String s) {
        return s.replace("\"", "&quot;");
    }
}

