/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.utils.ISQLSyntax;

public abstract class BidiSQLTransform
implements ISQLSyntax {
    private static RuleComparator comparator = new RuleComparator();
    private static final RuleData[] RULE_DATA = new RuleData[]{new RuleData("'.+?'", ACTION.TRANSFORM_LITERAL, 0), new RuleData("\"[^\"]+\"", ACTION.TRANSFORM_ID, 0), new RuleData("\\s+", ACTION.NONE, 0), new RuleData("//.*", ACTION.NONE, 0), new RuleData("--.*", ACTION.NONE, 0), new RuleData("/\\*.*?\\*/", ACTION.NONE, 32), new RuleData("[\\p{L}_][\\p{L}\\p{N}_]+", ACTION.CHECK, 0)};
    private static String[] ALL_KEYWORDS = null;

    static {
        BidiSQLTransform.mergeKeywords(reservedwords, constants, predicates, types, functions);
    }

    private static void mergeKeywords(String[] ... keywords) {
        if (keywords != null) {
            int i = 0;
            int offset = 0;
            int size = 0;
            int[] sizes = new int[keywords.length];
            String[][] stringArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String[] array = stringArray[n2];
                sizes[i] = array == null ? 0 : array.length;
                size += sizes[i++];
                ++n2;
            }
            ALL_KEYWORDS = new String[size];
            i = 0;
            size = sizes.length;
            while (i < size) {
                if (sizes[i] > 0) {
                    System.arraycopy(keywords[i], 0, ALL_KEYWORDS, offset, sizes[i]);
                    offset += sizes[i];
                }
                ++i;
            }
            Arrays.sort(ALL_KEYWORDS);
        } else {
            ALL_KEYWORDS = new String[0];
        }
    }

    private static boolean isKeyword(String word) {
        return Arrays.binarySearch(ALL_KEYWORDS, word) >= 0;
    }

    private static List<ImplementedRule> initRules(String text) {
        ArrayList<ImplementedRule> rules = new ArrayList<ImplementedRule>();
        int i = 0;
        int n = RULE_DATA.length;
        while (i < n) {
            ImplementedRule rule = new ImplementedRule(text, RULE_DATA[i]);
            if (rule.isValid(0)) {
                rules.add(rule);
            }
            ++i;
        }
        if (!rules.isEmpty()) {
            Collections.sort(rules, comparator);
        }
        return rules;
    }

    private static ImplementedRule getBestMatch(List<ImplementedRule> rules, String text, int offset) {
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        if (offset > 0) {
            Iterator<ImplementedRule> it = rules.iterator();
            while (it.hasNext()) {
                ImplementedRule rule = it.next();
                if (rule.startOffset < offset) {
                    rule.getNextToken(offset);
                }
                if (rule.startOffset == offset) {
                    return rule;
                }
                if (rule.isValid(offset)) continue;
                it.remove();
            }
            if (rules.isEmpty()) {
                return null;
            }
            Collections.sort(rules, comparator);
        }
        return rules.get(0);
    }

    /*
     * Unable to fully structure code
     */
    public static String transform(String sql, String inContentFormat, String outContentFormat, String inMetadataFormat, String outMetadataFormat) {
        if (!BidiFormat.isValidBidiFormat((String)inContentFormat) || !BidiFormat.isValidBidiFormat((String)outContentFormat) || !BidiFormat.isValidBidiFormat((String)inMetadataFormat) || !BidiFormat.isValidBidiFormat((String)outMetadataFormat) || inContentFormat.equals(outContentFormat) && inMetadataFormat.equals(outMetadataFormat)) {
            return sql;
        }
        offset = 0;
        length = sql.length();
        buf = new StringBuilder(length);
        rules = BidiSQLTransform.initRules(sql);
        if (!rules.isEmpty()) ** GOTO lbl25
        return sql;
        while ((rule = BidiSQLTransform.getBestMatch(rules, sql, offset)) != null) {
            if (rule.startOffset > offset) {
                buf.append(sql.substring(offset, rule.startOffset));
            }
            token = sql.substring(rule.startOffset, rule.endOffset);
            if (rule.action == ACTION.TRANSFORM_ID || rule.action == ACTION.CHECK && !BidiSQLTransform.isKeyword(token)) {
                buf.append(BidiTransform.transform((String)token, (String)inMetadataFormat, (String)outMetadataFormat));
            } else if (rule.action == ACTION.TRANSFORM_LITERAL) {
                buf.append(BidiTransform.transform((String)token, (String)inContentFormat, (String)outContentFormat));
            } else {
                buf.append(token);
            }
            offset = rule.endOffset;
lbl25:
            // 2 sources

            if (offset < length) continue;
        }
        if (offset < length) {
            buf.append(sql.substring(offset, length));
        }
        return buf.toString();
    }

    static enum ACTION {
        NONE,
        CHECK,
        TRANSFORM_ID,
        TRANSFORM_LITERAL;

    }

    static class ImplementedRule {
        ACTION action;
        Matcher matcher;
        int startOffset;
        int endOffset;

        ImplementedRule(String text, RuleData data) {
            this.action = data.action;
            this.matcher = Pattern.compile(data.regex, data.flags).matcher(text);
            this.getNextToken(0);
        }

        void getNextToken(int offset) {
            if (this.matcher.find(offset)) {
                this.startOffset = this.matcher.start();
                this.endOffset = this.matcher.end();
            } else {
                this.endOffset = Integer.MAX_VALUE;
                this.startOffset = Integer.MAX_VALUE;
            }
        }

        public boolean equals(Object o) {
            return o instanceof ImplementedRule && comparator.compare(this, (ImplementedRule)o) == 0;
        }

        public int hashCode() {
            return this.action.hashCode() * 11 + this.startOffset + this.endOffset;
        }

        boolean isValid(int offset) {
            return this.startOffset < this.endOffset && this.startOffset >= offset;
        }
    }

    static class RuleComparator
    implements Comparator<ImplementedRule> {
        RuleComparator() {
        }

        @Override
        public int compare(ImplementedRule o1, ImplementedRule o2) {
            return Integer.compare(o1.startOffset, o2.startOffset);
        }
    }

    static class RuleData {
        String regex;
        ACTION action;
        int flags;

        public RuleData(String regex, ACTION action, int flags) {
            this.regex = regex;
            this.action = action;
            this.flags = flags;
        }
    }
}

