/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.product.FeatureProperties;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.feature.NewFeatureProjectWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureSection
extends TableSection
implements IPropertyChangeListener {
    private static final int BTN_DWN = 7;
    private static final int BTN_UP = 6;
    private static final int BTN_ROOT = 5;
    private static final int BTN_PROPS = 4;
    private static final int BTN_REMOVE_ALL = 3;
    private static final int BTN_REMOVE = 2;
    private static final int BTN_ADD_REQ = 1;
    private static final int BTN_ADD = 0;
    private SortAction fSortAction;
    private Action fNewFeatureAction;
    private TableViewer fFeatureTable;

    public FeatureSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, FeatureSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[8];
        labels[0] = PDEUIMessages.Product_FeatureSection_add;
        labels[1] = PDEUIMessages.FeatureSection_addRequired;
        labels[2] = PDEUIMessages.Product_FeatureSection_remove;
        labels[3] = PDEUIMessages.Product_PluginSection_removeAll;
        labels[5] = PDEUIMessages.FeatureSection_toggleRoot;
        labels[4] = PDEUIMessages.Product_FeatureSection_properties;
        labels[6] = PDEUIMessages.Product_FeatureSection_up;
        labels[7] = PDEUIMessages.Product_FeatureSection_down;
        return labels;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        this.createAutoIncludeRequirementsButton(container);
        EditableTablePart tablePart = this.getTablePart();
        this.fFeatureTable = tablePart.getTableViewer();
        this.fFeatureTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fFeatureTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeatureTable.setComparator(null);
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.fFeatureTable.setInput((Object)PDECore.getDefault().getFeatureModelManager());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(4, this.isEditable());
        tablePart.setButtonEnabled(5, this.isEditable());
        tablePart.setButtonEnabled(6, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setText(PDEUIMessages.Product_FeatureSection_title);
        section.setDescription(PDEUIMessages.Product_FeatureSection_desc);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fNewFeatureAction = new NewFeatureAction();
        toolBarManager.add((IAction)this.fNewFeatureAction);
        this.fSortAction = new SortAction((StructuredViewer)this.fFeatureTable, PDEUIMessages.Product_FeatureSection_sortAlpha, null, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createAutoIncludeRequirementsButton(Composite container) {
        Button autoInclude = new Button(container, 32);
        autoInclude.setText(PDEUIMessages.Product_FeatureSection_autoIncludeRequirements);
        autoInclude.setSelection(this.getProduct().includeRequirementsAutomatically());
        if (this.isEditable()) {
            autoInclude.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setIncludeRequirementsAutomatically(autoInclude.getSelection())));
        } else {
            autoInclude.setEnabled(false);
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddRequired();
                break;
            }
            case 2: {
                this.handleDelete();
                break;
            }
            case 3: {
                this.handleRemoveAll();
                break;
            }
            case 4: {
                this.handleProperties();
                break;
            }
            case 5: {
                this.handleRootToggle();
                break;
            }
            case 6: {
                this.handleUp();
                break;
            }
            case 7: {
                this.handleDown();
            }
        }
    }

    private void handleRootToggle() {
        boolean nonRootSelected = this.getViewerSelection().toList().stream().anyMatch(o -> !((IProductFeature)o).isRootInstallMode());
        this.getViewerSelection().toList().forEach(o -> {
            IProductFeature iProductFeature = ((IProductFeature)o).setRootInstallMode(nonRootSelected);
        });
    }

    private void handleProperties() {
        IStructuredSelection ssel = this.fFeatureTable.getStructuredSelection();
        if (ssel.size() == 1) {
            IProductFeature feature = (IProductFeature)ssel.toArray()[0];
            FeatureProperties dialog = new FeatureProperties(PDEPlugin.getActiveWorkbenchShell(), this.isEditable(), feature.getVersion(), feature.isRootInstallMode());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                feature.setVersion(dialog.getVersion());
                feature.setRootInstallMode(dialog.getRootInstallMode());
            }
        }
    }

    private void handleNewFeature() {
        NewFeatureProjectWizard wizard = new NewFeatureProjectWizard();
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addFeature(wizard.getFeatureId());
        }
    }

    private void addFeature(String id) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductFeature feature = factory.createFeature();
        feature.setId(id);
        feature.setVersion("");
        feature.setRootInstallMode(true);
        product.addFeatures(new IProductFeature[]{feature});
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removeFeatures(product.getFeatures());
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IProductFeature) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IProductFeature[] features;
        if (objects instanceof IProductFeature[]) {
            features = (IProductFeature[])objects;
        } else {
            features = new IProductFeature[objects.length];
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductFeature) {
                    features[i] = (IProductFeature)objects[i];
                }
                ++i;
            }
        }
        this.getProduct().addFeatures(features);
    }

    private void handleDelete() {
        IStructuredSelection ssel = this.fFeatureTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IProductFeature[] features = new IProductFeature[objects.length];
            System.arraycopy(objects, 0, features, 0, objects.length);
            this.getProduct().removeFeatures(features);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = this.fFeatureTable.getStructuredSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = new Action(PDEUIMessages.Product_FeatureSection_open){

            public void run() {
                FeatureSection.this.handleDoubleClick(FeatureSection.this.fFeatureTable.getStructuredSelection());
            }
        };
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = new Action(PDEUIMessages.Product_FeatureSection_remove){

            public void run() {
                FeatureSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && !ssel.isEmpty());
        manager.add((IAction)removeAction);
        Action removeAll = new Action(PDEUIMessages.FeatureSection_removeAll){

            public void run() {
                FeatureSection.this.handleRemoveAll();
            }
        };
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleOpen(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IProductFeature feature = (IProductFeature)selection.getFirstElement();
            FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
            FeatureEditor.openFeatureEditor(model);
        }
    }

    private void handleAdd() {
        FeatureSelectionDialog dialog = new FeatureSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailableChoices(), true);
        if (dialog.open() == 0) {
            Object[] models;
            Object[] objectArray = models = dialog.getResult();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                Object model = objectArray[n2];
                IFeature feature = ((IFeatureModel)model).getFeature();
                this.addFeature(feature.getId());
                ++n2;
            }
        }
    }

    private void handleAddRequired() {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IProductFeature[] currentFeatures = this.getProduct().getFeatures();
        HashSet<String> requiredFeatures = new HashSet<String>();
        IProductFeature[] iProductFeatureArray = currentFeatures;
        int n = currentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
            if (model != null) {
                requiredFeatures.add(feature.getId());
                this.getFeatureDependencies(model, requiredFeatures);
            }
            ++n2;
        }
        for (String id : requiredFeatures) {
            if (this.getProduct().containsFeature(id)) continue;
            this.addFeature(id);
        }
    }

    private void getFeatureDependencies(IFeatureModel model, Set<String> requiredFeatures) {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeature feature = model.getFeature();
        IFeatureImport[] featureImports = feature.getImports();
        int i = 0;
        while (i < featureImports.length) {
            if (featureImports[i].getType() == 1 && !requiredFeatures.contains(featureImports[i].getId())) {
                requiredFeatures.add(featureImports[i].getId());
                IFeatureModel currentModel = manager.findFeatureModel(featureImports[i].getId());
                if (currentModel != null) {
                    this.getFeatureDependencies(currentModel, requiredFeatures);
                }
            }
            ++i;
        }
        IFeatureChild[] featureIncludes = feature.getIncludedFeatures();
        int i2 = 0;
        while (i2 < featureIncludes.length) {
            if (!requiredFeatures.contains(featureIncludes[i2].getId())) {
                requiredFeatures.add(featureIncludes[i2].getId());
                IFeatureModel currentModel = manager.findFeatureModel(featureIncludes[i2].getId());
                if (currentModel != null) {
                    this.getFeatureDependencies(currentModel, requiredFeatures);
                }
            }
            ++i2;
        }
    }

    private IFeatureModel[] getAvailableChoices() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        IProduct product = this.getProduct();
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            String id = model.getFeature().getId();
            if (id != null && !product.containsFeature(id)) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        if (e.getChangeType() == 1) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IProductFeature) {
                    this.fFeatureTable.add(object);
                }
                ++n2;
            }
        } else if (e.getChangeType() == 2) {
            Table table = this.fFeatureTable.getTable();
            int index = table.getSelectionIndex();
            Object[] objectArray = objects;
            int n = objects.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                if (object instanceof IProductFeature) {
                    this.fFeatureTable.remove(object);
                }
                ++n3;
            }
            int count = table.getItemCount();
            if (count != 0) {
                if (index < count) {
                    table.setSelection(index);
                } else {
                    table.setSelection(count - 1);
                }
            }
        } else if (e.getChangeType() == 3) {
            this.fFeatureTable.refresh();
        }
        this.updateButtons(false, true);
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (this.fFeatureTable.getTable().isDisposed()) {
            return;
        }
        this.fFeatureTable.setInput((Object)PDECore.getDefault().getFeatureModelManager());
        this.refresh();
    }

    public void refresh() {
        this.fFeatureTable.refresh();
        this.updateButtons(true, true);
        super.refresh();
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons(true, false);
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IProductFeature) {
            this.fFeatureTable.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void updateButtons(boolean updateRemove, boolean updateRemoveAll) {
        boolean hasSelection;
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean bl = hasSelection = tableSelection.length > 0;
        if (updateRemove) {
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(3, this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && selection.getFirstElement() instanceof IProductFeature);
        }
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(3, this.isEditable() && this.fFeatureTable.getTable().getItemCount() > 0);
        }
        tablePart.setButtonEnabled(4, this.isEditable() && tableSelection.length == 1);
        tablePart.setButtonEnabled(5, this.isEditable() && hasSelection);
        boolean canMove = table.getItemCount() > 1 && tableSelection.length == 1 && !this.fSortAction.isChecked();
        tablePart.setButtonEnabled(6, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(7, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IProductFeature feature1 = (IProductFeature)table.getItem(index1).getData();
        IProductFeature feature2 = (IProductFeature)table.getItem(index2).getData();
        IProduct product = this.getProduct();
        product.swap(feature1, feature2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateButtons(true, true);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return FeatureSection.this.getProduct().getFeatures();
        }
    }

    class NewFeatureAction
    extends Action {
        public NewFeatureAction() {
            super(PDEUIMessages.Product_FeatureSection_newFeature, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWFTRPRJ_TOOL);
        }

        public void run() {
            FeatureSection.this.handleNewFeature();
        }
    }
}

