/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.Sorter;

public abstract class MSBRadixSorter
extends Sorter {
    private static final int LEVEL_THRESHOLD = 8;
    private static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;
    private final int[][] histograms = new int[8][];
    private final int[] endOffsets = new int[257];
    private final int maxLength;

    protected MSBRadixSorter(int maxLength) {
        this.maxLength = maxLength;
    }

    protected abstract int byteAt(int var1, int var2);

    protected Sorter getFallbackSorter(final int k) {
        return new IntroSorter(){
            private final BytesRefBuilder pivot = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                MSBRadixSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                for (int o = k; o < MSBRadixSorter.this.maxLength; ++o) {
                    int b2;
                    int b1 = MSBRadixSorter.this.byteAt(i, o);
                    if (b1 != (b2 = MSBRadixSorter.this.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            @Override
            protected void setPivot(int i) {
                int b;
                this.pivot.setLength(0);
                for (int o = k; o < MSBRadixSorter.this.maxLength && (b = MSBRadixSorter.this.byteAt(i, o)) != -1; ++o) {
                    this.pivot.append((byte)b);
                }
            }

            @Override
            protected int comparePivot(int j) {
                for (int o = 0; o < this.pivot.length(); ++o) {
                    int b2;
                    int b1 = this.pivot.byteAt(o) & 0xFF;
                    if (b1 == (b2 = MSBRadixSorter.this.byteAt(j, k + o))) continue;
                    return b1 - b2;
                }
                if (k + this.pivot.length() == MSBRadixSorter.this.maxLength) {
                    return 0;
                }
                return -1 - MSBRadixSorter.this.byteAt(j, k + this.pivot.length());
            }
        };
    }

    @Override
    protected final int compare(int i, int j) {
        throw new UnsupportedOperationException("unused: not a comparison-based sort");
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        this.sort(from, to, 0);
    }

    private void sort(int from, int to, int k) {
        if (to - from <= 100 || k >= 8) {
            this.introSort(from, to, k);
        } else {
            this.radixSort(from, to, k);
        }
    }

    private void introSort(int from, int to, int k) {
        this.getFallbackSorter(k).sort(from, to);
    }

    private void radixSort(int from, int to, int k) {
        int[] histogram = this.histograms[k];
        if (histogram == null) {
            this.histograms[k] = new int[257];
            histogram = this.histograms[k];
        } else {
            Arrays.fill(histogram, 0);
        }
        this.buildHistogram(from, to, k, histogram);
        for (int i = 0; i < 257; ++i) {
            if (histogram[i] == to - from) {
                if (i > 0) {
                    this.sort(from, to, k + 1);
                }
                return;
            }
            if (histogram[i] != 0) break;
        }
        int[] startOffsets = histogram;
        int[] endOffsets = this.endOffsets;
        MSBRadixSorter.sumHistogram(histogram, endOffsets);
        this.reorder(from, to, startOffsets, endOffsets, k);
        endOffsets = startOffsets;
        if (k + 1 < this.maxLength) {
            int prev = endOffsets[0];
            for (int i = 1; i < 257; ++i) {
                int h = endOffsets[i];
                int bucketLen = h - prev;
                if (bucketLen > 1) {
                    this.sort(from + prev, from + h, k + 1);
                }
                prev = h;
            }
        }
    }

    private int getBucket(int i, int k) {
        return this.byteAt(i, k) + 1;
    }

    private int[] buildHistogram(int from, int to, int k, int[] histogram) {
        for (int i = from; i < to; ++i) {
            int n = this.getBucket(i, k);
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }

    private static void sumHistogram(int[] histogram, int[] endOffsets) {
        int accum = 0;
        for (int i = 0; i < 257; ++i) {
            int count = histogram[i];
            histogram[i] = accum;
            endOffsets[i] = accum += count;
        }
    }

    private void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            int h1 = startOffsets[i];
            while (h1 < limit) {
                int h2;
                int b;
                int n = b = this.getBucket(from + h1, k);
                startOffsets[n] = startOffsets[n] + 1;
                this.swap(from + h1, from + h2);
                h1 = startOffsets[i];
            }
        }
    }
}

