/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.explorer;

import java.io.File;
import java.util.Objects;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishLibraryWizard;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;

public class PublishLibraryExplorerHandler
extends AbstractHandler {
    protected IFile selectedFile;

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        IEvaluationContext context;
        Object object;
        this.selectedFile = null;
        if (evaluationContext instanceof IEvaluationContext && (object = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof IStructuredSelection && (selection = (IStructuredSelection)object).size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)selection.getFirstElement();
        }
        if (this.selectedFile != null && Objects.equals(this.selectedFile.getFileExtension(), "rptlibrary")) {
            String url = this.selectedFile.getLocation().toOSString();
            try {
                LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(url);
                if (handle != null) {
                    handle.close();
                    this.setBaseEnabled(true);
                    return;
                }
            }
            catch (DesignFileException designFileException) {
                // empty catch block
            }
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedFile != null) {
            String url = this.selectedFile.getLocation().toOSString();
            try {
                LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(url);
                String filePath = handle.getFileName();
                String fileName = null;
                if (filePath != null && filePath.length() != 0) {
                    fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
                }
                PublishLibraryWizard publishLibrary = new PublishLibraryWizard(handle, fileName, ReportPlugin.getDefault().getResourceFolder());
                BaseWizardDialog dialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)publishLibrary);
                dialog.setPageSize(500, 250);
                dialog.open();
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
                throw new ExecutionException("Error executing command", (Throwable)e);
            }
        }
        return null;
    }
}

