/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.extract;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.ISQLObjectNameHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.DataSerializer;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.ResultSetReader;
import org.eclipse.datatools.sqltools.data.internal.core.extract.Messages;

public class ExtractData {
    protected Connection connection;
    protected Table table;
    protected String filePath;
    protected String colDelim = ",";
    protected static final String ENDL = System.getProperty("line.separator");
    protected String stringDelim = "\"";
    protected HashSet errorColumns = new HashSet();
    protected int rowsExtracted = 0;
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER = "org.eclipse.datatools.modelbase.sql.sqlObjectNameHelper";
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER_DBTYPE = "databaseType";
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER_CLASS = "class";

    public ExtractData(Table table, String filePath) {
        this.connection = ((ICatalogObject)table).getConnection();
        this.table = table;
        this.filePath = filePath;
    }

    public void setDelims(String colDelim, String stringDelim) {
        this.colDelim = colDelim;
        this.stringDelim = stringDelim;
    }

    public int doExtract(Output output) {
        output.write(String.valueOf(Messages.getString("ExtractData.Extracting")) + " " + this.getFullyQualifiedName() + "...");
        try {
            this.doExtract1();
        }
        catch (Exception ex) {
            DataCorePlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            output.write(ex.toString());
            output.write(Messages.getString("ExtractData.DataExtractionFailed"));
            return 6;
        }
        output.write(Messages.getString("ExtractData.DataExtractionSuccessful"));
        output.write(String.valueOf(String.valueOf(this.rowsExtracted)) + Messages.getString("ExtractData.RowsExtracted"));
        if (this.errorColumns.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("ExtractData.ErrorRetrieving"));
            Iterator it = this.errorColumns.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            output.write(sb.toString());
            return 4;
        }
        return 3;
    }

    protected void doExtract1() throws SQLException, IOException {
        Statement st = null;
        ResultSet rs = null;
        BufferedWriter fw = null;
        try {
            st = this.connection.createStatement();
            rs = st.executeQuery(this.getQuery());
            FileOutputStream fos = new FileOutputStream(this.filePath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            fw = new BufferedWriter(osw);
            this.writeData(rs, fw);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    protected void writeData(ResultSet rs, Writer fw) throws SQLException, IOException {
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            int i = 0;
            while (i < md.getColumnCount()) {
                String s;
                if (i != 0) {
                    fw.write(this.colDelim);
                }
                if ((s = this.getVal(rs, i)) != null) {
                    fw.write(s);
                } else {
                    fw.write("NULL");
                }
                ++i;
            }
            ++this.rowsExtracted;
            fw.write(ENDL);
        }
    }

    public String getVal(ResultSet rs, int column) throws SQLException, IOException {
        ResultSetMetaData md = rs.getMetaData();
        try {
            Object o = ResultSetReader.read(rs, column);
            String s = DataSerializer.write(o, md.getColumnType(column + 1), this.stringDelim);
            return s;
        }
        catch (Exception exception) {
            this.errorColumns.add(md.getColumnName(column + 1));
            return null;
        }
    }

    protected String getQuery() {
        Database database = null;
        StringBuffer sb = new StringBuffer("select * from ");
        String tableName = null;
        database = this.getDatabase(this.table.getSchema());
        String quote = "\"";
        try {
            quote = this.connection.getMetaData().getIdentifierQuoteString();
        }
        catch (Exception exception) {}
        ISQLObjectNameHelper nameProvider = this.getSQLObjectNameHelper(database);
        if (nameProvider != null) {
            nameProvider.setIdentifierQuoteString(quote);
            tableName = nameProvider.getQualifiedNameInSQLFormat(this.table);
        }
        if (tableName == null) {
            tableName = this.getFullyQualifiedName();
        }
        sb.append(tableName);
        return sb.toString();
    }

    protected String getFullyQualifiedName() {
        return DataCorePlugin.getQualifiedTableName(this.table);
    }

    private ISQLObjectNameHelper getSQLObjectNameHelper(Database database) {
        ISQLObjectNameHelper nameHelper = null;
        if (database != null) {
            String currentDBVendor = database.getVendor();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint nameHandlerExtensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_SQL_OBJECT_NAME_HELPER);
            IExtension[] nameHandlerExtensions = nameHandlerExtensionPoint.getExtensions();
            int i = 0;
            while (i < nameHandlerExtensions.length && nameHelper == null) {
                IExtension ext = nameHandlerExtensions[i];
                IConfigurationElement[] configElements = ext.getConfigurationElements();
                int j = 0;
                while (j < configElements.length && nameHelper == null) {
                    String extVendor = configElements[j].getAttribute(EXTERNAL_SQL_OBJECT_NAME_HELPER_DBTYPE);
                    if (currentDBVendor.equalsIgnoreCase(extVendor)) {
                        try {
                            Object executableExtension = configElements[j].createExecutableExtension(EXTERNAL_SQL_OBJECT_NAME_HELPER_CLASS);
                            if (executableExtension instanceof ISQLObjectNameHelper) {
                                nameHelper = (ISQLObjectNameHelper)executableExtension;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++j;
                }
                ++i;
            }
        }
        return nameHelper;
    }

    private Database getDatabase(Schema schema) {
        return schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
    }
}

