/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class MovedTextFileChange
extends TextFileChange {
    private IFile fCurrentFile;

    public MovedTextFileChange(String name, IFile newFile, IFile currentFile) {
        super(name, newFile);
        this.fCurrentFile = currentFile;
    }

    public IDocument getCurrentDocument(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        IDocument result = null;
        pm.beginTask("", 2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            IPath path = this.fCurrentFile.getFullPath();
            manager.connect(path, LocationKind.NORMALIZE, pm);
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
            result = buffer.getDocument();
        }
        finally {
            if (result != null) {
                manager.disconnect(this.fCurrentFile.getFullPath(), LocationKind.NORMALIZE, pm);
            }
        }
        pm.done();
        return result;
    }
}

