/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.HashMap;
import java.util.Map;

public class BulletFrame {
    public static String CSS_LISTSTYLETYPE_DISC_VALUE = "disc";
    public static String CSS_LISTSTYLETYPE_CIRCLE_VALUE = "circle";
    public static String CSS_LISTSTYLETYPE_SQUARE_VALUE = "square";
    public static String CSS_LISTSTYLETYPE_DECIMALLEADINGZERO_VALUE = "decimal-leading-zero";
    public static String CSS_LISTSTYLETYPE_LOWERROMAN_VALUE = "lower-roman";
    public static String CSS_LISTSTYLETYPE_UPPERROMAN_VALUE = "upper-roman";
    public static String CSS_LISTSTYLETYPE_LOWERGREEK_VALUE = "lower-greek";
    public static String CSS_LISTSTYLETYPE_LOWERLATINC_VALUE = "lower-latin";
    public static String CSS_LISTSTYLETYPE_UPPERLATIN_VALUE = "upper-latin";
    public static String CSS_LISTSTYLETYPE_ARMENIAN_VALUE = "armenian";
    public static String CSS_LISTSTYLETYPE_GEORGIAN_VALUE = "georgian";
    public static String CSS_LISTSTYLETYPE_LOWERALPHA_VALUE = "lower-alpha";
    public static String CSS_LISTSTYLETYPE_UPPERALPHA_VALUE = "upper-alpha";
    public static String CSS_LISTSTYLETYPE_NONE_VALUE = "none";
    public static String CSS_LISTSTYLETYPE_INHERIT_VALUE = "inherit";
    public static String CSS_LISTSTYLETYPE_DECIMAL = "decimal";
    public static final int LIST_DISC_VALUE = 0;
    public static final int LIST_STYLE_CIRCLE = 1;
    public static final int LIST_STYLE_SQUARE = 2;
    public static final int LIST_STYLE_DECIMALLEADINGZERO = 3;
    public static final int LIST_STYLE_LOWERROMAN = 4;
    public static final int LIST_STYLE_UPPERROMAN = 5;
    public static final int LIST_STYLE_LOWERGREEK = 6;
    public static final int LIST_STYLE_UPPERLATIN = 7;
    public static final int LIST_STYLE_LOWERLATIN = 8;
    public static final int LIST_STYLE_ARMENIAN = 9;
    public static final int LIST_STYLE_GEORGIAN = 10;
    public static final int LIST_STYLE_LOWERALPHA = 11;
    public static final int LIST_STYLE_UPPERALPHA = 12;
    public static final int LIST_STYLE_NONE = 13;
    public static final int LIST_STYLE_INHERIT = 14;
    public static final int LIST_STYLE_DECIMAL = 15;
    public static final Map<String, Integer> TYPES = new HashMap<String, Integer>();
    public static final String EMPTYSTRING = "";
    public static final char DISC_CHAR = '\u2022';
    public static final char CIRCLE_CHAR = '\u25e6';
    public static final char SQUARE_CHAR = '\u25aa';
    public static final char ZERO_CHAR = '0';
    public static final int ALPHA_SIZE = 26;
    public static final char[] LOWER_ALPHA_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] UPPER_ALPHA_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final int LOWER_GREEK_CHARS_SIZE = 24;
    public static final char[] LOWER_GREEK_CHARS = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9'};
    public static final char[] LOWER_ROMAN_CHARSA = new char[]{'i', 'x', 'c', 'm'};
    public static final char[] UPPER_ROMAN_CHARSA = new char[]{'I', 'X', 'C', 'M'};
    public static final char[] LOWER_ROMAN_CHARSB = new char[]{'v', 'l', 'd'};
    public static final char[] UPPER_ROMAN_CHARSB = new char[]{'V', 'L', 'D'};
    public static char[] GEORGIAN_VALUE = new char[]{'\u10d0', '\u10d1', '\u10d2', '\u10d3', '\u10d4', '\u10d5', '\u10d6', '\u10f1', '\u10d7', '\u10d8', '\u10d9', '\u10da', '\u10db', '\u10dc', '\u10f2', '\u10dd', '\u10de', '\u10df', '\u10e0', '\u10e1', '\u10e2', '\u10f3', '\u10e4', '\u10e5', '\u10e6', '\u10e7', '\u10e8', '\u10e9', '\u10ea', '\u10eb', '\u10ec', '\u10ed', '\u10ee', '\u10f4', '\u10ef', '\u10f0', '\u10f5'};
    private int type;

    static {
        TYPES.put(CSS_LISTSTYLETYPE_DISC_VALUE, 0);
        TYPES.put(CSS_LISTSTYLETYPE_CIRCLE_VALUE, 1);
        TYPES.put(CSS_LISTSTYLETYPE_SQUARE_VALUE, 2);
        TYPES.put(CSS_LISTSTYLETYPE_DECIMALLEADINGZERO_VALUE, 3);
        TYPES.put(CSS_LISTSTYLETYPE_LOWERROMAN_VALUE, 4);
        TYPES.put(CSS_LISTSTYLETYPE_UPPERROMAN_VALUE, 5);
        TYPES.put(CSS_LISTSTYLETYPE_LOWERGREEK_VALUE, 6);
        TYPES.put(CSS_LISTSTYLETYPE_LOWERLATINC_VALUE, 8);
        TYPES.put(CSS_LISTSTYLETYPE_UPPERLATIN_VALUE, 7);
        TYPES.put(CSS_LISTSTYLETYPE_ARMENIAN_VALUE, 9);
        TYPES.put(CSS_LISTSTYLETYPE_GEORGIAN_VALUE, 10);
        TYPES.put(CSS_LISTSTYLETYPE_LOWERALPHA_VALUE, 11);
        TYPES.put(CSS_LISTSTYLETYPE_UPPERALPHA_VALUE, 12);
        TYPES.put(CSS_LISTSTYLETYPE_NONE_VALUE, 13);
        TYPES.put(CSS_LISTSTYLETYPE_INHERIT_VALUE, 14);
        TYPES.put(CSS_LISTSTYLETYPE_DECIMAL, 15);
    }

    public BulletFrame(String styleType) {
        this.initial(styleType);
    }

    private void initial(String styleType) {
        this.type = TYPES.get(styleType) != null ? TYPES.get(styleType) : 13;
    }

    public String paintBullet(int ordinal) {
        StringBuffer buffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                buffer.append('\u2022');
                break;
            }
            case 1: {
                buffer.append('\u25e6');
                break;
            }
            case 2: {
                buffer.append('\u25aa');
                break;
            }
            case 3: {
                this.decimalLeadingZeroToText(ordinal, buffer);
                break;
            }
            case 4: {
                this.romanToText(ordinal, buffer, LOWER_ROMAN_CHARSA, LOWER_ROMAN_CHARSB);
                break;
            }
            case 5: {
                this.romanToText(ordinal, buffer, UPPER_ROMAN_CHARSA, UPPER_ROMAN_CHARSB);
                break;
            }
            case 6: {
                this.charListToText(ordinal, buffer, LOWER_GREEK_CHARS, 24);
                break;
            }
            case 7: 
            case 12: {
                this.charListToText(ordinal, buffer, UPPER_ALPHA_CHARS, 26);
                break;
            }
            case 8: 
            case 11: {
                this.charListToText(ordinal, buffer, LOWER_ALPHA_CHARS, 26);
                break;
            }
            case 9: {
                this.armenianToText(ordinal, buffer);
                break;
            }
            case 10: {
                this.georgianToText(ordinal, buffer);
                break;
            }
            case 15: {
                this.decimalToText(ordinal, buffer);
                break;
            }
            default: {
                buffer.append(EMPTYSTRING);
            }
        }
        return buffer.toString();
    }

    private void decimalToText(int ordinal, StringBuffer buffer) {
        buffer.append(ordinal);
    }

    private void georgianToText(int ordinal, StringBuffer buffer) {
        if (ordinal < 1 || ordinal > 19999) {
            buffer.append(ordinal);
            return;
        }
        int d = 0;
        do {
            int cur;
            if ((cur = ordinal % 10) > 0) {
                char u = GEORGIAN_VALUE[d * 9 + (cur - 1)];
                buffer.append(u);
            }
            ++d;
        } while ((ordinal /= 10) > 0);
        buffer.reverse();
    }

    private void armenianToText(int ordinal, StringBuffer buffer) {
        if (ordinal < 1 || ordinal > 9999) {
            buffer.append(ordinal);
            return;
        }
        int d = 0;
        do {
            int cur;
            if ((cur = ordinal % 10) > 0) {
                char u = (char)(1328 + d * 9 + cur);
                buffer.append(u);
            }
            ++d;
        } while ((ordinal /= 10) > 0);
        buffer.reverse();
    }

    private void charListToText(int ordinal, StringBuffer buffer, char[] chars, int aBase) {
        if (ordinal < 1) {
            buffer.append(ordinal);
            return;
        }
        do {
            int cur = --ordinal % aBase;
            buffer.append(chars[cur]);
        } while ((ordinal /= aBase) > 0);
        buffer.reverse();
    }

    private void decimalLeadingZeroToText(int ordinal, StringBuffer buffer) {
        if (ordinal < 10 && ordinal > 0) {
            buffer.append('0');
        }
        buffer.append(ordinal);
    }

    private void romanToText(int ordinal, StringBuffer buffer, char[] achars, char[] bchars) {
        if (ordinal < 1 && ordinal > 3999) {
            buffer.append(ordinal);
            return;
        }
        StringBuffer addOn = new StringBuffer();
        StringBuffer decStr = new StringBuffer();
        decStr.append(ordinal);
        int len = decStr.length();
        int dp = 0;
        int end = len;
        int romanPos = len;
        while (dp < end) {
            --romanPos;
            switch (decStr.charAt(dp)) {
                case '3': {
                    addOn.append(achars[romanPos]);
                }
                case '2': {
                    addOn.append(achars[romanPos]);
                }
                case '1': {
                    addOn.append(achars[romanPos]);
                    break;
                }
                case '4': {
                    addOn.append(achars[romanPos]);
                }
                case '5': 
                case '6': 
                case '7': 
                case '8': {
                    addOn.append(bchars[romanPos]);
                    int n = 0;
                    while (53 + n < decStr.charAt(dp)) {
                        addOn.append(achars[romanPos]);
                        ++n;
                    }
                    break;
                }
                case '9': {
                    addOn.append(achars[romanPos]);
                    addOn.append(achars[romanPos + 1]);
                    break;
                }
            }
            ++dp;
        }
        buffer.append(addOn);
    }
}

