/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PDFImageLM
extends PDFLeafItemLM {
    protected static final int DEFAULT_WIDHT = 212000;
    protected static final int DEFAULT_HEIGHT = 130000;
    protected IImageContent image;
    protected ContainerArea root;
    private Dimension intrinsic;
    private static final String BOOKMARK_PREFIX = "javascript:catchBookmark('";

    public PDFImageLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.init();
    }

    protected Dimension getIntrinsicDimension(IImageContent content) throws BadElementException, MalformedURLException, IOException {
        Image image = null;
        switch (content.getImageSource()) {
            case 0: {
                ReportDesignHandle design = content.getReportContent().getDesign().getReportDesign();
                URL url = design.findResource(content.getURI(), 1, content.getReportContent().getReportContext() == null ? null : content.getReportContent().getReportContext().getAppContext());
                InputStream in = url.openStream();
                try {
                    Throwable throwable = null;
                    Object var7_11 = null;
                    try {
                        try {
                            byte[] buffer = new byte[in.available()];
                            in.read(buffer);
                            image = Image.getInstance((byte[])buffer);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
                break;
            }
            case 1: 
            case 2: {
                image = Image.getInstance((byte[])content.getData());
                break;
            }
            case 3: {
                image = Image.getInstance((URL)new URL(content.getURI()));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (image != null) {
            int resolution = 96;
            int contentResolution = content.getResolution();
            if (contentResolution != 0) {
                resolution = contentResolution;
            }
            return new Dimension((int)(image.getPlainWidth() * 1000.0f / (float)resolution * 72.0f), (int)(image.getPlainHeight() * 1000.0f / (float)resolution * 72.0f));
        }
        return null;
    }

    protected Dimension getSpecifiedDimension(IImageContent content, int pWidth, boolean scale) {
        Dimension dim = new Dimension(212000, 130000);
        try {
            this.intrinsic = this.getIntrinsicDimension(content);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        int specifiedWidth = this.getDimensionValue(content.getWidth(), pWidth);
        int specifiedHeight = this.getDimensionValue(content.getHeight());
        if (this.intrinsic == null) {
            dim.setDimension(specifiedWidth == 0 ? 212000 : specifiedWidth, specifiedHeight == 0 ? 130000 : specifiedHeight);
            return dim;
        }
        if (scale) {
            double ratio = this.intrinsic.getRatio();
            if (specifiedWidth > 0) {
                if (specifiedHeight > 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                }
            } else if (specifiedHeight > 0) {
                dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
            } else {
                dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
            }
        } else if (specifiedWidth > 0) {
            if (specifiedHeight > 0) {
                dim.setDimension(specifiedWidth, specifiedHeight);
            } else {
                dim.setDimension(specifiedWidth, this.intrinsic.getHeight());
            }
        } else if (specifiedHeight > 0) {
            dim.setDimension(this.intrinsic.getWidth(), specifiedHeight);
        } else {
            dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
        }
        return dim;
    }

    @Override
    public boolean layoutChildren() {
        if (this.root == null) {
            return false;
        }
        if (PropertyUtil.isInlineElement(this.image)) {
            assert (this.parent instanceof ILineStackingLayoutManager);
            ILineStackingLayoutManager lineParent = (ILineStackingLayoutManager)((Object)this.parent);
            if (this.root.getAllocatedWidth() > this.parent.getCurrentMaxContentWidth() && !lineParent.isEmptyLine()) {
                boolean ret = lineParent.endLine();
                assert (ret);
                return this.layoutChildren();
            }
        }
        if (this.root.getAllocatedHeight() > this.parent.getCurrentMaxContentHeight()) {
            if (!this.parent.isPageEmpty()) {
                this.context.setAutoPageBreak(true);
                return true;
            }
            this.parent.addArea(this.root, false, false);
            return false;
        }
        this.parent.addArea(this.root, false, false);
        return false;
    }

    protected void init() {
        assert (this.content instanceof IImageContent);
        this.image = (IImageContent)this.content;
        this.root = PropertyUtil.isInlineElement(this.image) ? (ContainerArea)AreaFactory.createInlineContainer(this.image, true, true) : (ContainerArea)AreaFactory.createBlockContainer(this.image);
        this.root.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        Dimension contentDimension = this.getSpecifiedDimension(this.image, this.root.getContentWidth(), true);
        ImageArea imageArea = (ImageArea)AreaFactory.createImageArea(this.image);
        imageArea.setWidth(contentDimension.getWidth());
        imageArea.setHeight(contentDimension.getHeight());
        this.root.addChild(imageArea);
        imageArea.setPosition(this.root.getContentX(), this.root.getContentY());
        this.root.setContentWidth(imageArea.getWidth());
        this.root.setContentHeight(imageArea.getHeight());
        this.processChartLegend(this.image, imageArea);
    }

    private void processChartLegend(IImageContent imageContent, IImageArea imageArea) {
        boolean hasImageMap;
        if (this.intrinsic == null) {
            return;
        }
        Object imageMapObject = imageContent.getImageMap();
        boolean bl = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
        if (hasImageMap) {
            this.createImageMap((String)imageMapObject, imageArea);
        }
    }

    private void createImageMap(String imageMapObject, IImageArea imageArea) {
        Pattern pattern = Pattern.compile("<AREA[^<>]*coords=\"([\\d,]*)\" href=\"([^<>\"]*)\" target=\"([^<>\"]*)\"/>");
        Matcher matcher = pattern.matcher(imageMapObject);
        while (matcher.find()) {
            try {
                int[] area = this.getArea(matcher.group(1));
                String url = matcher.group(2);
                String targetWindow = matcher.group(3);
                this.createImageMap(area, imageArea, url, targetWindow);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void createImageMap(int[] area, IImageArea imageArea, String url, String targetWindow) {
        if (url == null) {
            return;
        }
        ActionContent link = new ActionContent();
        if (this.isBookmark(url)) {
            String bookmark = this.getBookmark(url);
            link.setBookmark(bookmark);
        } else {
            link.setHyperlink(url, targetWindow);
        }
        area = this.getAbsoluteArea(area, imageArea);
        this.createImageMapContainer(area[0], area[1], area[2], area[3], link);
    }

    private void createImageMapContainer(int x, int y, int width, int height, IHyperlinkAction link) {
        ReportContent reportContent = (ReportContent)this.image.getReportContent();
        IContainerContent mapContent = reportContent.createContainerContent();
        mapContent.setHyperlinkAction(link);
        BlockContainerArea area = (BlockContainerArea)AreaFactory.createBlockContainer(mapContent);
        area.setPosition(x, y);
        area.setWidth(width);
        area.setHeight(height);
        this.root.addChild(area);
    }

    private int[] getAbsoluteArea(int[] area, IImageArea imageArea) {
        assert (this.intrinsic != null);
        int i = 0;
        while (i < 4) {
            area[i] = this.getTranslatedLength(area[i]);
            ++i;
        }
        int[] result = new int[4];
        int imageX = imageArea.getX();
        int imageY = imageArea.getY();
        int imageHeight = imageArea.getHeight();
        int imageWidth = imageArea.getWidth();
        int intrinsicWidth = this.intrinsic.getWidth();
        int intrinsicHeight = this.intrinsic.getHeight();
        float ratio = (float)imageWidth / (float)intrinsicWidth;
        result[0] = imageX + (int)((float)area[0] * ratio);
        result[2] = (int)((float)area[2] * ratio);
        ratio = (float)imageHeight / (float)intrinsicHeight;
        result[1] = imageY + (int)((float)area[1] * ratio);
        result[3] = (int)((float)area[3] * ratio);
        return result;
    }

    private int getTranslatedLength(int length) {
        return length * 1000 / 192 * 72;
    }

    private boolean isBookmark(String url) {
        return url.startsWith(BOOKMARK_PREFIX) && url.endsWith("')");
    }

    private String getBookmark(String url) {
        int start = url.indexOf(BOOKMARK_PREFIX) + BOOKMARK_PREFIX.length();
        int end = url.length() - 2;
        return url.substring(start, end);
    }

    private int[] getArea(String string) {
        int[] area;
        String[] rawDatas = string.split(",");
        area = new int[]{Integer.parseInt(rawDatas[0]), Integer.parseInt(rawDatas[1]), Integer.parseInt(rawDatas[4]) - area[0], Integer.parseInt(rawDatas[5]) - area[1]};
        return area;
    }
}

