/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Map;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.content.IDrillThroughAction;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;

public class Action
implements IAction {
    protected IHyperlinkAction content;
    protected String systemId;

    public Action(String systemId, IHyperlinkAction content) {
        this.systemId = systemId;
        this.content = content;
    }

    public Action(IHyperlinkAction content) {
        this.content = content;
    }

    @Override
    public int getType() {
        return this.content.getType();
    }

    @Override
    public String getBookmark() {
        return this.content.getBookmark();
    }

    @Override
    public String getActionString() {
        switch (this.content.getType()) {
            case 1: {
                return this.content.getHyperlink();
            }
            case 2: {
                return this.content.getBookmark();
            }
        }
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getReportName() {
        return this.content.getReportName();
    }

    @Override
    public Map getParameterBindings() {
        return this.content.getParameterBindings();
    }

    @Override
    public Map getSearchCriteria() {
        return this.content.getSearchCriteria();
    }

    @Override
    public String getTargetWindow() {
        return this.content.getTargetWindow();
    }

    @Override
    public String getFormat() {
        return this.content.getFormat();
    }

    @Override
    public boolean isBookmark() {
        return this.content.isBookmark();
    }

    @Override
    public String getTargetFileType() {
        IDrillThroughAction drillThrough = this.content.getDrillThrough();
        if (drillThrough == null) {
            return null;
        }
        return drillThrough.getTargetFileType();
    }

    @Override
    public String getTooltip() {
        return this.content.getTooltip();
    }
}

