/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ShowModelProviderAction
extends Action {
    private final ISynchronizePageConfiguration configuration;
    private final ModelProvider provider;

    public ShowModelProviderAction(ISynchronizePageConfiguration configuration, ModelProvider provider) {
        super(Utils.getLabel(provider), 8);
        this.configuration = configuration;
        this.provider = provider;
        this.setImageDescriptor(this.getImageDescriptor(provider));
    }

    private ImageDescriptor getImageDescriptor(ModelProvider provider) {
        ITeamContentProviderManager manager = TeamUI.getTeamContentProviderManager();
        ITeamContentProviderDescriptor desc = manager.getDescriptor(provider.getId());
        return desc.getImageDescriptor();
    }

    public void run() {
        this.configuration.setProperty("org.eclipse.team.ui.activeModelProvider", this.provider.getDescriptor().getId());
    }

    public String getProviderId() {
        return this.provider.getDescriptor().getId();
    }
}

