/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DataInputUtil;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.NoSpaceOnPage;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.PageVersion;
import org.apache.derby.impl.store.raw.data.RawField;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.RememberBytesInputStream;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;

public class StoredPage
extends CachedPage {
    public static final int FORMAT_NUMBER = 117;
    protected static final int PAGE_HEADER_OFFSET = 4;
    protected static final int PAGE_HEADER_SIZE = 56;
    protected static final int RECORD_SPACE_OFFSET = 60;
    protected static final int PAGE_VERSION_OFFSET = 6;
    protected static final int SMALL_SLOT_SIZE = 2;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int OVERFLOW_POINTER_SIZE = 12;
    protected static final int OVERFLOW_PTR_FIELD_SIZE = 14;
    ByteHolder bh = null;
    protected static final int COLUMN_NONE = 0;
    protected static final int COLUMN_FIRST = 1;
    protected static final int COLUMN_LONG = 2;
    protected static final int COLUMN_CREATE_NULL = 3;
    private int maxFieldSize;
    private boolean isOverflowPage;
    private int slotsInUse;
    private int nextId;
    private int generation;
    private int prevGeneration;
    private long bipLocation;
    private int deletedRowCount;
    private boolean headerOutOfDate;
    private CRC32 checksum;
    protected int minimumRecordSize;
    private int userRowSize;
    private int slotFieldSize;
    private int slotEntrySize;
    private int slotTableOffsetToFirstEntry;
    private int slotTableOffsetToFirstRecordLengthField;
    private int slotTableOffsetToFirstReservedSpaceField;
    protected int totalSpace;
    protected int freeSpace = Integer.MIN_VALUE;
    private int firstFreeByte = Integer.MIN_VALUE;
    protected int spareSpace;
    private StoredRecordHeader overflowRecordHeader;
    protected ArrayInputStream rawDataIn;
    protected ArrayOutputStream rawDataOut;
    protected FormatIdOutputStream logicalDataOut;

    @Override
    public int getTypeFormatId() {
        return 117;
    }

    private StoredRecordHeader getOverFlowRecordHeader() throws StandardException {
        return this.overflowRecordHeader != null ? this.overflowRecordHeader : (this.overflowRecordHeader = new StoredRecordHeader());
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.rawDataIn == null) {
            this.rawDataIn = new ArrayInputStream();
            this.checksum = new CRC32();
        }
        if (this.pageData != null) {
            this.rawDataIn.setData(this.pageData);
        }
    }

    private void createOutStreams() {
        this.rawDataOut = new ArrayOutputStream();
        this.rawDataOut.setData(this.pageData);
        this.logicalDataOut = new FormatIdOutputStream(this.rawDataOut);
    }

    private void setOutputStream(OutputStream outputStream) {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        this.logicalDataOut.setOutput(outputStream);
    }

    private void resetOutputStream() {
        this.logicalDataOut.setOutput(this.rawDataOut);
    }

    @Override
    protected void usePageBuffer(byte[] byArray) {
        this.pageData = byArray;
        int n = this.pageData.length;
        if (this.rawDataIn != null) {
            this.rawDataIn.setData(this.pageData);
        }
        this.slotFieldSize = this.calculateSlotFieldSize(n);
        this.slotEntrySize = 3 * this.slotFieldSize;
        this.initSpace();
        this.slotTableOffsetToFirstEntry = n - 8 - this.slotEntrySize;
        this.slotTableOffsetToFirstRecordLengthField = this.slotTableOffsetToFirstEntry + this.slotFieldSize;
        this.slotTableOffsetToFirstReservedSpaceField = this.slotTableOffsetToFirstEntry + 2 * this.slotFieldSize;
        if (this.rawDataOut != null) {
            this.rawDataOut.setData(this.pageData);
        }
    }

    private int calculateSlotFieldSize(int n) {
        if (n < 65536) {
            return 2;
        }
        return 4;
    }

    @Override
    protected void createPage(PageKey pageKey, PageCreationArgs pageCreationArgs) throws StandardException {
        this.spareSpace = pageCreationArgs.spareSpace;
        this.minimumRecordSize = pageCreationArgs.minimumRecordSize;
        this.setPageArray(pageCreationArgs.pageSize);
        this.cleanPage();
        this.setPageVersion(0L);
        this.nextId = 6;
        this.generation = 0;
        this.prevGeneration = 0;
        this.bipLocation = 0L;
        this.createOutStreams();
    }

    @Override
    protected void initFromData(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        if (fileContainer != null) {
            this.spareSpace = fileContainer.getSpareSpace();
            this.minimumRecordSize = fileContainer.getMinimumRecordSize();
        }
        try {
            this.validateChecksum(pageKey);
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("XSDG2.D")) {
                int n = this.getPageSize();
                byte[] byArray = this.pageData;
                this.pageData = null;
                this.setPageArray(n);
                try {
                    fileContainer.readPage(pageKey.getPageNumber(), this.pageData);
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
                }
                try {
                    this.validateChecksum(pageKey);
                }
                catch (StandardException standardException2) {
                    throw this.dataFactory.markCorrupt(standardException);
                }
                String string = StoredPage.pagedataToHexDump(byArray);
                String string2 = StoredPage.pagedataToHexDump(byArray);
                throw StandardException.newException("XSDFD.S", standardException, pageKey, string, string2);
            }
            throw standardException;
        }
        try {
            this.readPageHeader();
            this.initSlotTable(pageKey);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    protected void validateChecksum(PageKey pageKey) throws StandardException {
        long l;
        try {
            this.rawDataIn.setPosition(this.getPageSize() - 8);
            l = this.rawDataIn.readLong();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        if (l != this.checksum.getValue()) {
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(this.pageData, 0, this.getPageSize() - 8);
            if (l != cRC32.getValue()) {
                throw StandardException.newException("XSDG2.D", pageKey, new Long(this.checksum.getValue()), new Long(l), StoredPage.pagedataToHexDump(this.pageData));
            }
            this.checksum = cRC32;
        }
    }

    protected void updateChecksum() throws IOException {
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        this.rawDataOut.setPosition(this.getPageSize() - 8);
        this.logicalDataOut.writeLong(this.checksum.getValue());
    }

    @Override
    protected void writePage(PageKey pageKey) throws StandardException {
        try {
            if (this.headerOutOfDate) {
                this.updatePageHeader();
            } else {
                this.updatePageVersion();
            }
            this.updateChecksum();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    @Override
    protected void writeFormatId(PageKey pageKey) throws StandardException {
        try {
            if (this.rawDataOut == null) {
                this.createOutStreams();
            }
            this.rawDataOut.setPosition(0);
            FormatIdUtil.writeFormatIdInteger(this.logicalDataOut, this.getTypeFormatId());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    @Override
    protected void releaseExclusive() {
        super.releaseExclusive();
        this.pageCache.release(this);
    }

    @Override
    public int getTotalSpace(int n) throws StandardException {
        try {
            this.rawDataIn.setPosition(this.getSlotOffset(n) + this.slotFieldSize);
            return this.slotFieldSize == 2 ? this.rawDataIn.readUnsignedShort() + this.rawDataIn.readUnsignedShort() : this.rawDataIn.readInt() + this.rawDataIn.readInt();
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    @Override
    public boolean spaceForInsert() throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        int n = this.totalSpace - this.freeSpace;
        int n2 = n / this.slotsInUse;
        return n2 <= this.freeSpace;
    }

    @Override
    public boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n) throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, 0, (byte)1, -1, -1, n);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return true;
    }

    private boolean spaceForInsert(Object[] objectArray, FormatableBitSet formatableBitSet, int n, int n2, int n3) throws StandardException {
        if (!this.spaceForInsert() || this.freeSpace < n) {
            return false;
        }
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, n2, (byte)1, -1, -1, n3);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return false;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return true;
    }

    @Override
    public boolean unfilled() {
        return this.allowInsert() && this.freeSpace > this.getPageSize() / 2;
    }

    @Override
    public boolean allowInsert() {
        if (this.slotsInUse == 0) {
            return true;
        }
        int n = this.freeSpace;
        if ((n -= this.slotEntrySize) < this.minimumRecordSize || n < 17) {
            return false;
        }
        return n * 100 / this.totalSpace >= this.spareSpace;
    }

    @Override
    public boolean spaceForCopy(int n, int[] nArray) {
        int n2 = this.slotEntrySize * n;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= 0) continue;
            n2 += nArray[i] >= this.minimumRecordSize ? nArray[i] : this.minimumRecordSize;
        }
        return this.freeSpace - n2 >= 0;
    }

    protected boolean spaceForCopy(int n, int n2) {
        int n3 = this.slotEntrySize + ((n = n - StoredRecordHeader.getStoredSizeRecordId(n2) + StoredRecordHeader.getStoredSizeRecordId(this.nextId)) >= this.minimumRecordSize ? n : this.minimumRecordSize);
        return this.freeSpace - n3 >= 0;
    }

    @Override
    protected boolean restoreRecordFromSlot(int n, Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader, boolean bl) throws StandardException {
        try {
            int n2 = this.getRecordOffset(n) + storedRecordHeader.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2);
            if (!storedRecordHeader.hasOverflow()) {
                if (bl && fetchDescriptor != null && fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                    if (!this.qualifyRecordFromSlot(objectArray, n2, fetchDescriptor, storedRecordHeader, recordHandle)) {
                        return false;
                    }
                    arrayInputStream.setPosition(n2);
                }
                if (fetchDescriptor != null) {
                    this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, recordHandle);
                } else {
                    this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, recordHandle);
                }
                return true;
            }
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader, recordHandle);
            }
            while (storedRecordHeader != null) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                storedRecordHeader = storedPage.restoreLongRecordFromSlot(objectArray, fetchDescriptor, recordHandle, storedRecordHeader);
                storedPage.unlatch();
                storedPage = null;
            }
            return fetchDescriptor == null || fetchDescriptor.getQualifierList() == null || this.qualifyRecordFromRow(objectArray, fetchDescriptor.getQualifierList());
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    private StoredRecordHeader restoreLongRecordFromSlot(Object[] objectArray, FetchDescriptor fetchDescriptor, RecordHandle recordHandle, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n = this.findRecordById(storedRecordHeader.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader2 = this.getHeaderAtSlot(n);
        try {
            int n2 = this.getRecordOffset(n) + storedRecordHeader2.size();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2);
            if (fetchDescriptor != null) {
                if (fetchDescriptor.getQualifierList() != null) {
                    fetchDescriptor.reset();
                }
                this.readRecordFromArray(objectArray, fetchDescriptor.getValidColumns() == null ? objectArray.length - 1 : fetchDescriptor.getMaxFetchColumnId(), fetchDescriptor.getValidColumnsArray(), fetchDescriptor.getMaterializedColumns(), arrayInputStream, storedRecordHeader2, recordHandle);
            } else {
                this.readRecordFromArray(objectArray, objectArray.length - 1, null, null, arrayInputStream, storedRecordHeader2, recordHandle);
            }
            return storedRecordHeader2.hasOverflow() ? storedRecordHeader2 : null;
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    @Override
    public int newRecordId() {
        return this.nextId;
    }

    @Override
    public int newRecordIdAndBump() {
        this.headerOutOfDate = true;
        return this.nextId++;
    }

    @Override
    protected int newRecordId(int n) {
        return n + 1;
    }

    @Override
    public boolean isOverflowPage() {
        return this.isOverflowPage;
    }

    public final int getPageSize() {
        return this.pageData.length;
    }

    protected final void clearSection(int n, int n2) {
        Arrays.fill(this.pageData, n, n + n2, (byte)0);
    }

    protected int getMaxFreeSpace() {
        return this.getPageSize() - 60 - 8;
    }

    protected int getCurrentFreeSpace() {
        return this.freeSpace;
    }

    private void readPageHeader() throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(4);
        this.isOverflowPage = arrayInputStream.readBoolean();
        this.setPageStatus(arrayInputStream.readByte());
        this.setPageVersion(arrayInputStream.readLong());
        this.slotsInUse = arrayInputStream.readUnsignedShort();
        this.nextId = arrayInputStream.readInt();
        this.generation = arrayInputStream.readInt();
        this.prevGeneration = arrayInputStream.readInt();
        this.bipLocation = arrayInputStream.readLong();
        this.deletedRowCount = arrayInputStream.readUnsignedShort() - 1;
        long l = arrayInputStream.readUnsignedShort();
        l = arrayInputStream.readInt();
        l = arrayInputStream.readLong();
        l = arrayInputStream.readLong();
    }

    private void updatePageHeader() throws IOException {
        this.rawDataOut.setPosition(4);
        this.logicalDataOut.writeBoolean(this.isOverflowPage);
        this.logicalDataOut.writeByte(this.getPageStatus());
        this.logicalDataOut.writeLong(this.getPageVersion());
        this.logicalDataOut.writeShort(this.slotsInUse);
        this.logicalDataOut.writeInt(this.nextId);
        this.logicalDataOut.writeInt(this.generation);
        this.logicalDataOut.writeInt(this.prevGeneration);
        this.logicalDataOut.writeLong(this.bipLocation);
        this.logicalDataOut.writeShort(this.deletedRowCount + 1);
        this.logicalDataOut.writeShort(0);
        this.logicalDataOut.writeInt(this.dataFactory.random());
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.headerOutOfDate = false;
    }

    private void updatePageVersion() throws IOException {
        this.rawDataOut.setPosition(6);
        this.logicalDataOut.writeLong(this.getPageVersion());
    }

    private int getSlotOffset(int n) {
        return this.slotTableOffsetToFirstEntry - n * this.slotEntrySize;
    }

    private int getRecordOffset(int n) {
        byte[] byArray = this.pageData;
        int n2 = this.slotTableOffsetToFirstEntry - n * this.slotEntrySize;
        return this.slotFieldSize == 2 ? (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF : (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void setRecordOffset(int n, int n2) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
        } else {
            this.logicalDataOut.writeInt(n2);
        }
    }

    protected int getRecordPortionLength(int n) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstRecordLengthField - n * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    @Override
    public int getReservedCount(int n) throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(this.slotTableOffsetToFirstReservedSpaceField - n * this.slotEntrySize);
        return this.slotFieldSize == 2 ? arrayInputStream.readUnsignedShort() : arrayInputStream.readInt();
    }

    private void updateRecordPortionLength(int n, int n2, int n3) throws IOException {
        this.rawDataOut.setPosition(this.slotTableOffsetToFirstRecordLengthField - n * this.slotEntrySize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(this.getRecordPortionLength(n) + n2);
        } else {
            this.logicalDataOut.writeInt(this.getRecordPortionLength(n) + n2);
        }
        if (n3 != 0) {
            if (this.slotFieldSize == 2) {
                this.logicalDataOut.writeShort(this.getReservedCount(n) + n3);
            } else {
                this.logicalDataOut.writeInt(this.getReservedCount(n) + n3);
            }
        }
    }

    private void initSlotTable(PageKey pageKey) throws StandardException {
        int n = this.slotsInUse;
        this.initializeHeaders(n);
        this.clearAllSpace();
        this.freeSpace -= n * this.slotEntrySize;
        int n2 = -1;
        int n3 = -1;
        try {
            int n4;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = this.getRecordOffset(n5);
                if (n4 < 60 || n4 >= this.getPageSize() - 8) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
                }
                if (n4 <= n3) continue;
                n3 = n4;
                n2 = n5;
            }
            this.bumpRecordCount(n);
            if (n2 != -1) {
                this.firstFreeByte = n3 + this.getTotalSpace(n2);
                this.freeSpace -= this.firstFreeByte - 60;
            }
            if (this.deletedRowCount == -1) {
                n5 = 0;
                n4 = this.slotsInUse;
                for (int i = 0; i < n4; ++i) {
                    if (!this.isDeletedOnPage(i)) continue;
                    ++n5;
                }
                this.deletedRowCount = n5;
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, pageKey));
        }
    }

    private void setSlotEntry(int n, int n2, int n3, int n4) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(n));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
            this.logicalDataOut.writeShort(n3);
            this.logicalDataOut.writeShort(n4);
        } else {
            this.logicalDataOut.writeInt(n2);
            this.logicalDataOut.writeInt(n3);
            this.logicalDataOut.writeInt(n4);
        }
    }

    private void addSlotEntry(int n, int n2, int n3, int n4) throws IOException {
        if (n < this.slotsInUse) {
            int n5 = this.getSlotOffset(this.slotsInUse - 1);
            int n6 = this.getSlotOffset(n) + this.slotEntrySize - n5;
            int n7 = this.getSlotOffset(this.slotsInUse);
            System.arraycopy(this.pageData, n5, this.pageData, n7, n6);
        } else {
            int n8 = this.getSlotOffset(n);
        }
        this.freeSpace -= this.slotEntrySize;
        ++this.slotsInUse;
        this.headerOutOfDate = true;
        this.setSlotEntry(n, n2, n3, n4);
    }

    private void removeSlotEntry(int n) throws IOException {
        int n2 = this.getSlotOffset(this.slotsInUse - 1);
        int n3 = this.getSlotOffset(this.slotsInUse - 2);
        if (n != this.slotsInUse - 1) {
            int n4 = this.getSlotOffset(n) - n2;
            System.arraycopy(this.pageData, n2, this.pageData, n3, n4);
        }
        this.clearSection(n2, this.slotEntrySize);
        this.freeSpace += this.slotEntrySize;
        --this.slotsInUse;
        this.headerOutOfDate = true;
    }

    @Override
    public StoredRecordHeader recordHeaderOnDemand(int n) {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader(this.pageData, this.getRecordOffset(n));
        this.setHeaderAtSlot(n, storedRecordHeader);
        return storedRecordHeader;
    }

    @Override
    public boolean entireRecordOnPage(int n) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (storedRecordHeader.hasOverflow()) {
            return false;
        }
        try {
            int n2 = this.getRecordOffset(n);
            int n3 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            arrayInputStream.setPosition(n2 + storedRecordHeader.size());
            for (int i = 0; i < n3; ++i) {
                int n4 = StoredFieldHeader.readStatus(arrayInputStream);
                if (StoredFieldHeader.isOverflow(n4)) {
                    return false;
                }
                int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
                if (n5 == 0) continue;
                arrayInputStream.setPosition(arrayInputStream.getPosition() + n5);
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
        return true;
    }

    protected void purgeOverflowAtSlot(int n, RecordHandle recordHandle, boolean bl) throws StandardException {
        if (n < 0 || n >= this.slotsInUse) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[]{this.getHeaderAtSlot(n).getId()};
        this.owner.getActionSet().actionPurge(rawTransaction, this, n, 1, nArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOneColumnChain(long l, int n) throws StandardException {
        StoredPage storedPage = null;
        boolean bl = false;
        try {
            while (l != -1L) {
                storedPage = this.getOverflowPage(l);
                bl = false;
                if (storedPage == null) {
                    break;
                }
                int n2 = 0;
                RecordHandle recordHandle = storedPage.getNextColumnPiece(n2);
                if (storedPage.recordCount() == 1) {
                    bl = true;
                    this.owner.removePage(storedPage);
                } else {
                    storedPage.unlatch();
                    storedPage = null;
                }
                if (recordHandle != null) {
                    l = recordHandle.getPageNumber();
                    n = recordHandle.getId();
                    continue;
                }
                l = -1L;
            }
        }
        finally {
            if (!bl && storedPage != null) {
                storedPage.unlatch();
                storedPage = null;
            }
        }
    }

    private void purgeColumnChains(RawTransaction rawTransaction, int n, RecordHandle recordHandle) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            int n2 = storedRecordHeader.getNumberFields();
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n3 = this.getRecordOffset(n) + storedRecordHeader.size();
            arrayInputStream.setPosition(n3);
            for (int i = 0; i < n2; ++i) {
                int n4 = StoredFieldHeader.readStatus(arrayInputStream);
                int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
                if (!StoredFieldHeader.isOverflow(n4)) {
                    if (n5 == 0) continue;
                    arrayInputStream.setPosition(arrayInputStream.getPosition() + n5);
                    continue;
                }
                long l = CompressedNumber.readLong(arrayInputStream);
                int n6 = CompressedNumber.readInt(arrayInputStream);
                this.purgeOneColumnChain(l, n6);
            }
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purgeRowPieces(RawTransaction rawTransaction, int n, RecordHandle recordHandle, boolean bl) throws StandardException {
        StoredPage storedPage;
        this.purgeColumnChains(rawTransaction, n, recordHandle);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        while (storedRecordHeader.hasOverflow() && (storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage())) != null) {
            try {
                int n2 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                storedPage.purgeColumnChains(rawTransaction, n2, recordHandle);
                storedRecordHeader = storedPage.getHeaderAtSlot(n2);
                if (n2 == 0 && storedPage.recordCount() == 1) {
                    try {
                        this.owner.removePage(storedPage);
                        continue;
                    }
                    finally {
                        storedPage = null;
                        continue;
                    }
                }
                storedPage.purgeOverflowAtSlot(n2, recordHandle, bl);
                storedPage.unlatch();
                storedPage = null;
            }
            finally {
                if (storedPage == null) continue;
                storedPage.unlatch();
                storedPage = null;
            }
        }
    }

    void removeOrphanedColumnChain(ReclaimSpace reclaimSpace, ContainerHandle containerHandle) throws StandardException {
        StoredPage storedPage = (StoredPage)containerHandle.getPageNoWait(reclaimSpace.getColumnPageId());
        if (storedPage == null) {
            return;
        }
        boolean bl = storedPage.equalTimeStamp(reclaimSpace.getPageTimeStamp());
        storedPage.unlatch();
        if (!bl) {
            return;
        }
        RecordHandle recordHandle = reclaimSpace.getHeadRowHandle();
        int n = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n >= 0) {
            StoredPage storedPage2 = this;
            try {
                int n2 = reclaimSpace.getColumnId();
                StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
                while (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() <= n2) {
                    if (storedPage2 != this) {
                        storedPage2.unlatch();
                        storedPage2 = null;
                    }
                    if (!storedRecordHeader.hasOverflow()) break;
                    storedPage2 = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                    storedRecordHeader = storedPage2.getHeaderAtSlot(StoredPage.getOverflowSlot(storedPage2, storedRecordHeader));
                }
                if (storedRecordHeader.getNumberFields() + storedRecordHeader.getFirstField() > n2 && !storedPage2.isColumnOrphaned(storedRecordHeader, n2, reclaimSpace.getColumnPageId(), reclaimSpace.getColumnRecordId())) {
                    if (storedPage2 != this) {
                        storedPage2.unlatch();
                        storedPage2 = null;
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
            }
            finally {
                if (storedPage2 != this && storedPage2 != null) {
                    storedPage2.unlatch();
                }
            }
        }
        long l = reclaimSpace.getColumnPageId();
        int n3 = reclaimSpace.getColumnRecordId();
        this.purgeOneColumnChain(l, n3);
    }

    private boolean isColumnOrphaned(StoredRecordHeader storedRecordHeader, int n, long l, long l2) throws StandardException, IOException {
        int n2;
        int n3 = this.findRecordById(storedRecordHeader.getId(), 0);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        int n4 = this.getRecordOffset(n3);
        arrayInputStream.setPosition(n4 + storedRecordHeader.size());
        for (n2 = storedRecordHeader.getFirstField(); n2 < n; ++n2) {
            this.skipField(arrayInputStream);
        }
        n2 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n2, this.slotFieldSize);
        if (StoredFieldHeader.isOverflow(n2)) {
            long l3 = CompressedNumber.readLong(arrayInputStream);
            int n6 = CompressedNumber.readInt(arrayInputStream);
            if (l3 == l && (long)n6 == l2) {
                return false;
            }
        }
        return true;
    }

    private RecordHandle getNextColumnPiece(int n) throws StandardException {
        try {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            int n2 = storedRecordHeader.getNumberFields();
            if (n2 != 2) {
                return null;
            }
            ArrayInputStream arrayInputStream = this.rawDataIn;
            int n3 = this.getRecordOffset(n) + storedRecordHeader.size();
            arrayInputStream.setPosition(n3);
            this.skipField(arrayInputStream);
            int n4 = StoredFieldHeader.readStatus(arrayInputStream);
            int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
            long l = CompressedNumber.readLong(arrayInputStream);
            int n6 = CompressedNumber.readInt(arrayInputStream);
            return this.owner.makeRecordHandle(l, n6);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
        }
    }

    private void initSpace() {
        this.totalSpace = this.getMaxFreeSpace();
        this.maxFieldSize = this.totalSpace - this.slotEntrySize - 16 - 12;
    }

    private void clearAllSpace() {
        this.freeSpace = this.totalSpace;
        this.firstFreeByte = this.getPageSize() - this.totalSpace - 8;
    }

    private void compressPage(int n, int n2) throws IOException {
        int n3 = n2 + 1 - n;
        if (n2 + 1 != this.firstFreeByte) {
            int n4 = this.firstFreeByte - n2 - 1;
            System.arraycopy(this.pageData, n2 + 1, this.pageData, n, n4);
            for (int i = 0; i < this.slotsInUse; ++i) {
                int n5 = this.getRecordOffset(i);
                if (n5 < n2 + 1) continue;
                this.setRecordOffset(i, n5 -= n3);
            }
        }
        this.freeSpace += n3;
        this.firstFreeByte -= n3;
        this.clearSection(this.firstFreeByte, n3);
    }

    protected void expandPage(int n, int n2) throws IOException {
        int n3 = this.firstFreeByte - n;
        if (n3 > 0) {
            System.arraycopy(this.pageData, n, this.pageData, n + n2, n3);
            for (int i = 0; i < this.slotsInUse; ++i) {
                int n4 = this.getRecordOffset(i);
                if (n4 < n) continue;
                this.setRecordOffset(i, n4 += n2);
            }
        }
        this.freeSpace -= n2;
        this.firstFreeByte += n2;
    }

    private void shrinkPage(int n, int n2) throws IOException {
        int n3 = this.firstFreeByte - n;
        if (n3 > 0) {
            System.arraycopy(this.pageData, n, this.pageData, n - n2, n3);
            for (int i = 0; i < this.slotsInUse; ++i) {
                int n4 = this.getRecordOffset(i);
                if (n4 < n) continue;
                this.setRecordOffset(i, n4 -= n2);
            }
        }
        this.freeSpace += n2;
        this.firstFreeByte -= n2;
    }

    @Override
    public int getRecordLength(int n) throws IOException {
        return this.getRecordPortionLength(n);
    }

    protected boolean getIsOverflow(int n) throws IOException {
        return this.getHeaderAtSlot(n).hasOverflow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logRow(int n, boolean bl, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n3, byte by, int n4, int n5, int n6) throws StandardException, IOException {
        if (!bl && n4 != -1 && n5 == -1) {
            return n4;
        }
        int n7 = this.freeSpace;
        this.setOutputStream(dynamicByteArrayOutputStream);
        int n8 = dynamicByteArrayOutputStream.getPosition();
        this.userRowSize = 0;
        boolean bl2 = false;
        if (n4 != -1) {
            n7 = n5;
            n8 = dynamicByteArrayOutputStream.getBeginPosition();
        } else {
            if (!bl) {
                n7 += this.getTotalSpace(n);
            } else {
                n7 -= this.slotEntrySize;
                if (n3 == 0) {
                    bl2 = true;
                }
            }
            if (n7 <= 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        try {
            int n9;
            int n10;
            int n11;
            StoredRecordHeader storedRecordHeader;
            if (objectArray == null) {
                int n12 = this.logOverflowRecord(n, n7, dynamicByteArrayOutputStream);
                return n12;
            }
            int n13 = 0;
            if (bl) {
                storedRecordHeader = new StoredRecordHeader();
            } else {
                storedRecordHeader = new StoredRecordHeader(this.getHeaderAtSlot(n));
                n3 = storedRecordHeader.getFirstField();
            }
            if (formatableBitSet == null) {
                n13 = objectArray.length - n3;
            } else {
                for (n11 = formatableBitSet.getLength() - 1; n11 >= n3; --n11) {
                    if (!formatableBitSet.isSet(n11)) continue;
                    n13 = n11 + 1 - n3;
                    break;
                }
            }
            n11 = -1;
            if (bl) {
                storedRecordHeader.setId(n2);
                storedRecordHeader.setNumberFields(n13);
            } else {
                n11 = storedRecordHeader.getNumberFields();
                if (n13 > n11) {
                    if (storedRecordHeader.hasOverflow()) {
                        n13 = n11;
                    } else {
                        storedRecordHeader.setNumberFields(n13);
                    }
                } else if (n13 < n11) {
                    if (formatableBitSet == null) {
                        storedRecordHeader.setNumberFields(n13);
                    } else {
                        n13 = n11;
                    }
                }
            }
            int n14 = n3 + n13;
            if (n4 >= n14) {
                int n15 = -1;
                return n15;
            }
            if ((by & 1) != 1) {
                storedRecordHeader.setFirstField(n3);
            }
            int n16 = n4;
            if (n4 == -1) {
                n10 = storedRecordHeader.write(this.logicalDataOut);
                if ((n7 -= n10) < 0) {
                    throw new NoSpaceOnPage(this.isOverflowPage());
                }
                n16 = n3;
            }
            n10 = 0;
            int n17 = n9 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
            if (formatableBitSet != null && !bl && formatableBitSet != null && n16 < n3 + n11) {
                this.rawDataIn.setPosition(this.getFieldOffset(n, n16));
                n10 = 1;
            }
            int n18 = n7;
            int n19 = 0;
            int n20 = dynamicByteArrayOutputStream.getPosition();
            int n21 = n3;
            if (n7 > 12) {
                n20 = -1;
            }
            int n22 = 1;
            for (int i = n16; i < n14; ++i) {
                int n23;
                int n24;
                block63: {
                    Object object = null;
                    boolean bl3 = false;
                    if (formatableBitSet == null || n9 > i && formatableBitSet.isSet(i)) {
                        if (i < objectArray.length) {
                            object = objectArray[i];
                        }
                    } else if (!bl) {
                        bl3 = true;
                    }
                    if (n7 > 12) {
                        n20 = dynamicByteArrayOutputStream.getPosition();
                        n21 = i;
                    }
                    n18 = n7;
                    if (bl3) {
                        if (i < n3 + n11) {
                            n24 = this.rawDataIn.getPosition();
                            this.skipField(this.rawDataIn);
                            n23 = this.rawDataIn.getPosition() - n24;
                            if (n23 <= n7) {
                                this.logColumn(null, 0, dynamicByteArrayOutputStream, Integer.MAX_VALUE, 0, n6);
                                n7 -= n23;
                            }
                        } else {
                            n7 = this.logColumn(null, 0, dynamicByteArrayOutputStream, n7, 3, n6);
                        }
                    } else {
                        if (n10 != 0 && i < n3 + n11) {
                            this.skipField(this.rawDataIn);
                        }
                        try {
                            n7 = object == null ? this.logColumn(null, 0, dynamicByteArrayOutputStream, n7, n22, n6) : this.logColumn(objectArray, i, dynamicByteArrayOutputStream, n7, n22, n6);
                        }
                        catch (LongColumnException longColumnException) {
                            if ((by & 1) == 1) {
                                if (longColumnException.getColumn() instanceof InputStream && objectArray[i] instanceof StreamStorable && (objectArray[i] instanceof InputStream || ((StreamStorable)objectArray[i]).returnStream() != null)) {
                                    ((StreamStorable)objectArray[i]).setStream((InputStream)longColumnException.getColumn());
                                }
                                throw new NoSpaceOnPage(this.isOverflowPage());
                            }
                            if ((n7 < 14 || i != n14 - 1) && (n7 < 28 || i >= n14 - 1)) break block63;
                            dynamicByteArrayOutputStream.setBeginPosition(n8);
                            longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, i, n7);
                            throw longColumnException;
                        }
                    }
                }
                int n25 = n23 = n6 == 100 ? 0 : (int)(this.isLong(n19 += n18 - n7, n6) ? 1 : 0);
                if (n18 == n7 || n23 != 0) {
                    if ((by & 1) == 1) {
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    if (n23 != 0) {
                        dynamicByteArrayOutputStream.setPosition(dynamicByteArrayOutputStream.getPosition() - n19);
                    }
                    n24 = i;
                } else {
                    n24 = n14;
                }
                if ((n18 == n7 || (by & 0x10) == 16) && n7 < 12) {
                    if (i == n3 || n20 < 0) {
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    dynamicByteArrayOutputStream.setPosition(n20);
                    n24 = n21;
                }
                if (n24 < n14) {
                    int n26;
                    int n27 = n24 - n3;
                    int n28 = storedRecordHeader.size();
                    storedRecordHeader.setNumberFields(n27);
                    int n29 = storedRecordHeader.size();
                    int n30 = dynamicByteArrayOutputStream.getPosition();
                    if (n28 > n29) {
                        n26 = n28 - n29;
                        dynamicByteArrayOutputStream.setBeginPosition(n8 + n26);
                        dynamicByteArrayOutputStream.setPosition(n8 + n26);
                    } else if (n29 > n28) {
                        dynamicByteArrayOutputStream.setPosition(n8);
                    } else {
                        dynamicByteArrayOutputStream.setBeginPosition(n8);
                        dynamicByteArrayOutputStream.setPosition(n8);
                    }
                    n26 = storedRecordHeader.write(this.logicalDataOut);
                    dynamicByteArrayOutputStream.setPosition(n30);
                    if (!bl && formatableBitSet != null) {
                        this.handleIncompleteLogRow(n, n24, formatableBitSet, dynamicByteArrayOutputStream);
                    }
                    int n31 = n24;
                    return n31;
                }
                n22 = 0;
            }
            dynamicByteArrayOutputStream.setBeginPosition(n8);
            n3 = -1;
            if (bl2 && n7 < this.minimumRecordSize - this.userRowSize) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.resetOutputStream();
        }
        return n3;
    }

    private void handleIncompleteLogRow(int n, int n2, FormatableBitSet formatableBitSet, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n3 = storedRecordHeader.getFirstField() + storedRecordHeader.getNumberFields();
        boolean bl = false;
        int n4 = formatableBitSet.size();
        for (int i = n2; i < n3; ++i) {
            if (n4 > i && formatableBitSet.get(i)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Object[] objectArray = new Object[n3 - n2];
        ByteArrayOutputStream byteArrayOutputStream = null;
        for (int i = n2; i < n3; ++i) {
            if (n4 > i && formatableBitSet.get(i)) continue;
            try {
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                } else {
                    byteArrayOutputStream.reset();
                }
                this.logField(n, i, byteArrayOutputStream);
                objectArray[i - n2] = new RawField(byteArrayOutputStream.toByteArray());
                continue;
            }
            catch (IOException iOException) {
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, this.getPageId()));
            }
        }
        LongColumnException longColumnException = new LongColumnException();
        longColumnException.setExceptionInfo(dynamicByteArrayOutputStream, n2, -1);
        longColumnException.setColumn(objectArray);
        throw longColumnException;
    }

    @Override
    public void restoreRecordFromStream(LimitObjectInput limitObjectInput, Object[] objectArray) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(limitObjectInput);
        this.readRecordFromStream(objectArray, objectArray.length - 1, null, null, limitObjectInput, storedRecordHeader, null);
    }

    private boolean qualifyRecordFromRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        int n;
        boolean bl = true;
        for (n = 0; n < qualifierArray[0].length; ++n) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n];
            object = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n = 1; n < qualifierArray.length; ++n) {
            bl = false;
            for (int i = 0; i < qualifierArray[n].length; ++i) {
                object = qualifierArray[n][i];
                int n2 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object.getColumnId()];
                bl = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }

    private final void readOneColumnFromPage(Object[] objectArray, int n, int n2, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        ArrayInputStream arrayInputStream = this.rawDataIn;
        try {
            Object object = objectArray[n];
            if (n <= storedRecordHeader.getNumberFields() - 1) {
                int n3;
                for (n3 = n; n3 > 0; --n3) {
                    n2 += StoredFieldHeader.readTotalFieldLength(this.pageData, n2);
                }
                n3 = StoredFieldHeader.readStatus(this.pageData, n2);
                int n4 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n2 + 1, n3, this.slotFieldSize, arrayInputStream);
                if (!StoredFieldHeader.isNonexistent(n3)) {
                    boolean bl = StoredFieldHeader.isOverflow(n3);
                    OverflowInputStream overflowInputStream = null;
                    if (bl) {
                        long l = CompressedNumber.readLong(arrayInputStream);
                        int n5 = CompressedNumber.readInt(arrayInputStream);
                        MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                        overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n5, recordHandle);
                    }
                    if (object instanceof DataValueDescriptor) {
                        DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                        if (StoredFieldHeader.isNull(n3)) {
                            dataValueDescriptor.restoreToNull();
                        } else if (!bl) {
                            arrayInputStream.setLimit(n4);
                            errorObjectInput = arrayInputStream;
                            dataValueDescriptor.readExternalFromArray(arrayInputStream);
                            errorObjectInput = null;
                            int n6 = arrayInputStream.clearLimit();
                            if (n6 != 0) {
                                DataInputUtil.skipFully(arrayInputStream, n6);
                            }
                        } else {
                            FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                            if (dataValueDescriptor instanceof StreamStorable) {
                                ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                            } else {
                                errorObjectInput = formatIdInputStream;
                                dataValueDescriptor.readExternal(formatIdInputStream);
                                errorObjectInput = null;
                            }
                        }
                    } else {
                        if (StoredFieldHeader.isNull(n3)) {
                            throw StandardException.newException("XSDA6.S", Integer.toString(n));
                        }
                        arrayInputStream.setLimit(n4);
                        errorObjectInput = arrayInputStream;
                        objectArray[n] = arrayInputStream.readObject();
                        errorObjectInput = null;
                        int n7 = arrayInputStream.clearLimit();
                        if (n7 != 0) {
                            DataInputUtil.skipFully(arrayInputStream, n7);
                        }
                    }
                } else if (object instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)object).restoreToNull();
                } else {
                    objectArray[n] = null;
                }
            } else if (object instanceof DataValueDescriptor) {
                ((DataValueDescriptor)object).restoreToNull();
            } else {
                objectArray[n] = null;
            }
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean qualifyRecordFromSlot(Object[] objectArray, int n, FetchDescriptor fetchDescriptor, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        int n2;
        boolean bl = true;
        Qualifier[][] qualifierArray = fetchDescriptor.getQualifierList();
        int[] nArray = fetchDescriptor.getMaterializedColumns();
        for (n2 = 0; n2 < qualifierArray[0].length; ++n2) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n2];
            int n3 = qualifier.getColumnId();
            if (nArray[n3] == 0) {
                this.readOneColumnFromPage(objectArray, n3, n, storedRecordHeader, recordHandle);
                nArray[n3] = n;
            }
            bl = ((DataValueDescriptor)objectArray[n3]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 1; n2 < qualifierArray.length; ++n2) {
            bl = false;
            for (int i = 0; i < qualifierArray[n2].length; ++i) {
                Qualifier qualifier = qualifierArray[n2][i];
                int n4 = qualifier.getColumnId();
                if (nArray[n4] == 0) {
                    this.readOneColumnFromPage(objectArray, n4, n, storedRecordHeader, recordHandle);
                    nArray[n4] = n;
                }
                bl = ((DataValueDescriptor)objectArray[n4]).compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                if (qualifier.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }

    private final boolean readRecordFromStream(Object[] objectArray, int n, int[] nArray, int[] nArray2, LimitObjectInput limitObjectInput, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        try {
            int n2 = storedRecordHeader.getNumberFields();
            int n3 = storedRecordHeader.getFirstField();
            if (n3 > n) {
                return true;
            }
            int n4 = n2 + n3;
            int n5 = nArray == null ? 0 : nArray.length;
            for (int i = n3; i <= n; ++i) {
                int n6;
                if (nArray != null && (n5 <= i || nArray[i] == 0) || nArray2 != null && nArray2[i] != 0) {
                    if (i >= n4) continue;
                    this.skipField(limitObjectInput);
                    continue;
                }
                if (i >= n4) {
                    Object object = objectArray[i];
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                        continue;
                    }
                    objectArray[i] = null;
                    continue;
                }
                int n7 = StoredFieldHeader.readStatus(limitObjectInput);
                int n8 = StoredFieldHeader.readFieldDataLength(limitObjectInput, n7, this.slotFieldSize);
                Object object = objectArray[i];
                OverflowInputStream overflowInputStream = null;
                if (StoredFieldHeader.isNonexistent(n7)) {
                    if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                        continue;
                    }
                    objectArray[i] = null;
                    continue;
                }
                boolean bl = StoredFieldHeader.isOverflow(n7);
                if (bl) {
                    long l = CompressedNumber.readLong((InputStream)((Object)limitObjectInput));
                    n6 = CompressedNumber.readInt((InputStream)((Object)limitObjectInput));
                    MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                    overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n6, recordHandle);
                }
                if (object instanceof DataValueDescriptor) {
                    DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                    if (StoredFieldHeader.isNull(n7)) {
                        dataValueDescriptor.restoreToNull();
                        continue;
                    }
                    if (!bl) {
                        limitObjectInput.setLimit(n8);
                        errorObjectInput = limitObjectInput;
                        dataValueDescriptor.readExternal(limitObjectInput);
                        errorObjectInput = null;
                        int n9 = limitObjectInput.clearLimit();
                        if (n9 == 0) continue;
                        DataInputUtil.skipFully(limitObjectInput, n9);
                        continue;
                    }
                    FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                    n6 = 1;
                    if (!(dataValueDescriptor instanceof StreamStorable)) {
                        n6 = 0;
                    }
                    if (n6 != 0) {
                        ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                        continue;
                    }
                    errorObjectInput = formatIdInputStream;
                    dataValueDescriptor.readExternal(formatIdInputStream);
                    errorObjectInput = null;
                    continue;
                }
                if (StoredFieldHeader.isNull(n7)) {
                    throw StandardException.newException("XSDA6.S", Integer.toString(i));
                }
                limitObjectInput.setLimit(n8);
                errorObjectInput = limitObjectInput;
                objectArray[i] = limitObjectInput.readObject();
                errorObjectInput = null;
                int n10 = limitObjectInput.clearLimit();
                if (n10 == 0) continue;
                DataInputUtil.skipFully(limitObjectInput, n10);
            }
            return n2 + n3 > n;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            limitObjectInput.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                limitObjectInput.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    private final boolean readRecordFromArray(Object[] objectArray, int n, int[] nArray, int[] nArray2, ArrayInputStream arrayInputStream, StoredRecordHeader storedRecordHeader, RecordHandle recordHandle) throws StandardException, IOException {
        ErrorObjectInput errorObjectInput = null;
        try {
            int n2 = storedRecordHeader.getNumberFields();
            int n3 = storedRecordHeader.getFirstField();
            if (n3 > n) {
                return true;
            }
            int n4 = n2 + n3;
            int n5 = nArray == null ? 0 : nArray.length;
            int n6 = arrayInputStream.getPosition();
            for (int i = n3; i <= n; ++i) {
                if (nArray != null && (n5 <= i || nArray[i] == 0) || nArray2 != null && nArray2[i] != 0) {
                    if (i >= n4) continue;
                    n6 += StoredFieldHeader.readTotalFieldLength(this.pageData, n6);
                    continue;
                }
                if (i < n4) {
                    int n7 = StoredFieldHeader.readStatus(this.pageData, n6);
                    int n8 = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, n6 + 1, n7, this.slotFieldSize, arrayInputStream);
                    Object object = objectArray[i];
                    OverflowInputStream overflowInputStream = null;
                    if ((n7 & 5) != 5) {
                        int n9;
                        boolean bl;
                        boolean bl2 = bl = (n7 & 2) != 0;
                        if (bl) {
                            long l = CompressedNumber.readLong(arrayInputStream);
                            n9 = CompressedNumber.readInt(arrayInputStream);
                            MemByteHolder memByteHolder = new MemByteHolder(this.pageData.length);
                            overflowInputStream = new OverflowInputStream(memByteHolder, this.owner, l, n9, recordHandle);
                        }
                        if (object instanceof DataValueDescriptor) {
                            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)object;
                            if ((n7 & 1) == 0) {
                                if (!bl) {
                                    arrayInputStream.setLimit(n8);
                                    errorObjectInput = arrayInputStream;
                                    dataValueDescriptor.readExternalFromArray(arrayInputStream);
                                    errorObjectInput = null;
                                    int n10 = arrayInputStream.clearLimit();
                                    if (n10 != 0) {
                                        DataInputUtil.skipFully(arrayInputStream, n10);
                                    }
                                } else {
                                    FormatIdInputStream formatIdInputStream = new FormatIdInputStream(overflowInputStream);
                                    n9 = 1;
                                    if (!(dataValueDescriptor instanceof StreamStorable)) {
                                        n9 = 0;
                                    }
                                    if (n9 != 0) {
                                        ((StreamStorable)((Object)dataValueDescriptor)).setStream(formatIdInputStream);
                                    } else {
                                        errorObjectInput = formatIdInputStream;
                                        dataValueDescriptor.readExternal(formatIdInputStream);
                                        errorObjectInput = null;
                                    }
                                }
                            } else {
                                dataValueDescriptor.restoreToNull();
                            }
                        } else {
                            if (StoredFieldHeader.isNull(n7)) {
                                throw StandardException.newException("XSDA6.S", Integer.toString(i));
                            }
                            arrayInputStream.setLimit(n8);
                            errorObjectInput = arrayInputStream;
                            objectArray[i] = arrayInputStream.readObject();
                            errorObjectInput = null;
                            int n11 = arrayInputStream.clearLimit();
                            if (n11 != 0) {
                                DataInputUtil.skipFully(arrayInputStream, n11);
                            }
                        }
                    } else if (object instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)object).restoreToNull();
                    } else {
                        objectArray[i] = null;
                    }
                    n6 = arrayInputStream.getPosition();
                    continue;
                }
                Object object = objectArray[i];
                if (object instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)object).restoreToNull();
                    continue;
                }
                objectArray[i] = null;
            }
            return n2 + n3 > n;
        }
        catch (IOException iOException) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                if (iOException instanceof EOFException) {
                    throw StandardException.newException("XSDA7.S", iOException, errorObjectInput.getErrorInfo());
                }
                Exception exception = errorObjectInput.getNestedException();
                if (exception != null) {
                    if (exception instanceof InstantiationException) {
                        throw StandardException.newException("XSDAM.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw StandardException.newException("XSDAN.S", exception, errorObjectInput.getErrorInfo());
                    }
                    if (exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                }
                throw StandardException.newException("XSDA8.S", iOException, errorObjectInput.getErrorInfo());
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            arrayInputStream.clearLimit();
            throw StandardException.newException("XSDA9.S", classNotFoundException, errorObjectInput.getErrorInfo());
        }
        catch (LinkageError linkageError) {
            if (errorObjectInput != null) {
                arrayInputStream.clearLimit();
                throw StandardException.newException("XSDA8.S", linkageError, errorObjectInput.getErrorInfo());
            }
            throw linkageError;
        }
    }

    @Override
    public void restorePortionLongColumn(OverflowInputStream overflowInputStream) throws StandardException, IOException {
        int n = this.findRecordById(overflowInputStream.getOverflowId(), 0);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n2 = this.getRecordOffset(n);
        int n3 = storedRecordHeader.getNumberFields();
        this.rawDataIn.setPosition(n2 + storedRecordHeader.size());
        int n4 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n5 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n4, this.slotFieldSize);
        ByteHolder byteHolder = overflowInputStream.getByteHolder();
        byteHolder.write(this.rawDataIn, n5);
        overflowInputStream.setByteHolder(byteHolder);
        if (n3 == 1) {
            overflowInputStream.setOverflowPage(-1L);
            overflowInputStream.setOverflowId(-1);
        } else {
            int n6 = n4;
            n4 = StoredFieldHeader.readStatus(this.rawDataIn);
            n5 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n4, this.slotFieldSize);
            long l = CompressedNumber.readLong(this.rawDataIn);
            int n7 = CompressedNumber.readInt(this.rawDataIn);
            overflowInputStream.setOverflowPage(l);
            overflowInputStream.setOverflowId(n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logColumn(int n, int n2, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n3) throws StandardException, IOException {
        int n4 = this.freeSpace;
        int n5 = -1;
        n4 += this.getReservedCount(n);
        this.rawDataIn.setPosition(this.getFieldOffset(n, n2));
        int n6 = StoredFieldHeader.readStatus(this.rawDataIn);
        int n7 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n6, this.slotFieldSize);
        n4 += StoredFieldHeader.size(n6, n7, this.slotFieldSize) + n7;
        try {
            this.setOutputStream(dynamicByteArrayOutputStream);
            n5 = this.rawDataOut.getPosition();
            Object[] objectArray = new Object[]{object};
            if (n4 == this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n4, 0, n3)) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.rawDataOut.setPosition(n5);
            this.resetOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logLongColumn(int n, int n2, Object object, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n3 = this.freeSpace;
        if ((n3 -= this.slotEntrySize) <= 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        this.setOutputStream(dynamicByteArrayOutputStream);
        int n4 = dynamicByteArrayOutputStream.getPosition();
        try {
            int n5 = 1;
            StoredRecordHeader storedRecordHeader = new StoredRecordHeader(n2, n5);
            int n6 = storedRecordHeader.write(this.logicalDataOut);
            if ((n3 -= n6) < 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
            Object[] objectArray = new Object[]{object};
            int n7 = this.logColumn(objectArray, 0, dynamicByteArrayOutputStream, n3, 2, 100);
            return n7;
        }
        finally {
            this.resetOutputStream();
        }
    }

    private int logColumn(Object[] objectArray, int n, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n2, int n3, int n4) throws StandardException, IOException {
        int n5;
        int n6;
        Object object;
        Object object2;
        Object object3 = object2 = objectArray != null ? objectArray[n] : null;
        if (object2 instanceof RawField) {
            byte[] byArray = ((RawField)object2).getData();
            if (byArray.length <= n2) {
                dynamicByteArrayOutputStream.write(byArray);
                n2 -= byArray.length;
            }
            return n2;
        }
        boolean bl = true;
        int n7 = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
        int n8 = dynamicByteArrayOutputStream.getPosition();
        int n9 = 0;
        int n10 = 0;
        if (object2 instanceof StreamStorable && (object = (StreamStorable)object2).returnStream() != null) {
            object2 = object.returnStream();
        }
        if (object2 == null && n3 != 3) {
            n7 = StoredFieldHeader.setNonexistent(n7);
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
        } else if (object2 instanceof InputStream) {
            int n11;
            object = null;
            n5 = 0;
            int n12 = this.getMaxDataLength(n2, n4);
            if (object2 instanceof RememberBytesInputStream) {
                object = (RememberBytesInputStream)object2;
                n5 = ((RememberBytesInputStream)object).numBytesSaved();
            } else {
                object = new RememberBytesInputStream((InputStream)object2, new MemByteHolder(this.maxFieldSize + 1));
                if (objectArray[n] instanceof StreamStorable) {
                    ((StreamStorable)objectArray[n]).setStream((InputStream)object);
                }
                object2 = object;
            }
            if (n5 < n12 + 1) {
                n5 = (int)((long)n5 + ((RememberBytesInputStream)object).fillBuf(n12 + 1 - n5));
            }
            if (n5 <= n12) {
                n10 = n5;
                n7 = StoredFieldHeader.setFixed(n7, true);
                n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n10);
            } else if (n3 == 2) {
                bl = false;
                n10 = n12 - 12 - 2;
                n7 = StoredFieldHeader.setFixed(n7, true);
                n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
                ((RememberBytesInputStream)object).putBuf(this.logicalDataOut, n10);
                n11 = ((RememberBytesInputStream)object).available();
                int n13 = ((RememberBytesInputStream)object).shiftToFront();
            } else {
                n11 = this.maxFieldSize - n5 + 1;
                if (n11 > 0) {
                    n5 = (int)((long)n5 + ((RememberBytesInputStream)object).fillBuf(n11));
                }
                n10 = n5;
                object2 = object;
            }
        } else if (n3 == 3) {
            n7 = StoredFieldHeader.setNull(n7, true);
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
        } else if (object2 instanceof DataValueDescriptor) {
            object = (DataValueDescriptor)object2;
            int n14 = n5 = n3 == 3 || object.isNull() ? 1 : 0;
            if (n5 != 0) {
                n7 = StoredFieldHeader.setNull(n7, true);
            }
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            if (n5 == 0) {
                try {
                    n9 = dynamicByteArrayOutputStream.getPosition();
                    object.writeExternal(this.logicalDataOut);
                }
                catch (IOException iOException) {
                    Exception exception;
                    if (this.logicalDataOut != null && (exception = this.logicalDataOut.getNestedException()) != null && exception instanceof StandardException) {
                        throw (StandardException)exception;
                    }
                    throw StandardException.newException("XSDAJ.S", iOException, new Object[0]);
                }
                n10 = dynamicByteArrayOutputStream.getPosition() - n8 - n6;
            }
        } else if (object2 instanceof RecordHandle) {
            object = (RecordHandle)object2;
            n7 = StoredFieldHeader.setOverflow(n7, true);
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            n10 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, object.getPageNumber());
            n10 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, object.getId());
        } else {
            n6 = StoredFieldHeader.write(this.logicalDataOut, n7, n10, this.slotFieldSize);
            this.logicalDataOut.writeObject(object2);
            n10 = dynamicByteArrayOutputStream.getPosition() - n8 - n6;
        }
        n7 = StoredFieldHeader.setFixed(n7, false);
        int n15 = StoredFieldHeader.size(n7, n10, this.slotFieldSize) + n10;
        this.userRowSize += n10;
        n5 = this.isLong(n15, n4) ? 1 : 0;
        if ((n2 < n15 || n5 != 0) && n3 != 2) {
            if (n5 != 0) {
                if (!(object2 instanceof InputStream)) {
                    ByteArray byteArray = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n9, n10);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getArray(), n9, n10);
                    MemByteHolder memByteHolder = new MemByteHolder(n10 + 1);
                    RememberBytesInputStream rememberBytesInputStream = new RememberBytesInputStream(byteArrayInputStream, memByteHolder);
                    object2 = rememberBytesInputStream;
                }
                dynamicByteArrayOutputStream.setPosition(n8);
                LongColumnException longColumnException = new LongColumnException();
                longColumnException.setColumn(object2);
                throw longColumnException;
            }
            dynamicByteArrayOutputStream.setPosition(n8);
            return n2;
        }
        dynamicByteArrayOutputStream.setPosition(n8);
        n7 = StoredFieldHeader.setFixed(n7, true);
        n6 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n7, n10, this.slotFieldSize);
        dynamicByteArrayOutputStream.setPosition(n8 + n10 + n6);
        n2 -= n15;
        if (n3 == 2) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        return n2;
    }

    private int logOverflowRecord(int n, int n2, DynamicByteArrayOutputStream dynamicByteArrayOutputStream) throws StandardException, IOException {
        int n3;
        this.setOutputStream(dynamicByteArrayOutputStream);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        StoredRecordHeader storedRecordHeader2 = this.getOverFlowRecordHeader();
        storedRecordHeader2.setOverflowFields(storedRecordHeader);
        int n4 = storedRecordHeader.size();
        int n5 = storedRecordHeader2.size();
        if (n4 < n5 && n2 < (n3 = n5 - n4)) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        storedRecordHeader2.write(this.logicalDataOut);
        this.logRecordDataPortion(n, 0, storedRecordHeader, null, this.logicalDataOut, null);
        return -1;
    }

    private int logOverflowField(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n, long l, int n2) throws StandardException, IOException {
        int n3;
        int n4;
        int n5 = StoredFieldHeader.setOverflow(StoredFieldHeader.setInitial(), true);
        if ((n -= (n3 += StoredFieldHeader.size(n5, n4 = (n3 = CompressedNumber.sizeLong(l) + CompressedNumber.sizeInt(n2)), this.slotFieldSize))) < 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        StoredFieldHeader.write(this.logicalDataOut, n5, n4, this.slotFieldSize);
        CompressedNumber.writeLong(dynamicByteArrayOutputStream, l);
        CompressedNumber.writeInt(dynamicByteArrayOutputStream, n2);
        return n;
    }

    @Override
    public void logRecord(int n, int n2, int n3, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (n3 != storedRecordHeader.getId()) {
            StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader(storedRecordHeader);
            storedRecordHeader2.setId(n3);
            storedRecordHeader2.write(outputStream);
            storedRecordHeader2 = null;
        } else {
            storedRecordHeader.write(outputStream);
        }
        this.logRecordDataPortion(n, n2, storedRecordHeader, formatableBitSet, outputStream, recordHandle);
    }

    private void logRecordDataPortion(int n, int n2, StoredRecordHeader storedRecordHeader, FormatableBitSet formatableBitSet, OutputStream outputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n3 = this.getRecordOffset(n);
        int n4 = storedRecordHeader.size();
        n3 += n4;
        int n5 = storedRecordHeader.getFirstField();
        int n6 = n5 + storedRecordHeader.getNumberFields();
        int n7 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        for (int i = n5; i < n6; ++i) {
            this.rawDataIn.setPosition(n3);
            int n8 = StoredFieldHeader.readStatus(this.rawDataIn);
            int n9 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n8, this.slotFieldSize);
            if (formatableBitSet != null && (n7 <= i || !formatableBitSet.isSet(i)) || (n2 & 2) != 0 && !StoredFieldHeader.isOverflow(n8)) {
                n3 += StoredFieldHeader.size(n8, n9, this.slotFieldSize);
                n3 += n9;
                n8 = StoredFieldHeader.setInitial();
                n8 = StoredFieldHeader.setNonexistent(n8);
                StoredFieldHeader.write(outputStream, n8, 0, this.slotFieldSize);
                continue;
            }
            if ((n2 & 1) != 0 && recordHandle != null && StoredFieldHeader.isOverflow(n8) && !this.owner.isTemporaryContainer()) {
                int n10 = this.rawDataIn.getPosition();
                long l = CompressedNumber.readLong(this.rawDataIn);
                int n11 = CompressedNumber.readInt(this.rawDataIn);
                StoredPage storedPage = this.getOverflowPage(l);
                PageTimeStamp pageTimeStamp = storedPage.currentTimeStamp();
                storedPage.unlatch();
                RawTransaction rawTransaction = this.owner.getTransaction();
                ReclaimSpace reclaimSpace = new ReclaimSpace(4, recordHandle, i, l, n11, pageTimeStamp, rawTransaction.getDataFactory(), true);
                rawTransaction.addPostCommitWork(reclaimSpace);
                this.rawDataIn.setPosition(n10);
            }
            n3 += StoredFieldHeader.write(outputStream, n8, n9, this.slotFieldSize);
            if (n9 == 0) continue;
            outputStream.write(this.pageData, n3, n9);
            n3 += n9;
        }
    }

    @Override
    public void logField(int n, int n2, OutputStream outputStream) throws StandardException, IOException {
        int n3 = this.getFieldOffset(n, n2);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3);
        int n4 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
        StoredFieldHeader.write(outputStream, n4, n5, this.slotFieldSize);
        if (n5 != 0) {
            outputStream.write(this.pageData, arrayInputStream.getPosition(), n5);
        }
    }

    @Override
    public RecordHandle insertAtSlot(int n, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n2) throws StandardException {
        try {
            return super.insertAtSlot(n, objectArray, formatableBitSet, logicalUndo, by, n2);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            return null;
        }
    }

    @Override
    public RecordHandle updateFieldAtSlot(int n, int n2, Object object, LogicalUndo logicalUndo) throws StandardException {
        try {
            return super.updateFieldAtSlot(n, n2, object, logicalUndo);
        }
        catch (NoSpaceOnPage noSpaceOnPage) {
            if (this.slotsInUse == 1) {
                throw StandardException.newException("XSDA3.S", new Object[0]);
            }
            throw StandardException.newException("XSDA3.S", new Object[0]);
        }
    }

    @Override
    public int fetchNumFieldsAtSlot(int n) throws StandardException {
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (!storedRecordHeader.hasOverflow()) {
            return super.fetchNumFieldsAtSlot(n);
        }
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        int n2 = ((BasePage)storedPage).fetchNumFieldsAtSlot(StoredPage.getOverflowSlot(storedPage, storedRecordHeader));
        ((BasePage)storedPage).unlatch();
        return n2;
    }

    @Override
    public int moveRecordForCompressAtSlot(int n, Object[] objectArray, RecordHandle[] recordHandleArray, RecordHandle[] recordHandleArray2) throws StandardException {
        long l = this.getPageNumber();
        try {
            this.fetchFromSlot(null, n, objectArray, null, false);
            int n2 = this.getRecordPortionLength(n);
            int n3 = this.getHeaderAtSlot(n).getId();
            StoredPage storedPage = (StoredPage)this.owner.getPageForCompress(0, l);
            if (!(storedPage == null || storedPage.getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n2, n3))) {
                storedPage.unlatch();
                storedPage = null;
            }
            if (!(storedPage != null || (storedPage = (StoredPage)this.owner.getPageForCompress(1, l)) == null || storedPage.getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n2, n3))) {
                storedPage.unlatch();
                storedPage = null;
            }
            if (!(storedPage != null || (storedPage = (StoredPage)this.owner.addPage()).getPageNumber() < this.getPageNumber() && storedPage.spaceForCopy(n2, n3))) {
                this.owner.removePage(storedPage);
                storedPage = null;
            }
            if (storedPage != null) {
                int n4 = storedPage.recordCount();
                recordHandleArray[0] = this.getRecordHandleAtSlot(n);
                this.copyAndPurge(storedPage, n, 1, n4);
                recordHandleArray2[0] = storedPage.getRecordHandleAtSlot(n4);
                storedPage.unlatch();
                return 1;
            }
            return 0;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public void logAction(LogInstant logInstant) throws StandardException {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        if (!this.isActuallyDirty()) {
            this.initialRowCount = !this.isOverflowPage() && (this.getPageStatus() & 1) != 0 ? this.internalNonDeletedRecordCount() : 0;
        }
        this.setDirty();
        this.bumpPageVersion();
        this.updateLastLogInstant(logInstant);
    }

    private void cleanPage() {
        this.setDirty();
        this.clearSection(0, this.getPageSize());
        this.slotsInUse = 0;
        this.deletedRowCount = 0;
        this.headerOutOfDate = true;
        this.clearAllSpace();
    }

    @Override
    public void initPage(LogInstant logInstant, byte by, int n, boolean bl, boolean bl2) throws StandardException {
        this.logAction(logInstant);
        if (bl2) {
            this.cleanPage();
            super.cleanPageForReuse();
        }
        this.headerOutOfDate = true;
        this.setPageStatus(by);
        this.isOverflowPage = bl;
        this.nextId = n;
    }

    @Override
    public void setPageStatus(LogInstant logInstant, byte by) throws StandardException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        this.setPageStatus(by);
    }

    @Override
    public void setReservedSpace(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        this.headerOutOfDate = true;
        int n3 = n2 - this.getReservedCount(n);
        int n4 = this.getRecordOffset(n) + this.getTotalSpace(n);
        if (n3 > 0) {
            this.expandPage(n4, n3);
        } else {
            this.shrinkPage(n4, -n3);
        }
        this.rawDataOut.setPosition(this.getSlotOffset(n) + 2 * this.slotFieldSize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(n2);
        } else {
            this.logicalDataOut.writeInt(n2);
        }
    }

    @Override
    public void storeRecord(LogInstant logInstant, int n, boolean bl, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        if (bl) {
            this.storeRecordForInsert(n, objectInput);
        } else {
            this.storeRecordForUpdate(n, objectInput);
        }
    }

    private void storeRecordForInsert(int n, ObjectInput objectInput) throws StandardException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        StoredRecordHeader storedRecordHeader = this.shiftUp(n);
        if (storedRecordHeader == null) {
            storedRecordHeader = new StoredRecordHeader();
            this.setHeaderAtSlot(n, storedRecordHeader);
        }
        this.bumpRecordCount(1);
        storedRecordHeader.read(objectInput);
        if (storedRecordHeader.isDeleted()) {
            ++this.deletedRowCount;
            this.headerOutOfDate = true;
        }
        if (this.nextId <= storedRecordHeader.getId()) {
            this.nextId = storedRecordHeader.getId() + 1;
        }
        int n6 = n5 = this.firstFreeByte;
        int n7 = storedRecordHeader.getNumberFields();
        this.rawDataOut.setPosition(n6);
        n6 += storedRecordHeader.write(this.rawDataOut);
        int n8 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            n3 = StoredFieldHeader.readStatus(objectInput);
            n2 = StoredFieldHeader.readFieldDataLength(objectInput, n3, this.slotFieldSize);
            n3 = StoredFieldHeader.setFixed(n3, false);
            this.rawDataOut.setPosition(n6);
            n6 += StoredFieldHeader.write(this.rawDataOut, n3, n2, this.slotFieldSize);
            if (n2 == 0) continue;
            objectInput.readFully(this.pageData, n6, n2);
            n6 += n2;
            n8 += n2;
        }
        n4 = n6 - this.firstFreeByte;
        this.freeSpace -= n4;
        this.firstFreeByte += n4;
        n3 = 0;
        if (this.minimumRecordSize > 0 && n8 < this.minimumRecordSize) {
            n3 = this.minimumRecordSize - n8;
            this.freeSpace -= n3;
            this.firstFreeByte += n3;
        }
        if (this.isOverflowPage() && (n2 = 17 - (n4 + n3)) > 0) {
            this.freeSpace -= n2;
            this.firstFreeByte += n2;
            n3 += n2;
        }
        this.addSlotEntry(n, n5, n4, n3);
        if (this.firstFreeByte > this.getSlotOffset(n) || this.freeSpace < 0) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
        }
    }

    private void storeRecordForUpdate(int n, ObjectInput objectInput) throws StandardException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        StoredRecordHeader storedRecordHeader2 = new StoredRecordHeader();
        storedRecordHeader2.read(objectInput);
        int n7 = storedRecordHeader.getNumberFields();
        int n8 = storedRecordHeader2.getNumberFields();
        int n9 = storedRecordHeader.getFirstField();
        if (n8 < n7) {
            n6 = this.getFieldOffset(n, n9 + n8);
            n5 = this.getRecordOffset(n) + this.getRecordPortionLength(n) - n6;
            this.updateRecordPortionLength(n, -n5, n5);
        }
        n5 = n6 = this.getRecordOffset(n);
        int n10 = n6;
        int n11 = n8 < n7 ? n8 - 1 : n7 - 1;
        n11 += n9;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
        this.rawDataOut.setPosition(n5);
        int n12 = storedRecordHeader.size();
        int n13 = storedRecordHeader2.size();
        int n14 = n12;
        if (n11 < n9) {
            n14 += this.getReservedCount(n);
        }
        if (n14 >= n13) {
            storedRecordHeader2.write(this.rawDataOut);
            n5 += n13;
            n14 -= n13;
        } else {
            dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(this.getPageSize());
            storedRecordHeader2.write(dynamicByteArrayOutputStream);
        }
        n10 += n12;
        int n15 = n13 - n12;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = n9 + n7;
        int n21 = n9 + n8;
        for (n4 = n9; n4 < n21; ++n4) {
            int n22;
            int n23;
            n3 = 0;
            if (n4 < n20) {
                this.rawDataIn.setPosition(n10);
                n16 = StoredFieldHeader.readStatus(this.rawDataIn);
                n17 = StoredFieldHeader.readFieldDataLength(this.rawDataIn, n16, this.slotFieldSize);
                n3 = StoredFieldHeader.size(n16, n17, this.slotFieldSize) + n17;
            }
            n18 = StoredFieldHeader.readStatus(objectInput);
            n19 = StoredFieldHeader.readFieldDataLength(objectInput, n18, this.slotFieldSize);
            if (StoredFieldHeader.isNonexistent(n18) && n4 < n20) {
                if (dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) {
                    if (n5 != n10) {
                        System.arraycopy(this.pageData, n10, this.pageData, n5, n3);
                    }
                    n5 += n3;
                    if (n4 == n11) {
                        n14 += this.getReservedCount(n);
                    }
                } else {
                    n2 = dynamicByteArrayOutputStream.getPosition();
                    dynamicByteArrayOutputStream.setPosition(n2 + n3);
                    System.arraycopy(this.pageData, n10, dynamicByteArrayOutputStream.getByteArray(), n2, n3);
                    n14 += n3;
                    if (n4 == n11) {
                        n14 += this.getReservedCount(n);
                    }
                    n23 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n14, n5);
                    n5 += n23;
                    n14 -= n23;
                }
                n10 += n3;
                continue;
            }
            n18 = StoredFieldHeader.setFixed(n18, false);
            n2 = StoredFieldHeader.size(n18, n19, this.slotFieldSize);
            n23 = n2 + n19;
            n15 += n23 - n3;
            n14 += n3;
            n10 += n3;
            if (n4 == n11) {
                n14 += this.getReservedCount(n);
            }
            if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
                n22 = this.moveSavedDataToPage(dynamicByteArrayOutputStream, n14, n5);
                n5 += n22;
                n14 -= n22;
            }
            if ((dynamicByteArrayOutputStream == null || dynamicByteArrayOutputStream.getUsed() == 0) && n14 >= n2) {
                this.rawDataOut.setPosition(n5);
                n5 += StoredFieldHeader.write(this.rawDataOut, n18, n19, this.slotFieldSize);
                n14 -= n2;
                if (n19 == 0) continue;
                int n24 = n22 = n14 >= n19 ? n19 : n14;
                if (n22 != 0) {
                    objectInput.readFully(this.pageData, n5, n22);
                    n5 += n22;
                    n14 -= n22;
                }
                if ((n22 = n19 - n22) == 0) continue;
                if (dynamicByteArrayOutputStream == null) {
                    dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n23 * 2);
                }
                int n25 = dynamicByteArrayOutputStream.getPosition();
                dynamicByteArrayOutputStream.setPosition(n25 + n22);
                objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n25, n22);
                continue;
            }
            if (dynamicByteArrayOutputStream == null) {
                dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(n23 * 2);
            }
            StoredFieldHeader.write(dynamicByteArrayOutputStream, n18, n19, this.slotFieldSize);
            if (n19 == 0) continue;
            n22 = dynamicByteArrayOutputStream.getPosition();
            dynamicByteArrayOutputStream.setPosition(n22 + n19);
            objectInput.readFully(dynamicByteArrayOutputStream.getByteArray(), n22, n19);
        }
        if (dynamicByteArrayOutputStream != null && dynamicByteArrayOutputStream.getUsed() != 0) {
            n3 = n6 + this.getTotalSpace(n);
            n2 = dynamicByteArrayOutputStream.getUsed() - (n3 - n5);
            if (n2 > this.freeSpace) {
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", this.getPageId()));
            }
            this.expandPage(n3, n2);
            this.moveSavedDataToPage(dynamicByteArrayOutputStream, n14 += n2, n5);
            n4 = -1 * this.getReservedCount(n);
        } else {
            n4 = -1 * n15;
        }
        this.updateRecordPortionLength(n, n15, n4);
        this.setHeaderAtSlot(n, storedRecordHeader2);
    }

    private int moveSavedDataToPage(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n, int n2) {
        if (n > dynamicByteArrayOutputStream.getUsed() / 2) {
            int n3 = n <= dynamicByteArrayOutputStream.getUsed() ? n : dynamicByteArrayOutputStream.getUsed();
            System.arraycopy(dynamicByteArrayOutputStream.getByteArray(), 0, this.pageData, n2, n3);
            dynamicByteArrayOutputStream.discardLeft(n3);
            return n3;
        }
        return 0;
    }

    private void createSpaceForUpdate(int n, int n2, int n3, int n4) throws StandardException, IOException {
        int n5;
        if (n4 <= n3) {
            int n6 = n3 - n4;
            if (n6 == 0) {
                return;
            }
            int n7 = this.shiftRemainingData(n, n2, n3, n4);
            this.clearSection(n2 + n4 + n7, n6);
            this.updateRecordPortionLength(n, -n6, n6);
            return;
        }
        int n8 = n4 - n3;
        int n9 = this.getReservedCount(n);
        int n10 = 0;
        int n11 = n8 - n9;
        if (n11 > 0) {
            n5 = this.getRecordOffset(n) + this.getTotalSpace(n);
            this.expandPage(n5, n11);
            n10 = -n9;
        } else {
            n10 = -n8;
        }
        n5 = this.shiftRemainingData(n, n2, n3, n4);
        this.updateRecordPortionLength(n, n8, n10);
    }

    @Override
    public void storeField(LogInstant logInstant, int n, int n2, ObjectInput objectInput) throws StandardException, IOException {
        this.logAction(logInstant);
        int n3 = this.getFieldOffset(n, n2);
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3);
        int n4 = StoredFieldHeader.readStatus(arrayInputStream);
        int n5 = StoredFieldHeader.readFieldDataLength(arrayInputStream, n4, this.slotFieldSize);
        int n6 = StoredFieldHeader.readStatus(objectInput);
        int n7 = StoredFieldHeader.readFieldDataLength(objectInput, n6, this.slotFieldSize);
        n6 = StoredFieldHeader.setFixed(n6, false);
        int n8 = StoredFieldHeader.size(n4, n5, this.slotFieldSize) + n5;
        int n9 = StoredFieldHeader.size(n6, n7, this.slotFieldSize) + n7;
        this.createSpaceForUpdate(n, n3, n8, n9);
        this.rawDataOut.setPosition(n3);
        n3 += StoredFieldHeader.write(this.rawDataOut, n6, n7, this.slotFieldSize);
        if (n7 != 0) {
            objectInput.readFully(this.pageData, n3, n7);
        }
    }

    @Override
    public void reserveSpaceForSlot(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        int n3 = n2 - this.getReservedCount(n);
        if (n3 <= 0) {
            return;
        }
        if (this.freeSpace < n3) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        int n4 = this.getRecordOffset(n);
        int n5 = n4 + this.getTotalSpace(n);
        this.expandPage(n5, n3);
        this.setSlotEntry(n, n4, this.getRecordPortionLength(n), n2);
    }

    @Override
    public void skipField(ObjectInput objectInput) throws IOException {
        int n = StoredFieldHeader.readStatus(objectInput);
        int n2 = StoredFieldHeader.readFieldDataLength(objectInput, n, this.slotFieldSize);
        if (n2 != 0) {
            DataInputUtil.skipFully(objectInput, n2);
        }
    }

    @Override
    public void skipRecord(ObjectInput objectInput) throws IOException {
        StoredRecordHeader storedRecordHeader = new StoredRecordHeader();
        storedRecordHeader.read(objectInput);
        for (int i = storedRecordHeader.getNumberFields(); i > 0; --i) {
            this.skipField(objectInput);
        }
    }

    private int shiftRemainingData(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.getRecordOffset(n) + this.getRecordPortionLength(n) - (n2 + n3);
        if (n5 != 0) {
            System.arraycopy(this.pageData, n2 + n3, this.pageData, n2 + n4, n5);
        }
        return n5;
    }

    @Override
    public void setDeleteStatus(LogInstant logInstant, int n, boolean bl) throws StandardException, IOException {
        this.logAction(logInstant);
        this.deletedRowCount += super.setDeleteStatus(n, bl);
        this.headerOutOfDate = true;
        int n2 = this.getRecordOffset(n);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        this.rawDataOut.setPosition(n2);
        storedRecordHeader.write(this.logicalDataOut);
    }

    @Override
    protected int internalDeletedRecordCount() {
        return this.deletedRowCount;
    }

    @Override
    public void purgeRecord(LogInstant logInstant, int n, int n2) throws StandardException, IOException {
        this.logAction(logInstant);
        if (this.getHeaderAtSlot(n).isDeleted()) {
            --this.deletedRowCount;
        }
        int n3 = this.getRecordOffset(n);
        int n4 = n3 + this.getTotalSpace(n) - 1;
        this.compressPage(n3, n4);
        this.removeSlotEntry(n);
        this.removeAndShiftDown(n);
    }

    private int getFieldOffset(int n, int n2) throws IOException {
        int n3 = this.getRecordOffset(n);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        int n4 = storedRecordHeader.getFirstField();
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(n3 + storedRecordHeader.size());
        for (int i = n4; i < n2; ++i) {
            this.skipField(arrayInputStream);
        }
        return this.rawDataIn.getPosition();
    }

    @Override
    public PageTimeStamp currentTimeStamp() {
        return new PageVersion(this.getPageNumber(), this.getPageVersion());
    }

    @Override
    public void setTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            throw StandardException.newException("XSDAB.S", new Object[0]);
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        pageVersion.setPageNumber(this.getPageNumber());
        pageVersion.setPageVersion(this.getPageVersion());
    }

    @Override
    public boolean equalTimeStamp(PageTimeStamp pageTimeStamp) throws StandardException {
        if (pageTimeStamp == null) {
            return false;
        }
        if (!(pageTimeStamp instanceof PageVersion)) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        PageVersion pageVersion = (PageVersion)pageTimeStamp;
        if (pageVersion.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAA.S", pageTimeStamp);
        }
        return pageVersion.getPageVersion() == this.getPageVersion();
    }

    public String toString() {
        return null;
    }

    public String toUncheckedString() {
        return null;
    }

    private static String pagedataToHexDump(byte[] byArray) {
        return StringUtil.hexDump(byArray);
    }

    private String pageHeaderToString() {
        return null;
    }

    String getPageDumpString() {
        return MessageService.getTextMessage("D016", this.getIdentity(), this.isOverflowPage, this.getPageVersion(), this.slotsInUse, this.deletedRowCount, this.getPageStatus(), this.nextId, this.firstFreeByte, this.freeSpace, this.totalSpace, this.spareSpace, this.minimumRecordSize, this.getPageSize(), StoredPage.pagedataToHexDump(this.pageData));
    }

    private String recordToString(int n) {
        return null;
    }

    protected StoredPage getOverflowPage(long l) throws StandardException {
        StoredPage storedPage = (StoredPage)this.owner.getPage(l);
        if (storedPage == null) {
            // empty if block
        }
        return storedPage;
    }

    @Override
    protected BasePage getNewOverflowPage() throws StandardException {
        FileContainer fileContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
        try {
            BasePage basePage = (BasePage)fileContainer.addPage(this.owner, true);
            return basePage;
        }
        finally {
            this.containerCache.release(fileContainer);
        }
    }

    protected static int getOverflowSlot(BasePage basePage, StoredRecordHeader storedRecordHeader) throws StandardException {
        int n = basePage.findRecordById(storedRecordHeader.getOverflowId(), 0);
        if (n < 0) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        return n;
    }

    public BasePage getOverflowPageForInsert(int n, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        return this.getOverflowPageForInsert(n, objectArray, formatableBitSet, 0);
    }

    @Override
    public BasePage getOverflowPageForInsert(int n, Object[] objectArray, FormatableBitSet formatableBitSet, int n2) throws StandardException {
        int n3;
        int n4;
        long[] lArray = new long[5];
        int n5 = 0;
        long l = 0L;
        block2: for (n4 = 0; n4 < this.slotsInUse && n5 < lArray.length; ++n4) {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n4);
            if (!storedRecordHeader.hasOverflow()) continue;
            long l2 = storedRecordHeader.getOverflowPage();
            if (n4 == n) {
                l = l2;
                continue;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                if (lArray[n3] == l2) continue block2;
            }
            lArray[n5++] = l2;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            long l3 = lArray[n4];
            if (l3 == l) continue;
            StoredPage storedPage = null;
            n3 = 0;
            try {
                storedPage = this.getOverflowPage(l3);
                if (storedPage.spaceForInsert(objectArray, formatableBitSet, n3, n2, 100)) {
                    return storedPage;
                }
                n3 = storedPage.getCurrentFreeSpace();
                storedPage.unlatch();
                storedPage = null;
                continue;
            }
            catch (StandardException standardException) {
                if (storedPage == null) continue;
                storedPage.unlatch();
                storedPage = null;
            }
        }
        return this.getNewOverflowPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOverflowed(RawTransaction rawTransaction, int n, Object[] objectArray, FormatableBitSet formatableBitSet, StoredRecordHeader storedRecordHeader) throws StandardException {
        StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
        try {
            int n2 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
            ((BasePage)storedPage).doUpdateAtSlot(rawTransaction, n2, storedRecordHeader.getOverflowId(), objectArray, formatableBitSet);
            ((BasePage)storedPage).unlatch();
            storedPage = null;
            return;
        }
        finally {
            if (storedPage != null) {
                ((BasePage)storedPage).unlatch();
                storedPage = null;
            }
        }
    }

    @Override
    public void updateOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        long l = recordHandle.getPageNumber();
        if (l == this.getPageNumber()) {
            this.updateOverflowDetails(this, recordHandle, recordHandle2);
            return;
        }
        StoredPage storedPage = (StoredPage)this.owner.getPage(l);
        this.updateOverflowDetails(storedPage, recordHandle, recordHandle2);
        storedPage.unlatch();
    }

    private void updateOverflowDetails(StoredPage storedPage, RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        storedPage.getOverFlowRecordHeader().setOverflowDetails(recordHandle2);
        int n = storedPage.getSlotNumber(recordHandle);
        storedPage.doUpdateAtSlot(this.owner.getTransaction(), n, recordHandle.getId(), null, null);
    }

    @Override
    public void updateFieldOverflowDetails(RecordHandle recordHandle, RecordHandle recordHandle2) throws StandardException {
        Object[] objectArray = new Object[2];
        objectArray[1] = recordHandle2;
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.set(1);
        int n = this.getSlotNumber(recordHandle);
        this.doUpdateAtSlot(this.owner.getTransaction(), n, recordHandle.getId(), objectArray, formatableBitSet);
    }

    @Override
    public int appendOverflowFieldHeader(DynamicByteArrayOutputStream dynamicByteArrayOutputStream, RecordHandle recordHandle) throws StandardException, IOException {
        int n = StoredFieldHeader.setInitial();
        n = StoredFieldHeader.setOverflow(n, true);
        long l = recordHandle.getPageNumber();
        int n2 = recordHandle.getId();
        int n3 = CompressedNumber.sizeLong(l) + CompressedNumber.sizeInt(n2);
        int n4 = StoredFieldHeader.write(dynamicByteArrayOutputStream, n, n3, this.slotFieldSize);
        n4 += CompressedNumber.writeLong(dynamicByteArrayOutputStream, l);
        return n4 += CompressedNumber.writeInt(dynamicByteArrayOutputStream, n2);
    }

    protected int getSlotsInUse() {
        return this.slotsInUse;
    }

    private int getMaxDataLength(int n, int n2) {
        int n3 = this.totalSpace * n2 / 100;
        int n4 = 0;
        n4 = n < 62 ? n - 2 : (n < 16380 ? n - 3 : n - 5);
        return n4 > n3 ? n3 : n4;
    }

    private boolean isLong(int n, int n2) {
        int n3 = this.maxFieldSize * n2 / 100;
        return n > n3;
    }

    @Override
    public void doUpdateAtSlot(RawTransaction rawTransaction, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        Object object;
        RecordHandle recordHandle;
        RecordHandle recordHandle2 = recordHandle = this.isOverflowPage() ? null : this.getRecordHandleAtSlot(n);
        if (objectArray == null) {
            this.owner.getActionSet().actionUpdate(rawTransaction, this, n, n2, objectArray, formatableBitSet, -1, null, -1, recordHandle);
            return;
        }
        int n3 = RowUtil.nextColumn(objectArray, formatableBitSet, 0);
        if (n3 == -1) {
            return;
        }
        boolean bl = false;
        StoredPage storedPage = this;
        while (true) {
            object = storedPage.getHeaderAtSlot(n);
            int n4 = ((StoredRecordHeader)object).getFirstField();
            int n5 = n4 + ((StoredRecordHeader)object).getNumberFields();
            long l = -1L;
            int n6 = -1;
            int n7 = -1;
            if (!((StoredRecordHeader)object).hasOverflow() || n3 >= n4 && n3 < n5) {
                int n8;
                boolean bl2;
                int n9 = -1;
                Object[] objectArray2 = null;
                DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
                do {
                    try {
                        n9 = this.owner.getActionSet().actionUpdate(rawTransaction, storedPage, n, n2, objectArray, formatableBitSet, n6, dynamicByteArrayOutputStream, n7, recordHandle);
                        bl2 = false;
                    }
                    catch (LongColumnException longColumnException) {
                        if (longColumnException.getRealSpaceOnPage() == -1) {
                            dynamicByteArrayOutputStream = longColumnException.getLogBuffer();
                            objectArray2 = (Object[])longColumnException.getColumn();
                            n6 = longColumnException.getNextColumn();
                            n7 = -1;
                            bl2 = true;
                            continue;
                        }
                        dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(longColumnException.getLogBuffer());
                        RecordHandle recordHandle3 = this.insertLongColumn(storedPage, longColumnException, (byte)2);
                        int n10 = 0;
                        try {
                        }
                        catch (IOException iOException) {
                            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
                        }
                        n6 = longColumnException.getNextColumn() + 1;
                        n7 = longColumnException.getRealSpaceOnPage() - (n10 += this.appendOverflowFieldHeader(dynamicByteArrayOutputStream, recordHandle3));
                        bl2 = true;
                    }
                    catch (NoSpaceOnPage noSpaceOnPage) {
                        throw StandardException.newException("XSDAP.S", noSpaceOnPage, ((PageKey)storedPage.getIdentity()).toString(), this.getPageDumpString(), n, n2, formatableBitSet.toString(), n6, 0, recordHandle);
                    }
                } while (bl2);
                int n11 = n8 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
                if (n9 != -1) {
                    RecordHandle recordHandle4;
                    int n12 = n5;
                    if (!((StoredRecordHeader)object).hasOverflow()) {
                        if (formatableBitSet == null) {
                            if (objectArray.length > n12) {
                                n12 = objectArray.length;
                            }
                        } else if (n8 > n12) {
                            n12 = n8;
                        }
                    }
                    Object[] objectArray3 = new Object[n12];
                    FormatableBitSet formatableBitSet2 = new FormatableBitSet(n12);
                    Object var25_30 = null;
                    for (int i = n9; i < n12; ++i) {
                        if (formatableBitSet == null || n8 > i && formatableBitSet.isSet(i)) {
                            formatableBitSet2.set(i);
                            objectArray3[i] = RowUtil.getColumn(objectArray, formatableBitSet, i);
                            continue;
                        }
                        if (i >= n5) continue;
                        formatableBitSet2.set(i);
                        objectArray3[i] = objectArray2[i - n9];
                    }
                    RecordHandle recordHandle5 = storedPage.getRecordHandleAtSlot(n);
                    if (((StoredRecordHeader)object).hasOverflow()) {
                        l = ((StoredRecordHeader)object).getOverflowPage();
                        n2 = ((StoredRecordHeader)object).getOverflowId();
                        n3 = RowUtil.nextColumn(objectArray, formatableBitSet, n5);
                    } else {
                        n3 = -1;
                        l = 0L;
                    }
                    if (!bl && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl = storedPage.checkRowReservedSpace(n);
                    }
                    BasePage basePage = storedPage.getOverflowPageForInsert(n, objectArray3, formatableBitSet2, n9);
                    if (storedPage != this) {
                        storedPage.unlatch();
                        storedPage = null;
                    }
                    byte by = 8;
                    if (l != 0L) {
                        by = (byte)(by | 0x10);
                    }
                    RecordHandle recordHandle6 = l == 0L ? null : this.owner.makeRecordHandle(l, n2);
                    try {
                        recordHandle4 = basePage.insertAllowOverflow(0, objectArray3, formatableBitSet2, n9, by, 100, recordHandle6);
                    }
                    catch (NoSpaceOnPage noSpaceOnPage) {
                        throw StandardException.newException("XSDAP.S", noSpaceOnPage, ((PageKey)basePage.getIdentity()).toString(), this.getPageDumpString(), n, n2, formatableBitSet2.toString(), n9, by, recordHandle6);
                    }
                    if (storedPage == this) {
                        this.updateOverflowDetails(this, recordHandle5, recordHandle4);
                    } else {
                        this.updateOverflowDetails(recordHandle5, recordHandle4);
                    }
                    basePage.unlatch();
                } else {
                    if (!bl && recordHandle != null && storedPage != null && !this.owner.isTemporaryContainer()) {
                        bl = storedPage.checkRowReservedSpace(n);
                    }
                    int n13 = n3 = ((StoredRecordHeader)object).hasOverflow() ? RowUtil.nextColumn(objectArray, formatableBitSet, n5) : -1;
                }
                if (n3 == -1) {
                    if (storedPage == this || storedPage == null) break;
                    storedPage.unlatch();
                    break;
                }
            }
            if (l == -1L) {
                l = ((StoredRecordHeader)object).getOverflowPage();
                n2 = ((StoredRecordHeader)object).getOverflowId();
            }
            if (storedPage != this && storedPage != null) {
                storedPage.unlatch();
            }
            storedPage = (StoredPage)this.owner.getPage(l);
            n = storedPage.findRecordById(n2, 0);
        }
        if (bl) {
            object = this.owner.getTransaction();
            ReclaimSpace reclaimSpace = new ReclaimSpace(3, recordHandle, ((RawTransaction)object).getDataFactory(), true);
            object.addPostCommitWork(reclaimSpace);
        }
    }

    private boolean checkRowReservedSpace(int n) throws StandardException {
        boolean bl = false;
        try {
            int n2 = this.getReservedCount(n);
            int n3 = 12;
            if (n2 > n3) {
                int n4 = this.getRecordPortionLength(n) + n2;
                if (this.isOverflowPage()) {
                    if (n4 > 17 + n3) {
                        bl = true;
                    }
                } else if (n4 > this.minimumRecordSize + n3) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compactRecord(RawTransaction rawTransaction, int n, int n2) throws StandardException {
        int n3;
        int n4;
        if (!this.isOverflowPage()) {
            StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
            while (storedRecordHeader.hasOverflow()) {
                StoredPage storedPage = this.getOverflowPage(storedRecordHeader.getOverflowPage());
                try {
                    n4 = storedRecordHeader.getOverflowId();
                    n3 = StoredPage.getOverflowSlot(storedPage, storedRecordHeader);
                    storedPage.compactRecord(rawTransaction, n3, n4);
                    storedRecordHeader = storedPage.getHeaderAtSlot(n3);
                }
                finally {
                    storedPage.unlatch();
                }
            }
        }
        int n5 = 12;
        try {
            int n6 = this.getReservedCount(n);
            if (n6 > n5) {
                n4 = this.getRecordPortionLength(n);
                n3 = n6;
                int n7 = n4 + n6;
                if (this.isOverflowPage()) {
                    if (n7 > 17 + n5) {
                        n3 = n4 >= 17 ? 0 : 17 - n4;
                    }
                } else if (n7 > this.minimumRecordSize + n5) {
                    n3 = n4 >= this.minimumRecordSize ? 0 : this.minimumRecordSize - n4;
                }
                if (n3 < n6) {
                    this.owner.getActionSet().actionShrinkReservedSpace(rawTransaction, this, n, n2, n3, n6);
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }
}

