/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XSDFileSchemaTreePopulator;

public class SchemaPopulationUtil {
    private static final String XSD_EXTENSION = ".XSD";

    public static Map getPrefixMapping(String xmlFileName, String xmlEncoding, Object resourceIdentifiers) throws OdaException {
        XMLSourceFromPath xmlSource = new XMLSourceFromPath(xmlFileName, xmlEncoding, resourceIdentifiers);
        SaxParser sp = new SaxParser(xmlSource, new ISaxParserConsumer(){

            @Override
            public void endElement(XMLPath path) {
            }

            @Override
            public void finish() {
            }

            @Override
            public void manipulateData(XMLPath path, String value) {
            }

            @Override
            public void startElement(XMLPath path) {
            }
        }, false);
        Thread spThread = new Thread(sp);
        spThread.start();
        try {
            spThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (sp == null || sp.exceptionOccurred()) {
            return new HashMap();
        }
        return sp.getPrefixMapping();
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, String xmlEncoding, int numberOfElementsAccessiable, Object resourceIdentifiers) throws OdaException, MalformedURLException, URISyntaxException {
        if (xsdFileName != null && xsdFileName.trim().length() > 0) {
            if (xmlFileName != null && xmlFileName.trim().length() > 0) {
                return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlFileName, xmlEncoding, resourceIdentifiers);
            }
            return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlEncoding, resourceIdentifiers);
        }
        return new XMLFileSchemaTreePopulator(numberOfElementsAccessiable).getSchemaTree(xmlFileName, xmlEncoding, resourceIdentifiers);
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, int numberOfElementsAccessiable, Object resourceIdentifiers) throws OdaException, MalformedURLException, URISyntaxException {
        return SchemaPopulationUtil.getSchemaTree(xsdFileName, xmlFileName, null, numberOfElementsAccessiable, resourceIdentifiers);
    }
}

