/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.utils;

import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.utils.JDBCDriverInformation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class JDBCDriverInfoManager {
    private JDBCDriverInformation[] jdbcDriverInfo = null;
    private static JDBCDriverInfoManager instance = null;

    private JDBCDriverInfoManager() {
    }

    public static synchronized JDBCDriverInfoManager getInstance() {
        if (instance == null) {
            instance = new JDBCDriverInfoManager();
        }
        return instance;
    }

    public JDBCDriverInformation getDriversInfo(String driverClassName) {
        JDBCDriverInformation[] infos = this.getDriversInfo();
        if (driverClassName != null) {
            JDBCDriverInformation[] jDBCDriverInformationArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                JDBCDriverInformation info = jDBCDriverInformationArray[n2];
                if (driverClassName.equals(info.getDriverClassName())) {
                    return info;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCDriverInformation[] getDriversInfo() {
        if (this.jdbcDriverInfo != null) {
            return this.jdbcDriverInfo;
        }
        JDBCDriverInfoManager jDBCDriverInfoManager = this;
        synchronized (jDBCDriverInfoManager) {
            if (this.jdbcDriverInfo != null) {
                return this.jdbcDriverInfo;
            }
            IExtensionRegistry extReg = Platform.getExtensionRegistry();
            IExtensionPoint extPoint = extReg.getExtensionPoint("org.eclipse.birt.report.data.oda.jdbc.driverinfo");
            if (extPoint == null) {
                return new JDBCDriverInformation[0];
            }
            IExtension[] exts = extPoint.getExtensions();
            if (exts == null) {
                return new JDBCDriverInformation[0];
            }
            ArrayList<JDBCDriverInformation> drivers = new ArrayList<JDBCDriverInformation>();
            int e = 0;
            while (e < exts.length) {
                IConfigurationElement[] configElems = exts[e].getConfigurationElements();
                if (configElems != null) {
                    int i = 0;
                    while (i < configElems.length) {
                        if (configElems[i].getName().equals("jdbcDriver")) {
                            drivers.add(JDBCDriverInfoManager.newJdbcDriverInfo(configElems[i]));
                        }
                        ++i;
                    }
                }
                ++e;
            }
            this.jdbcDriverInfo = drivers.toArray(new JDBCDriverInformation[0]);
        }
        return this.jdbcDriverInfo;
    }

    private static JDBCDriverInformation newJdbcDriverInfo(IConfigurationElement configElement) {
        JDBCDriverInformation driverInfo = JDBCDriverInformation.newInstance(configElement.getAttribute("driverClass"));
        driverInfo.setDisplayName(configElement.getAttribute("name"));
        driverInfo.setUrlFormat(configElement.getAttribute("urlTemplate"));
        driverInfo.setSelectorId(configElement.getAttribute("selectorId"));
        driverInfo.setHide(configElement.getAttribute("hide"));
        driverInfo.populateProperties(configElement);
        return driverInfo;
    }
}

