/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.actions;

import java.util.Iterator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;

public class ShowAxisAction
extends Action {
    private ExtendedItemHandle eih;

    public ShowAxisAction(ExtendedItemHandle eih) {
        super(Messages.getString("ShowAxisAction.Text.ShowValueAxis"), 2);
        this.eih = eih;
        this.init();
    }

    private void init() {
        Chart cm = ChartCubeUtil.getChartFromHandle((ExtendedItemHandle)this.eih);
        if (cm instanceof ChartWithAxes) {
            this.setChecked(this.hasAxisChart());
            try {
                AggregationCellHandle containerCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.eih);
                if (containerCell != null && DEUtil.isLinkedElement((DesignElementHandle)containerCell.getCrosstabHandle())) {
                    this.setEnabled(false);
                }
            }
            catch (BirtException e) {
                WizardBase.displayException((Throwable)e);
            }
        } else {
            this.setEnabled(false);
        }
    }

    private boolean hasAxisChart() {
        if (ChartCubeUtil.isPlotChart((DesignElementHandle)this.eih)) {
            Iterator iterator = this.eih.clientsIterator();
            while (iterator.hasNext()) {
                DesignElementHandle client = (DesignElementHandle)iterator.next();
                if (!ChartCubeUtil.isAxisChart((DesignElementHandle)client)) continue;
                return true;
            }
            return false;
        }
        return ChartCubeUtil.isAxisChart((DesignElementHandle)this.eih);
    }

    public void run() {
        ModuleHandle mh = this.eih.getRoot();
        try {
            AggregationCellHandle containerCell;
            ChartReportItemImpl reportItem;
            ChartWithAxes cmOld;
            ChartWithAxes cmNew;
            Axis yAxis;
            mh.getCommandStack().startTrans(this.getText());
            ExtendedItemHandle plotChart = this.eih;
            if (ChartCubeUtil.isAxisChart((DesignElementHandle)this.eih)) {
                plotChart = (ExtendedItemHandle)this.eih.getElementProperty("hostChart");
            }
            if ((yAxis = (Axis)((Axis)(cmNew = (cmOld = (ChartWithAxes)(reportItem = (ChartReportItemImpl)plotChart.getReportItem()).getProperty("chart.instance")).copyInstance()).getAxes().get(0)).getAssociatedAxes().get(0)) != null) {
                yAxis.getLineAttributes().setVisible(this.isChecked());
                yAxis.getLabel().setVisible(this.isChecked());
                yAxis.getMajorGrid().getTickAttributes().setVisible(this.isChecked());
                reportItem.executeSetModelCommand(plotChart, (Chart)cmOld, (Chart)cmNew);
            }
            if ((containerCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.eih)) != null) {
                if (this.isChecked()) {
                    ChartXTabUIUtil.addAxisChartInXTab((AggregationCellHandle)containerCell, (ChartWithAxes)cmNew, (ExtendedItemHandle)this.eih);
                } else {
                    ChartXTabUIUtil.removeAxisChartInXTab((AggregationCellHandle)containerCell, (boolean)ChartXTabUIUtil.isTransposedChartWithAxes((Chart)cmNew), (boolean)false);
                }
            }
            mh.getCommandStack().commit();
        }
        catch (BirtException e) {
            WizardBase.displayException((Throwable)e);
            mh.getCommandStack().rollback();
        }
    }
}

