/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheEnum;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String XSI = "xsi";
    private static final String VALUE = "value";
    private static final String SCOPE = "scope";
    private static final String EVENT_CHAIN = "eventChain";
    @Reference
    SessionLogger logger;
    private ConstraintElementsCacheBuilder cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from 0.8.0 to 0.8.1 : Executing Constraints converter for model file : {0}", new Object[]{targetFile.getName()});
        this.cache = this.getConstraintElementsCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("ConstraintElementsCacheBuilder is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateEventChainElementDefinitionsAndReferences(rootElement);
    }

    private void updateEventChainElementDefinitionsAndReferences(Element rootElement) {
        List rootEventChainElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/eventChains", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        List<String> allRootEventChainElements = this.getAllRootEventChainElements();
        if (!rootEventChainElements.isEmpty()) {
            for (Element rootEventChainElement : rootEventChainElements) {
                List subEventChainElements = HelperUtil.getXpathResult((Element)rootEventChainElement, (String)".//*[@xsi:type=\"am:SubEventChain\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
                for (Element subEventChainElement : subEventChainElements) {
                    Attribute typeAttribute = subEventChainElement.getAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                    if (typeAttribute == null) continue;
                    typeAttribute.setValue("am:EventChainContainer");
                }
                this.updateEventChainReferences(allRootEventChainElements, rootEventChainElement);
            }
        }
        this.updateEventChainReferencesInTimingConstraints(allRootEventChainElements, rootElement);
    }

    private void updateEventChainReferencesInTimingConstraints(List<String> allRootEventChainElements, Element rootElement) {
        List eventChainReferenceEleemnts = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:EventChainLatencyConstraint\" or @xsi:type=\"am:EventChainSynchronizationConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element timingConstraint : eventChainReferenceEleemnts) {
            List eventChains;
            String refEventChainName;
            ArrayList<String> invalidEventChainRefs = new ArrayList<String>();
            Attribute eventChainsAttribute = timingConstraint.getAttribute(SCOPE);
            if (eventChainsAttribute != null) {
                boolean isRefEventChainStringsUpdated = false;
                String refEventChainStrings = eventChainsAttribute.getValue();
                StringTokenizer stringTokenizer = new StringTokenizer(refEventChainStrings);
                while (stringTokenizer.hasMoreTokens()) {
                    String refEventChainString = stringTokenizer.nextToken();
                    refEventChainName = refEventChainString.substring(0, refEventChainString.lastIndexOf(63));
                    if (allRootEventChainElements.contains(refEventChainName)) continue;
                    isRefEventChainStringsUpdated = true;
                    refEventChainStrings = refEventChainStrings.replace(refEventChainString, "");
                    invalidEventChainRefs.add(refEventChainString);
                    if (refEventChainStrings.trim().length() == 0) {
                        timingConstraint.removeAttribute(eventChainsAttribute);
                    }
                    this.logEventChainMessageTimingConstraint(timingConstraint, refEventChainName);
                }
                if (isRefEventChainStringsUpdated) {
                    eventChainsAttribute.setValue(refEventChainStrings.trim());
                }
            }
            if ((eventChains = timingConstraint.getChildren(SCOPE)) != null) {
                for (Element eventChainElement : eventChains) {
                    String hrefValue = eventChainElement.getAttributeValue(HREF);
                    if (hrefValue == null || !hrefValue.contains(AMLT_PREFIX) || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf(35) + 1, hrefValue.indexOf(63)))) continue;
                    timingConstraint.removeContent((Content)eventChainElement);
                    invalidEventChainRefs.add(hrefValue);
                    this.logEventChainMessageTimingConstraint(timingConstraint, refEventChainName);
                }
            }
            if (invalidEventChainRefs.isEmpty()) continue;
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("key", SCOPE);
            Element valueElement = new Element(VALUE);
            valueElement.setAttribute(TYPE, "am:ListObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            for (String invalidEventChainRef : invalidEventChainRefs) {
                Element valuesElement = new Element("values");
                valuesElement.setAttribute(TYPE, "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
                valuesElement.setAttribute(VALUE, invalidEventChainRef);
                valueElement.addContent((Content)valuesElement);
            }
            customPropertyElement.addContent((Content)valueElement);
            timingConstraint.addContent((Content)customPropertyElement);
        }
    }

    private void updateEventChainReferences(List<String> allRootEventChainElements, Element rootEventChainElement) {
        List eventChainReferenceEleemnts = HelperUtil.getXpathResult((Element)rootEventChainElement, (String)".//*[@xsi:type=\"am:EventChainReference\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element eventChainReferenceElement : eventChainReferenceEleemnts) {
            String refEventChainName;
            String hrefValue;
            Element eventChainElement;
            String refEventChainName2;
            String refEventChainString;
            Attribute eventChainReferenceAttribute = eventChainReferenceElement.getAttribute(EVENT_CHAIN);
            if (eventChainReferenceAttribute != null && (refEventChainString = eventChainReferenceAttribute.getValue()) != null && refEventChainString.contains("?") && !allRootEventChainElements.contains(refEventChainName2 = refEventChainString.substring(0, refEventChainString.lastIndexOf(63)))) {
                eventChainReferenceElement.removeAttribute(eventChainReferenceAttribute);
                this.logEventChainMessageAndCreateCustomProperty(rootEventChainElement, eventChainReferenceElement, refEventChainString, refEventChainName2);
            }
            if ((eventChainElement = eventChainReferenceElement.getChild(EVENT_CHAIN)) == null || (hrefValue = eventChainElement.getAttributeValue(HREF)) == null || !hrefValue.contains(AMLT_PREFIX) || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf(35) + 1, hrefValue.indexOf(63)))) continue;
            eventChainReferenceElement.removeContent((Content)eventChainElement);
            this.logEventChainMessageAndCreateCustomProperty(rootEventChainElement, eventChainReferenceElement, hrefValue, refEventChainName);
        }
    }

    private void logEventChainMessageTimingConstraint(Element timingConstraintElement, String refEventChainName) {
        this.logger.warn("Sub EventChain : {0} is referred inside TimingConstraint as \"Scope\": {1}. As per 0.8.1, it is not valid to refer sub EventChain elements directly.\n\rEventChain {2}'s association is removed from TimingConstraint object, and corresponding information is stored as a CustomProperty", new Object[]{HelperUtil.decodeName((String)refEventChainName), timingConstraintElement.getAttributeValue("name"), refEventChainName});
    }

    private void logEventChainMessageAndCreateCustomProperty(Element rootEventChainElement, Element eventChainReferenceElement, String refEventChainString, String refEventChainName) {
        this.logger.warn("Sub EventChain : {0} is referred inside EventChainReference of EventChain : {1}. As per 0.8.1, it is not valid to refer sub EventChain elements inside EventChainReference.\n\r eventChain association is removed from EventChainReference object, and corresponding information is stored as a CustomProperty", new Object[]{HelperUtil.decodeName((String)refEventChainName), rootEventChainElement.getAttributeValue("name")});
        Element customPropertyElement = new Element("customProperties");
        customPropertyElement.setAttribute("key", EVENT_CHAIN);
        Element valueElement = new Element(VALUE);
        valueElement.setAttribute(TYPE, "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
        valueElement.setAttribute(VALUE, refEventChainString);
        customPropertyElement.addContent((Content)valueElement);
        eventChainReferenceElement.addContent((Content)customPropertyElement);
    }

    private List<String> getAllRootEventChainElements() {
        ArrayList<String> rootEventChainNames = new ArrayList<String>();
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Collection<Map<String, Object>> values = cacheMap.values();
        for (Map<String, Object> map : values) {
            Object value = map.get(ConstraintElementsCacheEnum.ROOT_EVENTCHAIN_NAMES.name());
            if (!(value instanceof List)) continue;
            rootEventChainNames.addAll((Collection)value);
        }
        return rootEventChainNames;
    }

    private ConstraintElementsCacheBuilder getConstraintElementsCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof ConstraintElementsCacheBuilder)) continue;
                return (ConstraintElementsCacheBuilder)c;
            }
        }
        return null;
    }
}

