/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnetrun;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.acute.SWTBotTests.AbstractDotnetTest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.junit.Assert;
import org.junit.Test;

public class TestConfiguration
extends AbstractDotnetTest {
    private String name = "Test_config1";
    private String location = "test location";
    private String arguments = "test Arg";

    @Override
    public void setup() throws CoreException {
        super.setup();
        bot.menu("Run").menu("Run Configurations...").click();
        bot.shell("Run Configurations").activate();
        bot.tree().select(new String[]{".NET Core"});
        bot.toolbarButtonWithTooltip("New launch configuration").click();
        bot.textWithLabel("Name:").setText(this.name);
        bot.textWithLabel("Location:").setText(this.location);
        bot.textWithLabel("Arguments:").setText(this.arguments);
        bot.cTabItem(1).activate();
        bot.radio("Shared file:").click();
        bot.text(2).setText("/" + this.project.getName());
        bot.button("Apply").click();
    }

    @Test
    public void testConfigInputs() throws FileNotFoundException, IOException {
        final File f = new File(this.project.getLocation().toFile(), String.valueOf(this.name) + ".launch");
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return f.isFile();
            }

            public String getFailureMessage() {
                return "Launch file not created";
            }
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(String.valueOf(this.project.getLocation().toString()) + "/" + this.name + ".launch"));){
            String line = br.readLine().trim();
            boolean isArgsPresent = false;
            boolean isLocPresent = false;
            boolean isBuildBoolPresent = false;
            while (line != null) {
                if (line.contains("<stringAttribute key=\"PROJECT_ARGUMENTS\" value=\"" + this.arguments + "\"/>")) {
                    isArgsPresent = true;
                } else if (line.contains("<booleanAttribute key=\"PROJECT_BUILD\" value=\"true\"/>")) {
                    isBuildBoolPresent = true;
                } else if (line.contains("<stringAttribute key=\"PROJECT_FOLDER\" value=\"" + this.location + "\"/>")) {
                    isLocPresent = true;
                }
                line = br.readLine();
            }
            Assert.assertTrue((String)"Launch file does not include all .NET Core variables", (isArgsPresent && isBuildBoolPresent && isLocPresent ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        bot.button("Close").click();
    }

    @Override
    public void tearDown() throws CoreException {
        bot.menu("Run").menu("Run Configurations...").click();
        bot.shell("Run Configurations").activate();
        bot.tree().expandNode(new String[]{".NET Core"}).select(this.name);
        bot.toolbarButtonWithTooltip("Delete selected launch configuration(s)").click();
        bot.shell("Confirm Launch Configuration Deletion").activate();
        bot.button("Delete").click();
        bot.shell("Run Configurations").activate();
        bot.button("Close").click();
        super.tearDown();
    }
}

