/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm4e.core.theme.RGB;

public class ColorManager {
    private static final ColorManager INSTANCE = new ColorManager();
    private final Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    public static ColorManager getInstance() {
        return INSTANCE;
    }

    private ColorManager() {
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }
}

