/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterRule;
import org.eclipse.tm4e.languageconfiguration.internal.utils.RegExpUtils;

public class OnEnterSupport {
    private static final List<CharacterPair> DEFAULT_BRACKETS = Arrays.asList(new CharacterPair("(", ")"), new CharacterPair("{", "}"), new CharacterPair("[", "]"));
    private final List<ProcessedBracketPair> brackets;
    private final List<OnEnterRule> regExpRules;

    public OnEnterSupport(List<CharacterPair> brackets, List<OnEnterRule> regExpRules) {
        this.brackets = (brackets != null ? brackets : DEFAULT_BRACKETS).stream().map(bracket -> new ProcessedBracketPair((String)bracket.getKey(), (String)bracket.getValue())).collect(Collectors.toList());
        this.regExpRules = regExpRules != null ? regExpRules : Collections.emptyList();
    }

    public EnterAction onEnter(String oneLineAboveText, String beforeEnterText, String afterEnterText) {
        for (OnEnterRule rule : this.regExpRules) {
            if (!rule.getBeforeText().matcher(beforeEnterText).find()) continue;
            if (rule.getAfterText() != null) {
                if (!rule.getAfterText().matcher(afterEnterText).find()) continue;
                return rule.getAction();
            }
            return rule.getAction();
        }
        if (beforeEnterText.length() > 0 && afterEnterText.length() > 0) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText) || !bracket.matchClose(afterEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.IndentOutdent);
            }
        }
        if (beforeEnterText.length() > 0) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.Indent);
            }
        }
        return null;
    }

    private static class ProcessedBracketPair {
        private static final Pattern B_REGEXP = Pattern.compile("\\B");
        private final Pattern openRegExp;
        private final Pattern closeRegExp;

        public ProcessedBracketPair(String open, String close) {
            this.openRegExp = ProcessedBracketPair.createOpenBracketRegExp(open);
            this.closeRegExp = ProcessedBracketPair.createCloseBracketRegExp(close);
        }

        public boolean matchOpen(String beforeEnterText) {
            return this.openRegExp != null && this.openRegExp.matcher(beforeEnterText).find();
        }

        public boolean matchClose(String afterEnterText) {
            return this.closeRegExp != null && this.closeRegExp.matcher(afterEnterText).find();
        }

        private static Pattern createOpenBracketRegExp(String bracket) {
            StringBuilder str = new StringBuilder(RegExpUtils.escapeRegExpCharacters(bracket));
            String c = String.valueOf(str.charAt(0));
            if (!B_REGEXP.matcher(c).find()) {
                str.insert(0, "\\b");
            }
            str.append("\\s*$");
            return RegExpUtils.create(str.toString());
        }

        private static Pattern createCloseBracketRegExp(String bracket) {
            StringBuilder str = new StringBuilder(RegExpUtils.escapeRegExpCharacters(bracket));
            String c = String.valueOf(str.charAt(str.length() - 1));
            if (!B_REGEXP.matcher(c).find()) {
                str.append("\\b");
            }
            str.insert(0, "^\\s*");
            return RegExpUtils.create(str.toString());
        }
    }
}

