/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.tm4e.core.internal.utils.CompareUtils;
import org.eclipse.tm4e.core.theme.ColorMap;
import org.eclipse.tm4e.core.theme.IRawTheme;
import org.eclipse.tm4e.core.theme.IRawThemeSetting;
import org.eclipse.tm4e.core.theme.ParsedThemeRule;
import org.eclipse.tm4e.core.theme.ThemeTrieElement;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class Theme {
    private static final Pattern rrggbb = Pattern.compile("^#[0-9a-f]{6}", 2);
    private static final Pattern rrggbbaa = Pattern.compile("^#[0-9a-f]{8}", 2);
    private static final Pattern rgb = Pattern.compile("^#[0-9a-f]{3}", 2);
    private static final Pattern rgba = Pattern.compile("^#[0-9a-f]{4}", 2);
    private final ColorMap _colorMap;
    private final ThemeTrieElement _root;
    private final ThemeTrieElementRule _defaults;
    private final Map<String, List<ThemeTrieElementRule>> _cache;

    public static Theme createFromRawTheme(IRawTheme source) {
        return Theme.createFromParsedTheme(Theme.parseTheme(source));
    }

    public static List<ParsedThemeRule> parseTheme(IRawTheme source) {
        if (source == null || source.getSettings() == null) {
            return Collections.emptyList();
        }
        Collection<IRawThemeSetting> settings = source.getSettings();
        ArrayList<ParsedThemeRule> result = new ArrayList<ParsedThemeRule>();
        int i = 0;
        for (IRawThemeSetting entry : settings) {
            if (entry.getSetting() == null) continue;
            Object settingScope = entry.getScope();
            List<Object> scopes = new ArrayList<String>();
            if (settingScope instanceof String) {
                String _scope = (String)settingScope;
                _scope = _scope.replaceAll("^[,]+", "");
                _scope = _scope.replaceAll("[,]+$", "");
                scopes = Arrays.asList(_scope.split(","));
            } else if (settingScope instanceof List) {
                scopes = (List)settingScope;
            } else {
                scopes.add("");
            }
            int fontStyle = -1;
            Object settingsFontStyle = entry.getSetting().getFontStyle();
            if (settingsFontStyle instanceof String) {
                fontStyle = 0;
                String[] segments = ((String)settingsFontStyle).split(" ");
                int j = 0;
                int lenJ = segments.length;
                while (j < lenJ) {
                    String segment = segments[j];
                    if ("italic".equals(segment)) {
                        fontStyle |= 1;
                    } else if ("bold".equals(segment)) {
                        fontStyle |= 2;
                    } else if ("underline".equals(segment)) {
                        fontStyle |= 4;
                    }
                    ++j;
                }
            }
            String foreground = null;
            String settingsForeground = entry.getSetting().getForeground();
            if (settingsForeground instanceof String && Theme.isValidHexColor(settingsForeground)) {
                foreground = settingsForeground;
            }
            String background = null;
            String settingsBackground = entry.getSetting().getBackground();
            if (settingsBackground instanceof String && Theme.isValidHexColor(settingsBackground)) {
                background = settingsBackground;
            }
            int j = 0;
            int lenJ = scopes.size();
            while (j < lenJ) {
                String _scope = ((String)scopes.get(j)).trim();
                List<String> segments = Arrays.asList(_scope.split(" "));
                String scope = segments.get(segments.size() - 1);
                List<String> parentScopes = null;
                if (segments.size() > 1) {
                    parentScopes = segments.subList(0, segments.size() - 1);
                    Collections.reverse(parentScopes);
                }
                ParsedThemeRule t = new ParsedThemeRule(scope, parentScopes, i, fontStyle, foreground, background);
                result.add(t);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static boolean isValidHexColor(String hex) {
        if (hex == null || hex.length() < 1) {
            return false;
        }
        if (rrggbb.matcher(hex).matches()) {
            return true;
        }
        if (rrggbbaa.matcher(hex).matches()) {
            return true;
        }
        if (rgb.matcher(hex).matches()) {
            return true;
        }
        return rgba.matcher(hex).matches();
    }

    public static Theme createFromParsedTheme(List<ParsedThemeRule> source) {
        return Theme.resolveParsedThemeRules(source);
    }

    public static Theme resolveParsedThemeRules(List<ParsedThemeRule> parsedThemeRules) {
        parsedThemeRules.sort((a, b) -> {
            int r = CompareUtils.strcmp(a.scope, b.scope);
            if (r != 0) {
                return r;
            }
            r = CompareUtils.strArrCmp(a.parentScopes, b.parentScopes);
            if (r != 0) {
                return r;
            }
            return a.index - b.index;
        });
        int defaultFontStyle = 0;
        String defaultForeground = "#000000";
        String defaultBackground = "#ffffff";
        while (parsedThemeRules.size() >= 1 && "".equals(parsedThemeRules.get((int)0).scope)) {
            ParsedThemeRule incomingDefaults = parsedThemeRules.remove(0);
            if (incomingDefaults.fontStyle != -1) {
                defaultFontStyle = incomingDefaults.fontStyle;
            }
            if (incomingDefaults.foreground != null) {
                defaultForeground = incomingDefaults.foreground;
            }
            if (incomingDefaults.background == null) continue;
            defaultBackground = incomingDefaults.background;
        }
        ColorMap colorMap = new ColorMap();
        ThemeTrieElementRule defaults = new ThemeTrieElementRule(0, null, defaultFontStyle, colorMap.getId(defaultForeground), colorMap.getId(defaultBackground));
        ThemeTrieElement root = new ThemeTrieElement(new ThemeTrieElementRule(0, null, -1, 0, 0), Collections.emptyList());
        int i = 0;
        int len = parsedThemeRules.size();
        while (i < len) {
            ParsedThemeRule rule = parsedThemeRules.get(i);
            root.insert(0, rule.scope, rule.parentScopes, rule.fontStyle, colorMap.getId(rule.foreground), colorMap.getId(rule.background));
            ++i;
        }
        return new Theme(colorMap, defaults, root);
    }

    public Theme(ColorMap colorMap, ThemeTrieElementRule defaults, ThemeTrieElement root) {
        this._colorMap = colorMap;
        this._root = root;
        this._defaults = defaults;
        this._cache = new HashMap<String, List<ThemeTrieElementRule>>();
    }

    public Set<String> getColorMap() {
        return this._colorMap.getColorMap();
    }

    public String getColor(int id) {
        return this._colorMap.getColor(id);
    }

    public ThemeTrieElementRule getDefaults() {
        return this._defaults;
    }

    public List<ThemeTrieElementRule> match(String scopeName) {
        if (!this._cache.containsKey(scopeName)) {
            this._cache.put(scopeName, this._root.match(scopeName));
        }
        return this._cache.get(scopeName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._cache == null ? 0 : this._cache.hashCode());
        result = 31 * result + (this._colorMap == null ? 0 : this._colorMap.hashCode());
        result = 31 * result + (this._defaults == null ? 0 : this._defaults.hashCode());
        result = 31 * result + (this._root == null ? 0 : this._root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Theme other = (Theme)obj;
        if (this._cache == null ? other._cache != null : !this._cache.equals(other._cache)) {
            return false;
        }
        if (this._colorMap == null ? other._colorMap != null : !this._colorMap.equals(other._colorMap)) {
            return false;
        }
        if (this._defaults == null ? other._defaults != null : !this._defaults.equals(other._defaults)) {
            return false;
        }
        return !(this._root == null ? other._root != null : !this._root.equals(other._root));
    }
}

