/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.grammar.GrammarHelper;
import org.eclipse.tm4e.core.grammar.Injection;
import org.eclipse.tm4e.core.grammar.StackElement;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.LocalStackElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.matcher.IMatchInjectionsResult;
import org.eclipse.tm4e.core.internal.matcher.IMatchResult;
import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.IOnigNextMatchResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.logger.ILogger;

class LineTokenizer {
    private final Grammar grammar;
    private final OnigString lineText;
    private boolean isFirstLine;
    private int linePos;
    private StackElement stack;
    private final LineTokens lineTokens;
    private int anchorPosition = -1;
    private boolean STOP;
    private final int lineLength;

    public LineTokenizer(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens) {
        this.grammar = grammar;
        this.lineText = lineText;
        this.lineLength = lineText.utf8_length();
        this.isFirstLine = isFirstLine;
        this.linePos = linePos;
        this.stack = stack;
        this.lineTokens = lineTokens;
    }

    public StackElement scan() {
        this.STOP = false;
        WhileCheckResult whileCheckResult = this._checkWhileConditions(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.lineTokens);
        this.stack = whileCheckResult.stack;
        this.linePos = whileCheckResult.linePos;
        this.isFirstLine = whileCheckResult.isFirstLine;
        this.anchorPosition = whileCheckResult.anchorPosition;
        while (!this.STOP) {
            this.scanNext();
        }
        return this.stack;
    }

    private void scanNext() {
        boolean hasAdvanced;
        IMatchResult r;
        ILogger logger = this.lineTokens.getLogger();
        if (logger.isEnabled()) {
            logger.log("");
            logger.log("@@scanNext: |" + this.lineText.getString().replaceAll("\n", "\\n").substring(this.linePos) + '|');
        }
        if ((r = this.matchRuleOrInjections(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.anchorPosition)) == null) {
            if (logger.isEnabled()) {
                logger.log(" no more matches.");
            }
            this.lineTokens.produce(this.stack, this.lineLength);
            this.STOP = true;
            return;
        }
        IOnigCaptureIndex[] captureIndices = r.getCaptureIndices();
        int matchedRuleId = r.getMatchedRuleId();
        boolean bl = captureIndices != null && captureIndices.length > 0 ? captureIndices[0].getEnd() > this.linePos : (hasAdvanced = false);
        if (matchedRuleId == -1) {
            BeginEndRule poppedRule = (BeginEndRule)this.stack.getRule(this.grammar);
            this.lineTokens.produce(this.stack, captureIndices[0].getStart());
            this.stack = this.stack.setContentNameScopesList(this.stack.nameScopesList);
            this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, poppedRule.endCaptures, captureIndices);
            this.lineTokens.produce(this.stack, captureIndices[0].getEnd());
            StackElement popped = this.stack;
            this.stack = this.stack.pop();
            if (!hasAdvanced && popped.getEnterPos() == this.linePos) {
                if (logger.isEnabled()) {
                    logger.log("[1] - Grammar is in an endless loop - Grammar pushed & popped a rule without advancing");
                }
                this.stack = popped;
                this.lineTokens.produce(this.stack, this.lineLength);
                this.STOP = true;
                return;
            }
        } else if (captureIndices != null && captureIndices.length > 0) {
            Rule _rule = this.grammar.getRule(matchedRuleId);
            this.lineTokens.produce(this.stack, captureIndices[0].getStart());
            StackElement beforePush = this.stack;
            String scopeName = _rule.getName(this.lineText.getString(), captureIndices);
            ScopeListElement nameScopesList = this.stack.contentNameScopesList.push(this.grammar, scopeName);
            this.stack = this.stack.push(matchedRuleId, this.linePos, null, nameScopesList, nameScopesList);
            if (_rule instanceof BeginEndRule) {
                BeginEndRule pushedRule = (BeginEndRule)_rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].getEnd());
                this.anchorPosition = captureIndices[0].getEnd();
                String contentName = pushedRule.getContentName(this.lineText.getString(), captureIndices);
                ScopeListElement contentNameScopesList = nameScopesList.push(this.grammar, contentName);
                this.stack = this.stack.setContentNameScopesList(contentNameScopesList);
                if (pushedRule.endHasBackReferences) {
                    this.stack = this.stack.setEndRule(pushedRule.getEndWithResolvedBackReferences(this.lineText.getString(), captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    if (logger.isEnabled()) {
                        logger.log("[2] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    }
                    this.stack = this.stack.pop();
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.STOP = true;
                    return;
                }
            } else if (_rule instanceof BeginWhileRule) {
                BeginWhileRule pushedRule = (BeginWhileRule)_rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].getEnd());
                this.anchorPosition = captureIndices[0].getEnd();
                String contentName = pushedRule.getContentName(this.lineText.getString(), captureIndices);
                ScopeListElement contentNameScopesList = nameScopesList.push(this.grammar, contentName);
                this.stack = this.stack.setContentNameScopesList(contentNameScopesList);
                if (pushedRule.whileHasBackReferences) {
                    this.stack = this.stack.setEndRule(pushedRule.getWhileWithResolvedBackReferences(this.lineText.getString(), captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    if (logger.isEnabled()) {
                        logger.log("[3] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    }
                    this.stack = this.stack.pop();
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.STOP = true;
                    return;
                }
            } else {
                MatchRule matchingRule = (MatchRule)_rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, matchingRule.captures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].getEnd());
                this.stack = this.stack.pop();
                if (!hasAdvanced) {
                    if (logger.isEnabled()) {
                        logger.log("[4] - Grammar is in an endless loop - Grammar is not advancing, nor is it pushing/popping");
                    }
                    this.stack = this.stack.safePop();
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.STOP = true;
                    return;
                }
            }
        }
        if (captureIndices[0].getEnd() > this.linePos) {
            this.linePos = captureIndices[0].getEnd();
            this.isFirstLine = false;
        }
    }

    private IMatchResult matchRule(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        Rule rule = stack.getRule(grammar);
        final ICompiledRule ruleScanner = rule.compile(grammar, stack.endRule, isFirstLine, linePos == anchorPosition);
        final IOnigNextMatchResult r = ruleScanner.scanner._findNextMatchSync(lineText, linePos);
        if (r != null) {
            return new IMatchResult(){

                @Override
                public int getMatchedRuleId() {
                    return ruleScanner.rules[r.getIndex()];
                }

                @Override
                public IOnigCaptureIndex[] getCaptureIndices() {
                    return r.getCaptureIndices();
                }
            };
        }
        return null;
    }

    private IMatchResult matchRuleOrInjections(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        IMatchResult matchResult = this.matchRule(grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        List<Injection> injections = grammar.getInjections();
        if (injections.size() == 0) {
            return matchResult;
        }
        IMatchInjectionsResult injectionResult = this.matchInjections(injections, grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        if (injectionResult == null) {
            return matchResult;
        }
        if (matchResult == null) {
            return injectionResult;
        }
        int matchResultScore = matchResult.getCaptureIndices()[0].getStart();
        int injectionResultScore = injectionResult.getCaptureIndices()[0].getStart();
        if (injectionResultScore < matchResultScore || injectionResult.isPriorityMatch() && injectionResultScore == matchResultScore) {
            return injectionResult;
        }
        return matchResult;
    }

    private IMatchInjectionsResult matchInjections(List<Injection> injections, Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        int bestMatchRating = Integer.MAX_VALUE;
        IOnigCaptureIndex[] bestMatchCaptureIndices = null;
        int bestMatchRuleId = -1;
        int bestMatchResultPriority = 0;
        List<String> scopes = stack.contentNameScopesList.generateScopes();
        for (Injection injection : injections) {
            int matchRating;
            if (!injection.match(scopes)) continue;
            ICompiledRule ruleScanner = grammar.getRule(injection.ruleId).compile(grammar, null, isFirstLine, linePos == anchorPosition);
            IOnigNextMatchResult matchResult = ruleScanner.scanner._findNextMatchSync(lineText, linePos);
            if (matchResult == null || (matchRating = matchResult.getCaptureIndices()[0].getStart()) > bestMatchRating) continue;
            bestMatchRating = matchRating;
            bestMatchCaptureIndices = matchResult.getCaptureIndices();
            bestMatchRuleId = ruleScanner.rules[matchResult.getIndex()];
            bestMatchResultPriority = injection.priority;
            if (bestMatchRating == linePos) break;
        }
        if (bestMatchCaptureIndices != null) {
            final int matchedRuleId = bestMatchRuleId;
            final IOnigCaptureIndex[] matchCaptureIndices = bestMatchCaptureIndices;
            final boolean matchResultPriority = bestMatchResultPriority == -1;
            return new IMatchInjectionsResult(){

                @Override
                public int getMatchedRuleId() {
                    return matchedRuleId;
                }

                @Override
                public IOnigCaptureIndex[] getCaptureIndices() {
                    return matchCaptureIndices;
                }

                @Override
                public boolean isPriorityMatch() {
                    return matchResultPriority;
                }
            };
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void handleCaptures(Grammar grammar, OnigString lineText, boolean isFirstLine, StackElement stack, LineTokens lineTokens, List<CaptureRule> captures, IOnigCaptureIndex[] captureIndices) {
        if (captures.size() == 0) {
            return;
        }
        len = Math.min(captures.size(), captureIndices.length);
        localStack = new ArrayList<LocalStackElement>();
        maxEnd = captureIndices[0].getEnd();
        i = 0;
        while (i < len) {
            block9: {
                captureRule = captures.get(i);
                if (captureRule == null || (captureIndex = captureIndices[i]).getLength() == 0) break block9;
                if (captureIndex.getStart() <= maxEnd) ** GOTO lbl15
                break;
lbl-1000:
                // 1 sources

                {
                    lineTokens.produceFromScopes(((LocalStackElement)localStack.get(localStack.size() - 1)).getScopes(), ((LocalStackElement)localStack.get(localStack.size() - 1)).getEndPos());
                    localStack.remove(localStack.size() - 1);
lbl15:
                    // 2 sources

                    ** while (localStack.size() > 0 && ((LocalStackElement)localStack.get((int)(localStack.size() - 1))).getEndPos() <= captureIndex.getStart())
                }
lbl16:
                // 1 sources

                if (localStack.size() > 0) {
                    lineTokens.produceFromScopes(((LocalStackElement)localStack.get(localStack.size() - 1)).getScopes(), captureIndex.getStart());
                } else {
                    lineTokens.produce(stack, captureIndex.getStart());
                }
                if (captureRule.retokenizeCapturedWithRuleId != null) {
                    scopeName = captureRule.getName(lineText.getString(), captureIndices);
                    nameScopesList = stack.contentNameScopesList.push(grammar, scopeName);
                    contentName = captureRule.getContentName(lineText.getString(), captureIndices);
                    contentNameScopesList = nameScopesList.push(grammar, contentName);
                    stackClone = stack.push(captureRule.retokenizeCapturedWithRuleId, captureIndex.getStart(), null, nameScopesList, contentNameScopesList);
                    LineTokenizer._tokenizeString(grammar, GrammarHelper.createOnigString(lineText.getString().substring(0, captureIndex.getEnd())), isFirstLine != false && captureIndex.getStart() == 0, captureIndex.getStart(), stackClone, lineTokens);
                } else {
                    captureRuleScopeName = captureRule.getName(lineText.getString(), captureIndices);
                    if (captureRuleScopeName != null) {
                        base = localStack.size() > 0 ? ((LocalStackElement)localStack.get(localStack.size() - 1)).getScopes() : stack.contentNameScopesList;
                        captureRuleScopesList = base.push(grammar, captureRuleScopeName);
                        localStack.add(new LocalStackElement(captureRuleScopesList, captureIndex.getEnd()));
                    }
                }
            }
            ++i;
        }
        while (localStack.size() > 0) {
            lineTokens.produceFromScopes(((LocalStackElement)localStack.get(localStack.size() - 1)).getScopes(), ((LocalStackElement)localStack.get(localStack.size() - 1)).getEndPos());
            localStack.remove(localStack.size() - 1);
        }
    }

    private WhileCheckResult _checkWhileConditions(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens) {
        int anchorPosition = -1;
        ArrayList<WhileStack> whileRules = new ArrayList<WhileStack>();
        StackElement node = stack;
        while (node != null) {
            Rule nodeRule = node.getRule(grammar);
            if (nodeRule instanceof BeginWhileRule) {
                whileRules.add(new WhileStack(node, (BeginWhileRule)nodeRule));
            }
            node = node.pop();
        }
        int i = whileRules.size() - 1;
        while (i >= 0) {
            block5: {
                WhileStack whileRule;
                block4: {
                    whileRule = (WhileStack)whileRules.get(i);
                    ICompiledRule ruleScanner = whileRule.rule.compileWhile(grammar, whileRule.stack.endRule, isFirstLine, anchorPosition == linePos);
                    IOnigNextMatchResult r = ruleScanner.scanner._findNextMatchSync(lineText, linePos);
                    if (r == null) break block4;
                    Integer matchedRuleId = ruleScanner.rules[r.getIndex()];
                    if (matchedRuleId != -2) {
                        stack = whileRule.stack.pop();
                        break;
                    }
                    if (r.getCaptureIndices() == null || r.getCaptureIndices().length <= 0) break block5;
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].getStart());
                    this.handleCaptures(grammar, lineText, isFirstLine, whileRule.stack, lineTokens, whileRule.rule.whileCaptures, r.getCaptureIndices());
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].getEnd());
                    anchorPosition = r.getCaptureIndices()[0].getEnd();
                    if (r.getCaptureIndices()[0].getEnd() <= linePos) break block5;
                    linePos = r.getCaptureIndices()[0].getEnd();
                    isFirstLine = false;
                    break block5;
                }
                stack = whileRule.stack.pop();
                break;
            }
            --i;
        }
        return new WhileCheckResult(stack, linePos, anchorPosition, isFirstLine);
    }

    public static StackElement _tokenizeString(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens) {
        return new LineTokenizer(grammar, lineText, isFirstLine, linePos, stack, lineTokens).scan();
    }

    class WhileCheckResult {
        public final StackElement stack;
        public final int linePos;
        public final int anchorPosition;
        public final boolean isFirstLine;

        public WhileCheckResult(StackElement stack, int linePos, int anchorPosition, boolean isFirstLine) {
            this.stack = stack;
            this.linePos = linePos;
            this.anchorPosition = anchorPosition;
            this.isFirstLine = isFirstLine;
        }
    }

    class WhileStack {
        public final StackElement stack;
        public final BeginWhileRule rule;

        public WhileStack(StackElement stack, BeginWhileRule rule) {
            this.stack = stack;
            this.rule = rule;
        }
    }
}

