/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameRefactoringWizard;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPRenameHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<LanguageServiceAccessor.LSPDocumentInfo> infos;
        IDocument document;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof AbstractTextEditor && (document = LSPEclipseUtils.getDocument((ITextEditor)part)) != null && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> Boolean.TRUE.equals(capabilities.getRenameProvider()))).isEmpty()) {
            LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
            ISelection sel = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            if (sel instanceof TextSelection) {
                int offset = ((TextSelection)sel).getOffset();
                LSPRenameProcessor processor = new LSPRenameProcessor(info, offset);
                ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                LSPRenameRefactoringWizard wizard = new LSPRenameRefactoringWizard((Refactoring)refactoring);
                RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    operation.run(part.getSite().getShell(), Messages.rename_title);
                }
                catch (InterruptedException e1) {
                    LanguageServerPlugin.logError(e1);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IDocument document;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof AbstractTextEditor && (document = LSPEclipseUtils.getDocument((ITextEditor)part)) != null) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> Boolean.TRUE.equals(capabilities.getRenameProvider()));
            ISelection selection = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }
}

