/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class LanguageServiceAccessor {
    private static Set<LanguageServerWrapper> startedServers = new HashSet<LanguageServerWrapper>();
    private static Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> providersToLSDefinitions = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStartedServers() {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            startedServers.clear();
        }
    }

    @Deprecated
    public static @NonNull Collection<LanguageServer> getLanguageServers(@NonNull IFile file, Predicate<ServerCapabilities> request) throws IOException {
        Collection<LanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(file, request);
        wrappers.forEach(w -> {
            try {
                w.connect(file, null);
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        });
        return wrappers.stream().map(LanguageServerWrapper::getServer).collect(Collectors.toList());
    }

    public static @NonNull List<CompletableFuture<LanguageServer>> getInitializedLanguageServers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        Collection<LanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(file, request);
        return wrappers.stream().map(wrapper -> wrapper.getInitializedServer().thenApply(server -> {
            try {
                wrapper.connect(file, null);
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
            return server;
        })).collect(Collectors.toList());
    }

    public static void disableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition) {
        IContentType contentType;
        Optional<LanguageServerWrapper> result = startedServers.stream().filter(server -> server.serverDefinition.equals(contentTypeToLSDefinition.getValue())).findFirst();
        if (result.isPresent() && (contentType = (IContentType)contentTypeToLSDefinition.getKey()) != null) {
            result.get().disconnectContentType(contentType);
        }
    }

    public static void enableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition, @NonNull IEditorReference[] editors) {
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                if (editor.getEditorInput() instanceof FileEditorInput) {
                    IFile editorFile = ((FileEditorInput)editor.getEditorInput()).getFile();
                    IContentType contentType = (IContentType)contentTypeToLSDefinition.getKey();
                    LanguageServersRegistry.LanguageServerDefinition lsDefinition = (LanguageServersRegistry.LanguageServerDefinition)contentTypeToLSDefinition.getValue();
                    IContentDescription contentDesc = editorFile.getContentDescription();
                    if (contentTypeToLSDefinition.isEnabled() && contentType != null && contentDesc != null && contentType.equals(contentDesc.getContentType()) && lsDefinition != null) {
                        try {
                            LanguageServiceAccessor.getInitializedLanguageServer(editorFile, lsDefinition, capabilities -> true);
                        }
                        catch (IOException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
            }
            ++n2;
        }
    }

    @Deprecated
    private static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition) throws IOException {
        return LanguageServiceAccessor.getLanguageServer(file, lsDefinition, null);
    }

    @Deprecated
    public static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), lsDefinition);
        if (wrapper != null && (capabilitiesPredicate == null || wrapper.getServerCapabilities() == null || capabilitiesPredicate.test(wrapper.getServerCapabilities()))) {
            wrapper.connect(file, null);
            return wrapper.getServer();
        }
        return null;
    }

    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(file.getProject(), lsDefinition);
        if (wrapper != null && (capabilitiesPredicate == null || wrapper.getServerCapabilities() == null || capabilitiesPredicate.test(wrapper.getServerCapabilities()))) {
            wrapper.connect(file, null);
            return wrapper.getInitializedServer();
        }
        return null;
    }

    public static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        LinkedHashSet<LanguageServerWrapper> res = new LinkedHashSet<LanguageServerWrapper>();
        IProject project = file.getProject();
        if (project == null) {
            return res;
        }
        res.addAll(LanguageServiceAccessor.getMatchingStartedWrappers(file, request));
        LinkedList<IContentType> contentTypes = new LinkedList<IContentType>();
        HashSet<IContentType> addedContentTypes = new HashSet<IContentType>();
        contentTypes.addAll(LSPEclipseUtils.getFileContentTypes(file));
        addedContentTypes.addAll(contentTypes);
        while (!contentTypes.isEmpty()) {
            IContentType contentType = (IContentType)contentTypes.poll();
            if (contentType == null) continue;
            for (ContentTypeToLanguageServerDefinition mapping : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                if (mapping == null || mapping.getValue() == null || !mapping.isEnabled()) continue;
                ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(project, (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue());
                if (request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
                res.add(wrapper);
            }
            if (contentType.getBaseType() == null || addedContentTypes.contains(contentType.getBaseType())) continue;
            addedContentTypes.add(contentType.getBaseType());
            contentTypes.add(contentType.getBaseType());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ProjectSpecificLanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        LanguageServerWrapper wrapper = null;
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            for (LanguageServerWrapper startedWrapper : LanguageServiceAccessor.getStartedLSWrappers(project)) {
                if (!startedWrapper.serverDefinition.equals(serverDefinition)) continue;
                wrapper = startedWrapper;
                break;
            }
            if (wrapper == null) {
                wrapper = new ProjectSpecificLanguageServerWrapper(project, serverDefinition);
                wrapper.start();
            }
            if (wrapper != null) {
                startedServers.add(wrapper);
            }
        }
        return wrapper;
    }

    private static @NonNull List<LanguageServerWrapper> getStartedLSWrappers(@NonNull IProject project) {
        return startedServers.stream().filter(wrapper -> wrapper.canOperate(project)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<LanguageServerWrapper> getMatchingStartedWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            return startedServers.stream().filter(wrapper -> {
                try {
                    return wrapper.isConnectedTo(file.getLocation()) || LanguageServersRegistry.getInstance().matches(file, wrapper.serverDefinition) && wrapper.canOperate(file.getProject());
                }
                catch (IOException | CoreException e) {
                    LanguageServerPlugin.logError(e);
                    return false;
                }
            }).filter(wrapper -> request == null || wrapper.getServerCapabilities() == null || request.test(wrapper.getServerCapabilities())).collect(Collectors.toList());
        }
    }

    public static @NonNull List<@NonNull LanguageServer> getActiveLanguageServers(Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(null, request, true);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(project, request, false);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@Nullable IProject project, Predicate<ServerCapabilities> request, boolean onlyActiveLS) {
        ArrayList<@NonNull LanguageServer> serverInfos = new ArrayList<LanguageServer>();
        for (LanguageServerWrapper wrapper : startedServers) {
            LanguageServer server;
            if (onlyActiveLS && !wrapper.isActive() || project != null && !wrapper.canOperate(project) || (server = wrapper.getServer()) == null || request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
            serverInfos.add(server);
        }
        return serverInfos;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getLSDefinition(@NonNull StreamConnectionProvider provider) {
        return providersToLSDefinitions.get(provider);
    }

    public static @NonNull List<@NonNull LSPDocumentInfo> getLSPDocumentInfosFor(@NonNull IDocument document, @NonNull Predicate<ServerCapabilities> capabilityRequest) {
        IFile file = LSPEclipseUtils.getFile(document);
        URI fileUri = null;
        if (file != null && file.exists()) {
            fileUri = LSPEclipseUtils.toUri((IResource)file);
            ArrayList<LSPDocumentInfo> res = new ArrayList<LSPDocumentInfo>();
            try {
                for (LanguageServerWrapper wrapper : LanguageServiceAccessor.getLSWrappers(file, capabilityRequest)) {
                    wrapper.connect(file, document);
                    res.add(new LSPDocumentInfo(fileUri, document, wrapper));
                }
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
            return res;
        }
        return Collections.emptyList();
    }

    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull LanguageServerWrapper wrapper;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        @Deprecated
        public LanguageServer getLanguageClient() {
            try {
                return this.wrapper.getInitializedServer().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LanguageServerPlugin.logError(e);
                return this.wrapper.getServer();
            }
        }

        public int getVersion() {
            return this.wrapper.getVersion(LSPEclipseUtils.getFile(this.document));
        }

        public CompletableFuture<LanguageServer> getInitializedLanguageClient() {
            return this.wrapper.getInitializedServer();
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }
}

