/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetexport;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.acute.dotnetexport.DotnetExportWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class DotnetExportWizard
extends Wizard
implements IExportWizard {
    private DotnetExportWizardPage wizardPage;

    public DotnetExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.DotnetExportWizard_exportProject);
        Iterator selectionIterator = selection.iterator();
        IFile projectFile = null;
        while (selectionIterator.hasNext() && projectFile == null) {
            IResource resource = (IResource)selectionIterator.next();
            projectFile = DotnetExportWizard.getProjectFile((IContainer)resource.getProject());
        }
        this.wizardPage = new DotnetExportWizardPage(projectFile);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        String dotnetPath;
        boolean isSCD = this.wizardPage.isSCD();
        String runtime = this.wizardPage.getRuntime();
        String framework = this.wizardPage.getTargetFramework();
        File exportLocation = this.wizardPage.getExportLocation();
        String configuration = this.wizardPage.getConfiguration();
        String version = this.wizardPage.getVersion();
        File projectLocation = this.wizardPage.getProjectFilePath().toFile().getParentFile();
        if (!exportLocation.exists()) {
            exportLocation.mkdirs();
        }
        try {
            dotnetPath = AcutePlugin.getDotnetCommand();
        }
        catch (IllegalStateException e) {
            return false;
        }
        ArrayList<String> restoreCommandList = new ArrayList<String>();
        restoreCommandList.add(dotnetPath);
        restoreCommandList.add("restore");
        if (isSCD) {
            restoreCommandList.add("-r");
            restoreCommandList.add(runtime);
        }
        ArrayList<String> exportCommandList = new ArrayList<String>();
        exportCommandList.add(dotnetPath);
        exportCommandList.add("publish");
        if (isSCD) {
            exportCommandList.add("-r");
            exportCommandList.add(runtime);
        }
        exportCommandList.add("-o");
        exportCommandList.add(exportLocation.getAbsolutePath());
        exportCommandList.add("-f");
        exportCommandList.add(framework);
        exportCommandList.add("-c");
        exportCommandList.add(configuration);
        if (!version.isEmpty()) {
            exportCommandList.add("--version-suffix");
            exportCommandList.add(version);
        }
        Job.create((String)Messages.DotnetExportWizard_dotnetCoreExport, monitor -> {
            try {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                Launch newLaunch = new Launch(null, "run", null);
                Process restoreProcess = DebugPlugin.exec((String[])restoreCommandList.toArray(new String[0]), (File)projectLocation);
                DebugPlugin.newProcess((ILaunch)newLaunch, (Process)restoreProcess, (String)Messages.DotnetExportWizard_dotnetRestore);
                launchManager.addLaunch((ILaunch)newLaunch);
                try {
                    restoreProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (restoreProcess.exitValue() != 0) {
                    return;
                }
                Process publishProcess = DebugPlugin.exec((String[])exportCommandList.toArray(new String[0]), (File)projectLocation);
                DebugPlugin.newProcess((ILaunch)newLaunch, (Process)publishProcess, (String)Messages.DotnetExportWizard_dotnetCoreExport);
                launchManager.addLaunch((ILaunch)newLaunch);
                try {
                    publishProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (publishProcess.exitValue() == 0) {
                    IPath pathToExport = Path.fromOSString((String)exportLocation.getAbsolutePath().toString());
                    IFile exportiFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(pathToExport);
                    if (exportiFile == null) {
                        return;
                    }
                    exportiFile.getProject().refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)Messages.DotnetExportWizard_exportError_title, (String)NLS.bind((String)Messages.DotnetExportWizard_exportError_message, (Object)((Object)e))));
            }
        }).schedule();
        return true;
    }

    public static IFile getProjectFile(IContainer container) {
        if (container != null) {
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource projResource = iResourceArray[n2];
                    if (projResource.getFileExtension() != null && (projResource.getFileExtension().equals("csproj") || projResource.getName().equals("project.json"))) {
                        return (IFile)projResource;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

