/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.validation.type;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.validation.type.IType;

public abstract class AbstractType
implements IType {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS;

    static {
        HashMap<Class<Serializable>, Class> map = new HashMap<Class<Serializable>, Class>();
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Character.TYPE, Character.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(map);
    }

    protected Class<?> wrapPrimitive(Class<?> source) {
        Class<?> wrapper = PRIMITIVE_WRAPPERS.get(source);
        if (wrapper != null) {
            return wrapper;
        }
        return source;
    }

    protected boolean isAssignableFrom(Class<?> toType, Class<?> fromType) {
        Class<?> wrappedToType = this.wrapPrimitive(toType);
        Class<?> wrappedFromType = this.wrapPrimitive(fromType);
        boolean result = toType == null ? false : (fromType == null ? true : wrappedToType.isAssignableFrom(wrappedFromType));
        return result;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        return ((AbstractType)obj).getType().equals(this.getType());
    }
}

