/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.namespace.CallStack;
import org.eclipse.acceleo.query.runtime.lookup.basic.CacheLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.validation.type.IType;

public class QualifiedNameLookupEngine
extends CacheLookupEngine
implements IQualifiedNameLookupEngine {
    private final Map<String, CacheLookupEngine> qualifiedNameServices = new HashMap<String, CacheLookupEngine>();
    private final IQualifiedNameResolver resolver;
    private final Deque<CallStack> callStacks = new ArrayDeque<CallStack>();

    public QualifiedNameLookupEngine(IReadOnlyQueryEnvironment queryEnvironment, IQualifiedNameResolver resolver) {
        super(queryEnvironment);
        this.resolver = resolver;
    }

    @Override
    public IService<?> lookup(String name, IType[] argumentTypes) {
        IService<?> result;
        CallStack currentStack = this.getCurrentContext();
        String last = currentStack.peek();
        IService<?> lastService = this.getLookupEngine(last).lookup(name, argumentTypes);
        if (lastService != null && lastService.getVisibility() == IService.Visibility.PRIVATE) {
            result = lastService;
        } else {
            IService<?> importedService;
            IService<?> overridingService;
            String start = currentStack.getStartingQualifiedName();
            IService<?> inLastExtendHierachyService = this.lookupExtendedService(last, null, name, argumentTypes, IService.Visibility.PROTECTED, IService.Visibility.PUBLIC);
            result = inLastExtendHierachyService != null ? (start.equals(last) ? inLastExtendHierachyService : ((overridingService = this.lookupExtendedService(start, last, name, argumentTypes, IService.Visibility.PROTECTED, IService.Visibility.PUBLIC)) != null ? overridingService : inLastExtendHierachyService)) : ((importedService = this.lookupImportedService(last, name, argumentTypes)) != null ? importedService : super.lookup(name, argumentTypes));
        }
        return result;
    }

    private IService<?> lookupExtendedService(String startQualifiedName, String stopQualifiedName, String name, IType[] argumentTypes, IService.Visibility ... candidateVisibilities) {
        String extendedModuleQualifiedName;
        IService<?> localService = this.getLookupEngine(startQualifiedName).lookup(name, argumentTypes);
        IService<Object> result = localService != null && this.isVisible(localService, candidateVisibilities) ? localService : (!startQualifiedName.equals(stopQualifiedName) ? ((extendedModuleQualifiedName = this.resolver.getExtend(startQualifiedName)) != null ? this.lookupExtendedService(extendedModuleQualifiedName, stopQualifiedName, name, argumentTypes, candidateVisibilities) : null) : null);
        return result;
    }

    private IService<?> lookupImportedService(String start, String name, IType[] argumentTypes) {
        IService<?> result = null;
        for (String imported : this.resolver.getImports(start)) {
            IService<?> service = this.lookupExtendedService(imported, null, name, argumentTypes, IService.Visibility.PUBLIC);
            if (service == null) continue;
            result = service;
            break;
        }
        return result;
    }

    @Override
    public Set<IService<?>> getServices(Set<IType> receiverTypes) {
        LinkedHashSet result = new LinkedHashSet();
        Set<IService<?>> storedServices = this.getRegisteredServices();
        for (IType type : receiverTypes) {
            if (type == null) continue;
            block1: for (IService<?> service : storedServices) {
                for (IType parameterType : service.getParameterTypes(this.queryEnvironment).get(0)) {
                    if (!parameterType.isAssignableFrom(type)) continue;
                    result.add(service);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public Set<IService<?>> getRegisteredServices() {
        LinkedHashSet result = new LinkedHashSet();
        CallStack currentStack = this.getCurrentContext();
        String last = currentStack.peek();
        Set<IService<?>> lastServices = this.getLookupEngine(last).getRegisteredServices();
        result.addAll(this.filterByVisibility(lastServices, IService.Visibility.PRIVATE));
        String start = currentStack.getStartingQualifiedName();
        result.addAll(this.getExtendedService(start, IService.Visibility.PROTECTED, IService.Visibility.PUBLIC));
        result.addAll(this.getImportedService(last));
        result.addAll(super.getRegisteredServices());
        return result;
    }

    private Set<IService<?>> getImportedService(String start) {
        LinkedHashSet result = new LinkedHashSet();
        for (String imported : this.resolver.getImports(start)) {
            result.addAll(this.getExtendedService(imported, IService.Visibility.PUBLIC));
        }
        return result;
    }

    private Set<IService<?>> getExtendedService(String startQualifiedName, IService.Visibility ... candidateVisibilities) {
        Set<IService<?>> services = this.getLookupEngine(startQualifiedName).getRegisteredServices();
        Set<IService<?>> result = this.filterByVisibility(services, candidateVisibilities);
        String extendedModuleQualifiedName = this.resolver.getExtend(startQualifiedName);
        if (extendedModuleQualifiedName != null) {
            result.addAll(this.getExtendedService(extendedModuleQualifiedName, candidateVisibilities));
        }
        return result;
    }

    @Override
    public boolean isRegisteredService(IService<?> service) {
        return this.getRegisteredServices().contains(service);
    }

    @Override
    public void pushContext(String qualifiedName) {
        CallStack currentStack = this.callStacks.peekLast();
        currentStack.push(qualifiedName);
    }

    @Override
    public void pushImportsContext(String importQualifiedName, String serviceContextQualifiedName) {
        CallStack currentStack = new CallStack(importQualifiedName);
        this.callStacks.addLast(currentStack);
        currentStack.push(serviceContextQualifiedName);
    }

    @Override
    public void popContext(String qualifiedName) {
        CallStack currentStack = this.callStacks.peekLast();
        if (currentStack == null || !currentStack.pop().equals(qualifiedName) && currentStack.isEmpty()) {
            throw new IllegalStateException("call stack is out of synchronization");
        }
        if (currentStack.isEmpty()) {
            this.callStacks.pollLast();
        }
    }

    @Override
    public void clearContext(String qualifiedName) {
        this.qualifiedNameServices.remove(qualifiedName);
        this.resolver.cleanContextQualifiedName(qualifiedName);
    }

    @Override
    public CallStack getCurrentContext() {
        CallStack res = !this.callStacks.isEmpty() ? this.callStacks.peekLast() : null;
        return res;
    }

    private Set<IService<?>> filterByVisibility(Set<IService<?>> services, IService.Visibility ... candidateVisibilities) {
        return services.stream().filter(s -> this.isVisible((IService<?>)s, candidateVisibilities)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean isVisible(IService<?> service, IService.Visibility ... candidateVisibilities) {
        List<IService.Visibility> visibilityList = Arrays.asList(candidateVisibilities);
        boolean res = visibilityList.contains((Object)service.getVisibility());
        return res;
    }

    private CacheLookupEngine getLookupEngine(String qualifiedName) {
        if (!this.qualifiedNameServices.containsKey(qualifiedName)) {
            Object object = this.resolver.resolve(qualifiedName);
            CacheLookupEngine engine = new CacheLookupEngine(this.queryEnvironment);
            for (IService<?> service : this.resolver.getServices(this, object, qualifiedName)) {
                engine.registerService(service);
            }
            this.qualifiedNameServices.put(qualifiedName, engine);
        }
        return this.qualifiedNameServices.get(qualifiedName);
    }

    @Override
    public IReadOnlyQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    @Override
    public String getExtend(String qualifiedName) {
        return this.resolver.getExtend(qualifiedName);
    }

    @Override
    public List<String> getImports(String qualifiedName) {
        return this.resolver.getImports(qualifiedName);
    }

    @Override
    public IQualifiedNameResolver getResolver() {
        return this.resolver;
    }

    @Override
    public IService<?> superServiceLookup(String name, IType[] argumentTypes) {
        CallStack currentStack = this.getCurrentContext();
        String start = currentStack.getStartingQualifiedName();
        String extendQualifiedName = this.getExtend(start);
        IService<?> result = extendQualifiedName != null ? this.lookupExtendedService(extendQualifiedName, null, name, argumentTypes, IService.Visibility.PROTECTED, IService.Visibility.PUBLIC) : null;
        return result;
    }

    @Override
    public boolean isInExtends(String startQualifiedName, String calleeQualifiedName) {
        String currentQualifiedName = startQualifiedName;
        while (currentQualifiedName != null) {
            if (currentQualifiedName.equals(calleeQualifiedName)) {
                return true;
            }
            currentQualifiedName = this.getExtend(currentQualifiedName);
        }
        return false;
    }
}

