/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.command.AbstractDocumentRangeCommand;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class WrapInIfCommand
extends AbstractDocumentRangeCommand {
    public WorkspaceEdit exec(AcceleoTextDocument document, Range range) {
        WorkspaceEdit res;
        if (range.getStart().getCharacter() == 0 && range.getEnd().getCharacter() == 0) {
            int startIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getStart(), document.getContents());
            int endIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getEnd(), document.getContents());
            String text = document.getContents().substring(startIndex, endIndex);
            if (!text.isEmpty() && this.isSameBlock(document, startIndex, endIndex)) {
                LinkedHashMap<String, List<TextEdit>> changes = new LinkedHashMap<String, List<TextEdit>>();
                IfStatement statement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createIfStatement();
                Expression expression = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
                AQLUtils.AcceleoAQLResult aqlExpression = AQLUtils.parseWhileAqlExpression((String)"expression");
                expression.setAst(aqlExpression.getAstResult());
                expression.setAql(aqlExpression.getAstResult().getAst());
                statement.setCondition(expression);
                String lineDelimiter = System.lineSeparator();
                String blockIndentation = this.getBlockIndentation(text);
                statement.setThen(this.createBlock(text, blockIndentation, "  ", lineDelimiter, false));
                String replacementText = blockIndentation + new AcceleoAstSerializer(lineDelimiter).serialize((AcceleoASTNode)statement);
                Range replacementRange = AcceleoLanguageServerPositionUtils.getCorrespondingRange(startIndex, endIndex, document.getContents());
                TextEdit edit = new TextEdit(replacementRange, replacementText + lineDelimiter);
                String sourceURI = document.getQueryEnvironment().getLookupEngine().getResolver().getSourceURI(document.getModuleQualifiedName()).toString();
                changes.put(sourceURI, Collections.singletonList(edit));
                res = new WorkspaceEdit(changes);
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }
}

