/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler;

import org.eclipse.acceleo.aql.profiler.IProfiler;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfileResource;
import org.eclipse.acceleo.aql.profiler.ProfilerFactory;
import org.eclipse.acceleo.aql.profiler.internal.AbstractProfiler;
import org.eclipse.acceleo.aql.profiler.internal.FlatProfiler;
import org.eclipse.acceleo.aql.profiler.internal.TreeProfiler;
import org.eclipse.emf.common.util.TreeIterator;

public final class ProfilerUtils {
    public static final String PROFILE_EXTENSION = "mtlp";

    private ProfilerUtils() {
    }

    public static void computePercentage(ProfileResource resource) {
        ProfileEntry root = resource.getEntry();
        if (root != null) {
            long baseTime = root.getDuration();
            root.setPercentage(100.0f);
            TreeIterator itContent = root.eAllContents();
            while (itContent.hasNext()) {
                ProfileEntry node = (ProfileEntry)itContent.next();
                node.setPercentage((float)node.getDuration() * 100.0f / (float)baseTime);
            }
        }
    }

    public static IProfiler getProfiler(String startResource, Representation representation, ProfilerFactory profilerFactory) {
        AbstractProfiler res = null;
        switch (representation) {
            case TREE: {
                res = new TreeProfiler(profilerFactory, startResource);
                break;
            }
            case FLAT: {
                res = new FlatProfiler(profilerFactory, startResource);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return res;
    }

    public static enum Representation {
        TREE("Tree profiling", "It creates a tree representing the profiled process"),
        FLAT("Flat profiling", "It creates a flat representation of the profiled process");

        private final String name;
        private final String hint;

        private Representation(String name, String hint) {
            this.name = name;
            this.hint = hint;
        }

        public String getName() {
            return this.name;
        }

        public String getHint() {
            return this.hint;
        }
    }
}

