/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.ide.authoring.AcceleoModelManager;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class AcceleoCommonIDEPlugin
implements BundleActivator {
    private final WorkspaceEcoreListener workspaceEcoreListener = new WorkspaceEcoreListener();

    public void start(BundleContext context) throws Exception {
        Bundle pdeCoreBundle = Platform.getBundle((String)"org.eclipse.pde.core");
        if (pdeCoreBundle != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.workspaceEcoreListener, 7);
        }
        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && resource instanceof IFile && ((IFile)resource).getFileExtension() != null && ((IFile)resource).getFileExtension().equals("ecore") && AcceleoCommonIDEPlugin.this.mightBeInAcceleoScope((IFile)resource)) {
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                    AcceleoPackageRegistry.INSTANCE.registerEcorePackages(uri.toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
                }
                return true;
            }
        });
        AcceleoModelManager.getManager().startup();
    }

    public void stop(BundleContext context) throws Exception {
        Bundle pdeCoreBundle = Platform.getBundle((String)"org.eclipse.pde.core");
        if (pdeCoreBundle != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.workspaceEcoreListener);
        }
        AcceleoModelManager.getManager().shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mightBeInAcceleoScope(IFile ecoreFile) {
        try {
            if (ecoreFile.getProject() == null) return false;
            if (ecoreFile.getProject().getDescription() == null) return false;
            String[] stringArray = ecoreFile.getProject().getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if ("org.eclipse.pde.PluginNature".equals(nature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private class WorkspaceEcoreListener
    implements IResourceChangeListener {
        WorkspaceEcoreListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    if (!(event.getResource() instanceof IProject)) break;
                    try {
                        List<IFile> ecoreFiles = this.members((IContainer)event.getResource(), "ecore");
                        if (ecoreFiles.isEmpty()) break;
                        for (IFile ecoreFile : ecoreFiles) {
                            AcceleoPackageRegistry.INSTANCE.unregisterEcorePackages(ecoreFile.getFullPath().toString());
                        }
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), (boolean)false);
                    }
                    break;
                }
                case 1: {
                    IResource resource = null;
                    if (event.getResource() != null) {
                        resource = event.getResource();
                    } else if (this.getResources(event.getDelta()).size() > 0) {
                        List<IResource> resources = this.getResources(event.getDelta());
                        resource = resources.get(0);
                    }
                    if (resource == null || !resource.isAccessible() || resource.getFileExtension() == null || !resource.getFileExtension().endsWith("ecore") || !(resource instanceof IFile) || !AcceleoCommonIDEPlugin.this.mightBeInAcceleoScope((IFile)resource)) break;
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                    AcceleoPackageRegistry.INSTANCE.registerEcorePackages(uri.toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
                }
            }
        }

        private List<IResource> getResources(IResourceDelta delta) {
            IResourceDelta[] affectedChildren;
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren();
            int n = affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta iResourceDelta = iResourceDeltaArray[n2];
                IResource resource = iResourceDelta.getResource();
                if (resource instanceof IFile && ((IFile)resource).getFileExtension() != null && ((IFile)resource).getFileExtension().equals("ecore")) {
                    resources.add(resource);
                }
                resources.addAll(this.getResources(iResourceDelta));
                ++n2;
            }
            return resources;
        }

        private List<IFile> members(IContainer container, String extension) throws CoreException {
            IResource[] children;
            ArrayList<IFile> output = new ArrayList<IFile>();
            if (container != null && container.isAccessible() && (children = container.members()) != null) {
                int i = 0;
                while (i < children.length) {
                    IResource resource = children[i];
                    if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                        output.add((IFile)resource);
                    } else if (resource instanceof IContainer) {
                        output.addAll(this.members((IContainer)resource, extension));
                    }
                    ++i;
                }
            }
            return output;
        }
    }
}

