/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;

public class BasicLookupEngine
implements ILookupEngine {
    private static final String INSTANTIATION_PROBLEM_MSG = "Couldn't instantiate class ";
    private static final String SET_CROSS_REFERENCER_METHOD_NAME = "setCrossReferencer";
    private static final String SET_ROOT_PROVIDER_METHOD_NAME = "setRootProvider";
    private static final String PACKAGE_PROBLEM_MSG = "No zero argument constructor found in class ";
    private final Map<Integer, Map<String, List<IService>>> services = new HashMap<Integer, Map<String, List<IService>>>();
    private final Map<Class<?>, Set<IService>> classToServices = new LinkedHashMap();
    private IReadOnlyQueryEnvironment queryEnvironment;
    private CrossReferenceProvider crossReferencer;
    private IRootEObjectProvider rootProvider;

    public BasicLookupEngine(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer) {
        this(queryEnvironment, crossReferencer, null);
    }

    public BasicLookupEngine(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer, IRootEObjectProvider rootProvider) {
        this.queryEnvironment = queryEnvironment;
        this.crossReferencer = crossReferencer;
        this.rootProvider = rootProvider;
    }

    @Override
    public CrossReferenceProvider getCrossReferencer() {
        return this.crossReferencer;
    }

    @Override
    public IRootEObjectProvider getRootEObjectProvider() {
        return this.rootProvider;
    }

    protected Map<Integer, Map<String, List<IService>>> getServices() {
        return this.services;
    }

    @Override
    public Map<Class<?>, Set<IService>> getRegisteredServices() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<Class<?>, Set<IService>> entry : this.classToServices.entrySet()) {
            result.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return result;
    }

    private List<IService> getOrCreateMultiService(IService service) {
        List<IService> result;
        int argc = service.getNumberOfParameters();
        String serviceName = service.getName();
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            argcServices = new HashMap<String, List<IService>>();
            this.services.put(argc, argcServices);
        }
        if ((result = argcServices.get(serviceName)) == null) {
            result = new ArrayList<IService>();
            argcServices.put(serviceName, result);
        }
        return result;
    }

    private List<IService> getMultimethod(String methodName, int argc) {
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(methodName);
    }

    private boolean matches(IService service, Class<?>[] argumentTypes) {
        assert (service.getNumberOfParameters() != argumentTypes.length);
        boolean result = true;
        List<IType> parameterTypes = service.getParameterTypes(this.queryEnvironment);
        int i = 0;
        while (i < parameterTypes.size() && result) {
            if (argumentTypes[i] != null && !parameterTypes.get(i).isAssignableFrom(new ClassType(this.queryEnvironment, argumentTypes[i]))) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean isLowerOrEqualParameterTypes(IService service1, IService service2) {
        List<IType> paramTypes1 = service1.getParameterTypes(this.queryEnvironment);
        List<IType> paramTypes2 = service2.getParameterTypes(this.queryEnvironment);
        boolean result = paramTypes1.size() == paramTypes2.size();
        Iterator<IType> it1 = paramTypes1.iterator();
        Iterator<IType> it2 = paramTypes2.iterator();
        while (result && it1.hasNext()) {
            IType paramType1 = it1.next();
            IType paramType2 = it2.next();
            if (paramType2.isAssignableFrom(paramType1)) continue;
            result = false;
        }
        return result;
    }

    private boolean isLowerParameterTypes(IService service1, IService service2) {
        return this.isLowerOrEqualParameterTypes(service1, service2) && !this.isEqualParameterTypes(service1, service2);
    }

    private boolean isEqualParameterTypes(IService service1, IService service2) {
        List<IType> paramTypes1 = service1.getParameterTypes(this.queryEnvironment);
        List<IType> paramTypes2 = service2.getParameterTypes(this.queryEnvironment);
        boolean result = paramTypes1.size() == paramTypes2.size();
        Iterator<IType> it1 = paramTypes1.iterator();
        Iterator<IType> it2 = paramTypes2.iterator();
        while (result && it1.hasNext()) {
            IType paramType1 = it1.next();
            IType paramType2 = it2.next();
            if (paramType2.equals(paramType1)) continue;
            result = false;
        }
        return result;
    }

    private boolean isEqual(IService service1, IService service2) {
        return service1.getName().equals(service2.getName()) && this.isEqualParameterTypes(service1, service2);
    }

    private boolean isLower(IService service1, IService service2) {
        return service1.getName().equals(service2.getName()) && this.isLowerParameterTypes(service1, service2);
    }

    @Override
    public IService lookup(String name, Class<?>[] argumentTypes) {
        List<IService> multiMethod = this.getMultimethod(name, argumentTypes.length);
        if (multiMethod == null) {
            return null;
        }
        IService result = null;
        for (IService service : multiMethod) {
            if (!this.matches(service, argumentTypes) || result != null && !this.isLowerOrEqualParameterTypes(service, result)) continue;
            result = service;
        }
        return result;
    }

    @Override
    public boolean isServiceMethod(Object instance, Method method) {
        return method.getDeclaringClass() != Object.class && (instance != null || Modifier.isStatic(method.getModifiers()));
    }

    @Override
    public boolean isCrossReferencerMethod(Method method) {
        boolean crossRefSet = SET_CROSS_REFERENCER_METHOD_NAME.equals(method.getName()) && method.getParameterTypes().length > 0 && CrossReferenceProvider.class.isAssignableFrom(method.getParameterTypes()[0]);
        return crossRefSet;
    }

    @Override
    public boolean isRootProviderMethod(Method method) {
        boolean result = SET_ROOT_PROVIDER_METHOD_NAME.equals(method.getName()) && method.getParameterTypes().length > 0 && IRootEObjectProvider.class.isAssignableFrom(method.getParameterTypes()[0]);
        return result;
    }

    private ServiceRegistrationResult registerServices(IServiceProvider provider) throws InvalidAcceleoPackageException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : provider.getServices(this.queryEnvironment)) {
            result.merge(this.registerService(provider.getClass(), service));
        }
        return result;
    }

    public ServiceRegistrationResult registerServices(Class<?> newServices) throws InvalidAcceleoPackageException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        if (newServices == null) {
            throw new NullPointerException("the service class can't be null");
        }
        if (!this.isRegisteredService(newServices)) {
            try {
                Constructor<?> cstr = null;
                Object instance = null;
                try {
                    cstr = newServices.getConstructor(new Class[0]);
                    instance = cstr.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        cstr = newServices.getConstructor(IReadOnlyQueryEnvironment.class);
                        instance = cstr.newInstance(this.queryEnvironment);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {}
                }
                if (instance instanceof IServiceProvider) {
                    result.merge(this.registerServices((IServiceProvider)instance));
                } else {
                    Method[] methods = newServices.getMethods();
                    result.merge(this.getServicesFromInstance(newServices, instance, methods));
                }
            }
            catch (SecurityException e) {
                throw new InvalidAcceleoPackageException(PACKAGE_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (InstantiationException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (IllegalAccessException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (InvocationTargetException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
        }
        return result;
    }

    @Override
    public boolean isRegisteredService(Class<?> cls) {
        return this.classToServices.containsKey(cls);
    }

    public Class<?> removeServices(Class<?> servicesClass) {
        Class<?> result;
        Set<IService> servicesSet = this.classToServices.remove(servicesClass);
        if (servicesSet != null) {
            result = servicesClass;
            for (IService service : servicesSet) {
                int argc = service.getNumberOfParameters();
                Map<String, List<IService>> argcServices = this.services.get(argc);
                String serviceName = service.getName();
                List<IService> servicesList = argcServices.get(serviceName);
                servicesList.remove(service);
                if (!servicesList.isEmpty()) continue;
                argcServices.remove(serviceName);
                if (!argcServices.isEmpty()) continue;
                this.services.remove(argc);
            }
        } else {
            result = null;
        }
        return result;
    }

    private ServiceRegistrationResult getServicesFromInstance(Class<?> newServices, Object instance, Method[] methods) throws IllegalAccessException, InvocationTargetException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isCrossReferencerMethod(method)) {
                method.invoke(instance, this.crossReferencer);
            } else if (this.isServiceMethod(instance, method)) {
                JavaMethodService service = new JavaMethodService(method, instance);
                result.merge(this.registerService(newServices, service));
            }
            ++n2;
        }
        return result;
    }

    private ServiceRegistrationResult registerService(Class<?> newServices, IService service) {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        List<IService> multiService = this.getOrCreateMultiService(service);
        for (IService existingService : multiService) {
            if (this.isEqual(service, existingService)) {
                result.addDuplicated(service, existingService);
                continue;
            }
            if (this.isLower(service, existingService)) {
                result.addMasked(service, existingService);
                continue;
            }
            if (!this.isLower(existingService, service)) continue;
            result.addIsMaskedBy(service, existingService);
        }
        result.getRegistered().add(service);
        multiService.add(service);
        Set<IService> servicesSet = this.classToServices.get(newServices);
        if (servicesSet == null) {
            servicesSet = new LinkedHashSet<IService>();
            this.classToServices.put(newServices, servicesSet);
        }
        servicesSet.add(service);
        return result;
    }

    @Override
    public Set<IService> getServices(Set<Class<?>> receiverTypes) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        for (Class<?> cls : receiverTypes) {
            if (cls == null) continue;
            for (Set<IService> servicesSet : this.classToServices.values()) {
                for (IService service : servicesSet) {
                    if (!service.getParameterTypes(this.queryEnvironment).get(0).isAssignableFrom(new ClassType(this.queryEnvironment, cls))) continue;
                    result.add(service);
                }
            }
        }
        return result;
    }
}

