/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EEnumLiteralCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.JavaMethodServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableDeclarationCompletionProposal;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CompletionServices
extends ValidationServices {
    public CompletionServices(IQueryEnvironment queryEnv) {
        super(queryEnv);
    }

    public List<VariableCompletionProposal> getVariableProposals(List<String> variableNames) {
        ArrayList<VariableCompletionProposal> result = new ArrayList<VariableCompletionProposal>();
        for (String varName : variableNames) {
            result.add(new VariableCompletionProposal(varName));
        }
        return result;
    }

    public List<IServiceCompletionProposal> getServiceProposals(Set<IType> receiverTypes, CallType callType) {
        ArrayList<IServiceCompletionProposal> result = new ArrayList<IServiceCompletionProposal>();
        LinkedHashSet classes = new LinkedHashSet();
        if (CallType.CALLORAPPLY.equals((Object)callType)) {
            for (IType type : receiverTypes) {
                if (type instanceof ICollectionType) {
                    ICollectionType collectionType = (ICollectionType)type;
                    IType cType = collectionType.getCollectionType();
                    classes.add(this.getClass(cType));
                    continue;
                }
                classes.add(this.getClass(type));
            }
        } else if (CallType.COLLECTIONCALL.equals((Object)callType) || callType == null) {
            for (IType type : receiverTypes) {
                classes.add(this.getClass(type));
            }
        }
        for (IService service : this.queryEnvironment.getLookupEngine().getServices(classes)) {
            IServiceCompletionProposal serviceCompletionProposal;
            if (callType != null && AstBuilderListener.OPERATOR_SERVICE_NAMES.contains(service.getName()) || (serviceCompletionProposal = this.getServiceCompletionProposal(service)) == null) continue;
            result.add(serviceCompletionProposal);
        }
        return result;
    }

    protected IServiceCompletionProposal getServiceCompletionProposal(IService service) {
        JavaMethodServiceCompletionProposal result = service instanceof JavaMethodService ? new JavaMethodServiceCompletionProposal((JavaMethodService)service) : null;
        return result;
    }

    public List<EOperationCompletionProposal> getEOperationProposals(Set<IType> receiverTypes) {
        ArrayList<EOperationCompletionProposal> result = new ArrayList<EOperationCompletionProposal>();
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        for (IType type : receiverTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            eClasses.add((EClass)type.getType());
        }
        for (EOperation eOperation : this.queryEnvironment.getEPackageProvider().getEOperations(eClasses)) {
            result.add(new EOperationCompletionProposal(eOperation));
        }
        return result;
    }

    public List<EFeatureCompletionProposal> getEStructuralFeatureProposals(Set<IType> receiverTypes) {
        ArrayList<EFeatureCompletionProposal> result = new ArrayList<EFeatureCompletionProposal>();
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        for (IType iType : receiverTypes) {
            ICollectionType collectionType;
            IType type;
            if (iType.getType() instanceof EClass) {
                eClasses.add((EClass)iType.getType());
                continue;
            }
            if (!(iType instanceof ICollectionType) || !((type = (collectionType = (ICollectionType)iType).getCollectionType()).getType() instanceof EClass)) continue;
            eClasses.add((EClass)type.getType());
        }
        for (EStructuralFeature feature : this.queryEnvironment.getEPackageProvider().getEStructuralFeatures(eClasses)) {
            result.add(new EFeatureCompletionProposal(feature));
        }
        return result;
    }

    public List<EClassifierCompletionProposal> getEClassifierProposals() {
        ArrayList<EClassifierCompletionProposal> result = new ArrayList<EClassifierCompletionProposal>();
        for (EClassifier eClassifier : this.queryEnvironment.getEPackageProvider().getEClassifiers()) {
            result.add(new EClassifierCompletionProposal(eClassifier));
        }
        return result;
    }

    public List<EClassifierCompletionProposal> getEClassifierProposals(String name) {
        ArrayList<EClassifierCompletionProposal> result = new ArrayList<EClassifierCompletionProposal>();
        EPackage ePkg = this.queryEnvironment.getEPackageProvider().getEPackage(name);
        if (ePkg != null) {
            for (EClassifier eClassifier : ePkg.getEClassifiers()) {
                result.add(new EClassifierCompletionProposal(eClassifier));
            }
        }
        return result;
    }

    public List<EEnumLiteralCompletionProposal> getEEnumLiteralProposals() {
        ArrayList<EEnumLiteralCompletionProposal> result = new ArrayList<EEnumLiteralCompletionProposal>();
        for (EEnumLiteral literal : this.queryEnvironment.getEPackageProvider().getEEnumLiterals()) {
            result.add(new EEnumLiteralCompletionProposal(literal));
        }
        return result;
    }

    public List<EEnumLiteralCompletionProposal> getEEnumLiteralProposals(String name) {
        ArrayList<EEnumLiteralCompletionProposal> result = new ArrayList<EEnumLiteralCompletionProposal>();
        EPackage ePkg = this.queryEnvironment.getEPackageProvider().getEPackage(name);
        if (ePkg != null) {
            for (EClassifier eClassifier : ePkg.getEClassifiers()) {
                if (!(eClassifier instanceof EEnum)) continue;
                for (EEnumLiteral literal : ((EEnum)eClassifier).getELiterals()) {
                    result.add(new EEnumLiteralCompletionProposal(literal));
                }
            }
        }
        return result;
    }

    public List<EEnumLiteralCompletionProposal> getEEnumLiteralProposals(String name, String eEnumName) {
        EClassifier eClassifier;
        ArrayList<EEnumLiteralCompletionProposal> result = new ArrayList<EEnumLiteralCompletionProposal>();
        EPackage ePkg = this.queryEnvironment.getEPackageProvider().getEPackage(name);
        if (ePkg != null && (eClassifier = ePkg.getEClassifier(eEnumName)) instanceof EEnum) {
            for (EEnumLiteral literal : ((EEnum)eClassifier).getELiterals()) {
                result.add(new EEnumLiteralCompletionProposal(literal));
            }
        }
        return result;
    }

    public List<VariableDeclarationCompletionProposal> getVariableDeclarationProposals(Set<IType> possibleTypes) {
        ArrayList<VariableDeclarationCompletionProposal> result = new ArrayList<VariableDeclarationCompletionProposal>();
        for (IType type : possibleTypes) {
            result.add(new VariableDeclarationCompletionProposal(type));
        }
        return result;
    }
}

