/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationMappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeleteLinkCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class SegmentDeleteCommand
extends Command {
    private CompoundCommand deleteLinks;
    private Segment segment;
    private SystemConfiguration segmentParent;
    private CompoundCommand unmapCommands;

    public void execute() {
        this.removeLinks();
        this.segmentParent = (SystemConfiguration)this.segment.eContainer();
        this.segmentParent.getSegments().remove((Object)this.segment);
        this.unmapCommands = this.handleCommunicationMapping();
        this.unmapCommands.execute();
    }

    private CompoundCommand handleCommunicationMapping() {
        CompoundCommand cmd = new CompoundCommand();
        CommunicationConfiguration config = this.segment.getCommunication();
        if (config != null) {
            for (CommunicationMappingTarget tgt : config.getMappingTargets()) {
                for (CommunicationChannel channel : tgt.getMappedElements()) {
                    cmd.add((Command)new UnmapCommand((FBNetworkElement)channel));
                }
            }
        }
        return cmd;
    }

    private void removeLinks() {
        this.deleteLinks = new CompoundCommand();
        for (Link link : this.segment.getOutConnections()) {
            DeleteLinkCommand cmd = new DeleteLinkCommand(link);
            this.deleteLinks.add((Command)cmd);
        }
        this.deleteLinks.execute();
    }

    public void undo() {
        this.segmentParent.getSegments().add((Object)this.segment);
        this.deleteLinks.undo();
        this.unmapCommands.undo();
    }

    public void redo() {
        this.segmentParent.getSegments().remove((Object)this.segment);
        this.deleteLinks.redo();
        this.unmapCommands.redo();
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setSegment(Segment segment) {
        this.segment = segment;
    }
}

