/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.resource;

import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResource;

public class STAlgorithmResource
extends STCoreResource {
    private static final Set<String> FILE_EXTENSIONS = Set.of("FBT", "SYS", "SUB", "ADP", "DTP", "ATP", "RES", "DEV", "SEG");
    private static final Set<String> ADDITIONAL_FILE_EXTENSIONS = Set.of("SYS", "SUB", "ADP", "DTP", "ATP", "RES", "DEV", "SEG");

    public static boolean isValidFileExtension(String fileExtension) {
        return fileExtension != null && FILE_EXTENSIONS.contains(fileExtension.toUpperCase());
    }

    public static boolean isValidAdditionalFileExtension(String fileExtension) {
        return fileExtension != null && ADDITIONAL_FILE_EXTENSIONS.contains(fileExtension.toUpperCase());
    }

    public static boolean isValidUri(URI uri) {
        return uri.isPlatformResource() && STAlgorithmResource.isValidFileExtension(uri.fileExtension());
    }

    public static boolean isValidAdditionalUri(URI uri) {
        return uri.isPlatformResource() && STAlgorithmResource.isValidAdditionalFileExtension(uri.fileExtension());
    }

    protected boolean needsInternalLibraryElement(LibraryElement libraryElement, EObject sourceElement) {
        return super.needsInternalLibraryElement(libraryElement, sourceElement) || libraryElement instanceof BaseFBType && sourceElement.eContainer() instanceof VarDeclaration || libraryElement instanceof BasicFBType && sourceElement instanceof ECTransition;
    }
}

