/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;

public final class EventTypeLibrary {
    public static final String EVENT = "Event";
    public static final String EINIT = "EInit";
    private static final EventTypeLibrary INSTANCE = new EventTypeLibrary();
    private final Map<String, EventType> typeMap = new ConcurrentHashMap<String, EventType>();

    private EventTypeLibrary() {
        this.initElementaryTypes();
    }

    public static EventTypeLibrary getInstance() {
        return INSTANCE;
    }

    private void initElementaryTypes() {
        this.getType(EVENT);
        this.getType(EINIT);
    }

    public Collection<EventType> getEventTypes() {
        return Collections.unmodifiableCollection(this.typeMap.values());
    }

    public static boolean isGenericEventType(DataType type) {
        return type instanceof EventType && EVENT.equalsIgnoreCase(type.getName());
    }

    public EventType getType(String name) {
        if (name == null) {
            return this.getType(EVENT);
        }
        return this.typeMap.computeIfAbsent(name, this::createEventType);
    }

    private EventType createEventType(String name) {
        EventType type = DataFactory.eINSTANCE.createEventType();
        type.setName(name);
        EventTypeLibrary.encloseInResource(type);
        return type;
    }

    private static void encloseInResource(EventType type) {
        new ResourceImpl(URI.createFileURI((String)(type.getName() + ".eventlib.dtp"))).getContents().add((Object)type);
    }
}

