/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.datatype.helper;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.AttributeTarget;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Value;

public final class InternalAttributeDeclarations {
    private static final String ATTRIBUTE_DECLARATION_LIB_URI = "internal_attribute_declarations.lib";
    private static final Resource ATTRIBUTE_DECLARATION_RES = new ResourceImpl(URI.createURI((String)"internal_attribute_declarations.lib"));
    public static final AttributeDeclaration INHERIT = InternalAttributeDeclarations.createAttributeDeclaration("INHERIT", IecTypes.ElementaryTypes.STRING);
    public static final AttributeDeclaration VAR_CONFIG = InternalAttributeDeclarations.createAttributeDeclaration("VarConfig", IecTypes.ElementaryTypes.BOOL, AttributeInheritMode.COPY);
    public static final AttributeDeclaration VISIBLE = InternalAttributeDeclarations.createAttributeDeclaration("Visible", IecTypes.ElementaryTypes.BOOL, AttributeInheritMode.COPY);
    public static final AttributeDeclaration INOUT_VISIBLE_OUT = InternalAttributeDeclarations.createAttributeDeclaration("VisibleOutSide", IecTypes.ElementaryTypes.BOOL, AttributeInheritMode.COPY);
    public static final AttributeDeclaration UNFOLDED = InternalAttributeDeclarations.createAttributeDeclaration("Unfolded", IecTypes.ElementaryTypes.BOOL);
    public static final AttributeDeclaration RETAIN = InternalAttributeDeclarations.createAttributeDeclaration("Retain", IecTypes.ElementaryTypes.USINT);
    public static final AttributeDeclaration TARGET = InternalAttributeDeclarations.createTargetAttributeDeclaration();
    public static final AttributeDeclaration NEGATED = InternalAttributeDeclarations.createAttributeDeclaration("Negated", IecTypes.ElementaryTypes.BOOL);
    private static final List<AttributeDeclaration> allAttributes = List.of(VAR_CONFIG, VISIBLE, INOUT_VISIBLE_OUT, UNFOLDED, RETAIN, TARGET, NEGATED, INHERIT);

    private static boolean addAttribbuteDeclarationToResource(AttributeDeclaration decl) {
        return ATTRIBUTE_DECLARATION_RES.getContents().add((Object)decl);
    }

    private static AttributeDeclaration createAttributeDeclaration(String name, DataType type) {
        AttributeDeclaration declaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        declaration.setName(name);
        DirectlyDerivedType directlyDerivedType = DataFactory.eINSTANCE.createDirectlyDerivedType();
        directlyDerivedType.setBaseType(type);
        declaration.setType(directlyDerivedType);
        InternalAttributeDeclarations.addAttribbuteDeclarationToResource(declaration);
        return declaration;
    }

    private static AttributeDeclaration createAttributeDeclaration(String name, DataType type, AttributeInheritMode inheritMode) {
        AttributeDeclaration declaration = InternalAttributeDeclarations.createAttributeDeclaration(name, type);
        declaration.setAttribute(INHERIT, inheritMode.name(), null);
        return declaration;
    }

    private static AttributeDeclaration createTargetAttributeDeclaration() {
        AttributeDeclaration declaration = LibraryElementFactory.eINSTANCE.createAttributeDeclaration();
        declaration.setName("TARGET");
        StructuredType structType = DataFactory.eINSTANCE.createStructuredType();
        AttributeTarget[] attributeTargetArray = AttributeTarget.values();
        int n = attributeTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeTarget target = attributeTargetArray[n2];
            structType.getMemberVariables().add((Object)InternalAttributeDeclarations.createTargetMember(target));
            ++n2;
        }
        declaration.setType(structType);
        InternalAttributeDeclarations.addAttribbuteDeclarationToResource(declaration);
        return declaration;
    }

    private static MemberVarDeclaration createTargetMember(AttributeTarget target) {
        MemberVarDeclaration member = LibraryElementFactory.eINSTANCE.createMemberVarDeclaration();
        member.setName(target.name());
        member.setType(IecTypes.ElementaryTypes.BOOL);
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue("TRUE");
        member.setValue(val);
        return member;
    }

    public static AttributeDeclaration getInternalAttributeByName(String name) {
        return InternalAttributeDeclarations.getAllInternalAttributes().stream().filter(decl -> decl.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static List<AttributeDeclaration> getAllInternalAttributes() {
        return allAttributes;
    }

    public static boolean isInternalAttribute(AttributeDeclaration declaration) {
        if (declaration == null) {
            return false;
        }
        return InternalAttributeDeclarations.getAllInternalAttributes().contains(declaration);
    }

    public static boolean isInternalAttribute(Attribute attribute) {
        return InternalAttributeDeclarations.getInternalAttributeByName(attribute.getName()) != null;
    }

    private InternalAttributeDeclarations() {
        throw new UnsupportedOperationException();
    }
}

