/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class ChangeContractCommand
extends Command {
    public static final String CONTRACT_ATTRIBUTE_NAME = "_SUBAPP_CONTRACT";
    private final SubApp subApp;
    private final String contract;
    private String oldContract;

    public ChangeContractCommand(SubApp subApp, String contract) {
        this.subApp = Objects.requireNonNull(subApp);
        this.contract = contract;
    }

    public void execute() {
        this.oldContract = this.subApp.getAttributeValue(CONTRACT_ATTRIBUTE_NAME);
        this.subApp.deleteAttribute(CONTRACT_ATTRIBUTE_NAME);
        if (this.contract != null) {
            this.subApp.setAttribute(CONTRACT_ATTRIBUTE_NAME, (DataType)IecTypes.HelperTypes.CDATA, this.contract, "");
        }
    }

    public void undo() {
        this.subApp.deleteAttribute(CONTRACT_ATTRIBUTE_NAME);
        if (this.oldContract != null) {
            this.subApp.setAttribute(CONTRACT_ATTRIBUTE_NAME, (DataType)IecTypes.HelperTypes.CDATA, this.oldContract, "");
        }
    }

    public void redo() {
        this.subApp.deleteAttribute(CONTRACT_ATTRIBUTE_NAME);
        if (this.contract != null) {
            this.subApp.setAttribute(CONTRACT_ATTRIBUTE_NAME, (DataType)IecTypes.HelperTypes.CDATA, this.contract, "");
        }
    }
}

