/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Node;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AbstractChangeHierarchyOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AddLeafOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.DeleteNodeOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.UpdateLeafRefOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerRefactoringUtil;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerUtil;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListener;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class HierarchyManagerUpdateListener
extends QualNameChangeListener {
    private final HashMap<String, List<AbstractOperation>> undoDeleteOperations = new HashMap();

    public List<AbstractOperation> constructExecutableUndoOperations(QualNameChange change, Object o) {
        return this.constructOperation(change, o, true);
    }

    protected List<AbstractOperation> constructExecutableOperations(QualNameChange qualNameChange, Object rootLevel) {
        return this.constructOperation(qualNameChange, rootLevel, false);
    }

    protected List<AbstractOperation> constructOperation(QualNameChange qualNameChange, Object rootLevel, boolean isUndo) {
        if (qualNameChange.state() == QualNameChangeListener.QualNameChangeState.DELETE_UNDO) {
            return this.undoDeleteOperations.remove(qualNameChange.oldQualName());
        }
        String identifier = isUndo ? qualNameChange.newQualName() : qualNameChange.oldQualName();
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        if (rootLevel == null) {
            return Collections.emptyList();
        }
        List<Leaf> leafs = HierarchyManagerUtil.searchLeaf((RootLevel)rootLevel, leaf -> leaf.getRef().contains(identifier));
        if (leafs == null || leafs.isEmpty()) {
            return Collections.emptyList();
        }
        String newRef = isUndo ? qualNameChange.oldQualName() : qualNameChange.newQualName();
        for (Leaf leaf2 : leafs) {
            if (qualNameChange.state() == QualNameChangeListener.QualNameChangeState.DELETE || qualNameChange.state() == QualNameChangeListener.QualNameChangeState.DELETE_REDO) {
                result.add(new DeleteNodeOperation((Node)leaf2));
                this.storeUndoDeleteOperations(qualNameChange.oldQualName(), leaf2);
                continue;
            }
            result.add(new UpdateLeafRefOperation(leaf2, newRef, identifier));
        }
        return result;
    }

    protected Object getReceiver(TypeEntry key) {
        IProject project = key.getFile().getProject();
        if (!HierarchyManagerRefactoringUtil.plantHierachyExists(project)) {
            return null;
        }
        return HierarchyManagerRefactoringUtil.getPlantHierarchy(project);
    }

    protected void executeOperation(AbstractOperation op) {
        AbstractHierarchyHandler.executeOperation((AbstractChangeHierarchyOperation)op);
    }

    protected boolean isEnabled(INamedElement element) {
        return element instanceof UntypedSubApp || element instanceof TypedSubApp;
    }

    protected void storeUndoDeleteOperations(String qualName, Leaf leaf) {
        AddLeafOperation op = new AddLeafOperation((Level)leaf.eContainer(), leaf);
        this.undoDeleteOperations.computeIfAbsent(qualName, k -> new ArrayList()).add(op);
    }
}

