/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.util;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public final class ForteNgExportUtil {
    public static final CharSequence CONNECTION_EXPORT_PREFIX = "conn_";
    public static final CharSequence VARIABLE_EXPORT_PREFIX = "var_";
    public static final CharSequence EVENT_EXPORT_PREFIX = "evt_";
    public static final CharSequence FB_EXPORT_PREFIX = "fb_";
    public static final Set<String> RESERVED_KEYWORDS = Set.of("alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit", "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char8_t", "char16_t", "char32_t", "class", "compl", "concept", "const", "consteval", "constexpr", "constinit", "const_cast", "continue", "contract_assert", "co_await", "co_return", "co_yield", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "reflexpr", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "synchronized", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq");
    private static final Pattern END_COMMENT_PATTERN = Pattern.compile("\\*/");
    private static final String GENERIC_CLASS_NAME_ATTRIBUTE_NAME = "GenericClassName";
    private static final String GENERIC_CLASS_NAME_ATTRIBUTE_FULL_NAME = "eclipse4diac::core::GenericClassName";

    public static boolean needsGenericAccess(IInterfaceElement element) {
        FBType _fBType;
        boolean _switchResult = false;
        boolean _matched = false;
        if (element instanceof VarDeclaration && (_fBType = ((VarDeclaration)element).getFBType()) instanceof CompositeFBType) {
            _matched = true;
            boolean bl = _switchResult = ((VarDeclaration)element).isInOutVar() || !((VarDeclaration)element).isIsInput() && !((VarDeclaration)element).getInputConnections().isEmpty() && ForteNgExportUtil.isGenericType((LibraryElement)((Connection)((VarDeclaration)element).getInputConnections().getFirst()).getSourceElement().getType());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static CharSequence generateName(IInterfaceElement element) {
        FBType _fBType;
        EReference _eContainmentFeature;
        boolean _equals;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (element instanceof Event) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)EVENT_EXPORT_PREFIX);
            String _name = ((Event)element).getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && (_equals = Objects.equals(_eContainmentFeature = element.eContainmentFeature(), LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_CONST_VARS))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)VARIABLE_EXPORT_PREFIX);
            _builder.append("const_");
            String _name = element.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && element instanceof VarDeclaration && (_fBType = ((VarDeclaration)element).getFBType()) instanceof CompositeFBType) {
            _matched = true;
            Object _xifexpression = null;
            if (((VarDeclaration)element).isIsInput() || ((VarDeclaration)element).isInOutVar()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)CONNECTION_EXPORT_PREFIX);
                _builder_1.append("if2in_");
                String _name_1 = ((VarDeclaration)element).getName();
                _builder_1.append(_name_1);
                _builder_1.append(".getValue()");
                _xifexpression = _builder_1;
            } else {
                CharSequence _xifexpression_1 = null;
                if (!((VarDeclaration)element).getInputConnections().isEmpty() && !((Connection)((VarDeclaration)element).getInputConnections().getFirst()).isNegated()) {
                    _xifexpression_1 = ForteNgExportUtil.generateConnectionValue((Connection)((VarDeclaration)element).getInputConnections().getFirst());
                } else {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append((Object)VARIABLE_EXPORT_PREFIX);
                    String _name_2 = ((VarDeclaration)element).getName();
                    _builder_2.append(_name_2);
                    _xifexpression_1 = _builder_2;
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)VARIABLE_EXPORT_PREFIX);
            String _name_1 = element.getName();
            _builder_1.append(_name_1);
            _switchResult = _builder_1;
        }
        return _switchResult;
    }

    public static CharSequence generateConnectionValue(Connection conn) {
        StringConcatenation _xifexpression = null;
        boolean _isGenericType = ForteNgExportUtil.isGenericType((LibraryElement)conn.getSourceElement().getType());
        if (_isGenericType) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateName = ForteNgExportUtil.generateName(conn.getSourceElement());
            _builder.append((Object)_generateName);
            _builder.append("->getDOConnection(");
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(conn.getSource().getName());
            _builder.append((Object)_fORTEStringId);
            _builder.append(")->getValue()");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _generateName_1 = ForteNgExportUtil.generateName(conn.getSourceElement());
            _builder_1.append((Object)_generateName_1);
            _builder_1.append("->");
            _builder_1.append((Object)CONNECTION_EXPORT_PREFIX);
            String _name = conn.getSource().getName();
            _builder_1.append(_name);
            _builder_1.append(".getValue()");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public static CharSequence generateName(BlockFBNetworkElement element) {
        String _name;
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (element instanceof AdapterFB) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append((Object)VARIABLE_EXPORT_PREFIX);
            _name = ((AdapterFB)element).getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched) {
            _builder = new StringConcatenation();
            _builder.append((Object)FB_EXPORT_PREFIX);
            _name = element.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    public static CharSequence generateNameAsParameter(VarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("pa");
        String _name = variable.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence generateTypeName(LibraryElement type) {
        boolean _isGenericType;
        String _generateTypeNamePlain;
        StringConcatenation _builder;
        boolean _isAnyType;
        String _generateTypeNamePlain2;
        String _generateTypeNamespace;
        StringConcatenation _builder2;
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof AdapterType) {
            _matched = true;
            _builder2 = new StringConcatenation();
            _generateTypeNamespace = ForteNgExportUtil.generateTypeNamespace(type);
            _builder2.append(_generateTypeNamespace);
            _builder2.append("::FORTE_");
            _generateTypeNamePlain2 = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain2);
            _switchResult = _builder2;
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateArrayTypeName((List<Subrange>)((ArrayType)type).getSubranges(), ((ArrayType)type).getBaseType());
        }
        if (!_matched && type instanceof DataType && (_isAnyType = IecTypes.GenericTypes.isAnyType((DataType)((DataType)type)))) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("CIEC_");
            _generateTypeNamePlain2 = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain2);
            _builder.append("_VARIANT");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _builder2 = new StringConcatenation();
            _builder2.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain);
            boolean _isSetMaxLength = ((StringType)type).isSetMaxLength();
            if (_isSetMaxLength) {
                _builder2.append("_FIXED<");
                int _maxLength = ((StringType)type).getMaxLength();
                _builder2.append((Object)_maxLength);
                _builder2.append(">");
            }
            _switchResult = _builder2;
        }
        if (!_matched && type instanceof AnyElementaryType) {
            _matched = true;
            _builder2 = new StringConcatenation();
            _builder2.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain);
            _switchResult = _builder2;
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            _builder2 = new StringConcatenation();
            _generateTypeNamespace = ForteNgExportUtil.generateTypeNamespace(type);
            _builder2.append(_generateTypeNamespace);
            _builder2.append("::CIEC_");
            String _generateTypeNamePlain3 = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain3);
            _switchResult = _builder2;
        }
        if (!_matched && (_isGenericType = ForteNgExportUtil.isGenericType(type))) {
            _matched = true;
            _builder = new StringConcatenation();
            String _generateTypeNamespace2 = ForteNgExportUtil.generateTypeNamespace(type);
            _builder.append(_generateTypeNamespace2);
            _builder.append("::");
            String _genericClassName = ForteNgExportUtil.getGenericClassName(type);
            _builder.append(_genericClassName);
            _switchResult = _builder;
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _generateTypeNamespace_1 = ForteNgExportUtil.generateTypeNamespace(type);
            _builder_1.append(_generateTypeNamespace_1);
            _builder_1.append("::FORTE_");
            String _generateTypeNamePlain4 = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder_1.append(_generateTypeNamePlain4);
            _switchResult = _builder_1;
        }
        return _switchResult;
    }

    public static CharSequence generateTypeNameAsInputParameter(LibraryElement type) {
        return ForteNgExportUtil.generateTypeName(type);
    }

    public static CharSequence generateTypeNameAsInOutParameter(LibraryElement type) {
        CharSequence _xifexpression = null;
        if (type instanceof ArrayType) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("CIEC_ARRAY_COMMON<");
            String _generateArrayTypeName = ForteNgExportUtil.generateArrayTypeName(((ArrayType)type).getSubranges().subList(1, ((ArrayType)type).getSubranges().size()), ((ArrayType)type).getBaseType());
            _builder.append(_generateArrayTypeName);
            _builder.append(">");
            _xifexpression = _builder;
        } else {
            _xifexpression = ForteNgExportUtil.generateTypeName(type);
        }
        return _xifexpression;
    }

    public static CharSequence generateTypeNameAsOutputParameter(LibraryElement type) {
        StringConcatenation _xifexpression = null;
        if (type instanceof AnyBitType) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("CAnyBitOutputParameter<");
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName(type);
            _builder.append((Object)_generateTypeName);
            _builder.append(">");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("COutputParameter<");
            CharSequence _generateTypeName_1 = ForteNgExportUtil.generateTypeName(type);
            _builder_1.append((Object)_generateTypeName_1);
            _builder_1.append(">");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public static String generateArrayTypeName(List<Subrange> subranges, DataType baseType) {
        Functions.Function2 _function = (result, subrange) -> {
            String _xblockexpression = null;
            boolean fixed = subrange.isSetLowerLimit() && subrange.isSetUpperLimit();
            StringConcatenation _builder = new StringConcatenation();
            if (fixed) {
                _builder.append("CIEC_ARRAY_FIXED");
            } else {
                _builder.append("CIEC_ARRAY_VARIABLE");
            }
            _builder.append("<");
            _builder.append(result);
            if (fixed) {
                _builder.append(", ");
                int _lowerLimit = subrange.getLowerLimit();
                _builder.append((Object)_lowerLimit);
                _builder.append(", ");
                int _upperLimit = subrange.getUpperLimit();
                _builder.append((Object)_upperLimit);
            }
            _builder.append(">");
            _xblockexpression = _builder.toString();
            return _xblockexpression;
        };
        return ((CharSequence)IterableExtensions.fold((Iterable)ListExtensions.reverseView(subranges), (Object)ForteNgExportUtil.generateTypeName((LibraryElement)baseType), (Functions.Function2)_function)).toString();
    }

    public static CharSequence generateTypeSpec(LibraryElement type) {
        return ForteNgExportUtil.getFORTEStringId(PackageNameHelper.getFullTypeName((LibraryElement)type));
    }

    public static CharSequence generateDefiningTypeName(EObject object) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (object instanceof LibraryElement) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypeName((LibraryElement)object);
        }
        if (!_matched) {
            Resource _eResource = object.eResource();
            CharSequence _generateDefiningTypeName = null;
            if (_eResource != null) {
                _generateDefiningTypeName = ForteNgExportUtil.generateDefiningTypeName(_eResource);
            }
            _switchResult = _generateDefiningTypeName;
        }
        return _switchResult;
    }

    public static CharSequence generateDefiningTypeName(Resource resource) {
        Iterable _filter = Iterables.filter((Iterable)resource.getContents(), LibraryElement.class);
        LibraryElement _head = null;
        if (_filter != null) {
            _head = (LibraryElement)IterableExtensions.head((Iterable)_filter);
        }
        CharSequence _generateTypeName = null;
        if (_head != null) {
            _generateTypeName = ForteNgExportUtil.generateTypeName(_head);
        }
        return _generateTypeName;
    }

    public static String generateDefiningInclude(EObject object) {
        String _switchResult = null;
        boolean _matched = false;
        if (object instanceof LibraryElement) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypeIncludePath((LibraryElement)object);
        }
        if (!_matched) {
            Resource _eResource = object.eResource();
            String _generateDefiningInclude = null;
            if (_eResource != null) {
                _generateDefiningInclude = ForteNgExportUtil.generateDefiningInclude(_eResource);
            }
            _switchResult = _generateDefiningInclude;
        }
        return _switchResult;
    }

    public static String generateDefiningInclude(Resource resource) {
        String _elvis = null;
        Iterable _filter = Iterables.filter((Iterable)resource.getContents(), LibraryElement.class);
        LibraryElement _head = null;
        if (_filter != null) {
            _head = (LibraryElement)IterableExtensions.head((Iterable)_filter);
        }
        String _generateTypeIncludePath = null;
        if (_head != null) {
            _generateTypeIncludePath = ForteNgExportUtil.generateTypeIncludePath(_head);
        }
        if (_generateTypeIncludePath != null) {
            _elvis = _generateTypeIncludePath;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _lastSegment = resource.getURI().trimFileExtension().lastSegment();
            _builder.append(_lastSegment);
            _builder.append(".h");
            _elvis = _builder.toString();
        }
        return _elvis;
    }

    public static String generateTypeIncludePath(LibraryElement type) {
        boolean _not;
        String _join;
        String _switchResult = null;
        String path = _join = IterableExtensions.join((Iterable)ForteNgExportUtil.generateTypePath(type), (CharSequence)"/");
        boolean _matched = false;
        boolean _isEmpty = path.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("forte/");
            _builder.append(path);
            _builder.append("/");
            String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
            _builder.append(_generateTypeBasename);
            _builder.append(".h");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("forte/");
            String _generateTypeBasename_1 = ForteNgExportUtil.generateTypeBasename(type);
            _builder_1.append(_generateTypeBasename_1);
            _builder_1.append(".h");
            _switchResult = _builder_1.toString();
        }
        return _switchResult;
    }

    public static String generateTypeHeaderFileName(LibraryElement type) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
        _builder.append(_generateTypeBasename);
        _builder.append(".h");
        return _builder.toString();
    }

    public static String generateTypeSourceFileName(LibraryElement type) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
        _builder.append(_generateTypeBasename);
        _builder.append(".cpp");
        return _builder.toString();
    }

    public static Path generateTypeHeaderFilePath(LibraryElement type) {
        return Path.of("include", "forte").resolve(ForteNgExportUtil.generateTypePath(type));
    }

    public static Path generateTypeSourceFilePath(LibraryElement type) {
        return Path.of("src", new String[0]).resolve(ForteNgExportUtil.generateTypePath(type));
    }

    public static String generateTypeBasename(LibraryElement type) {
        boolean _isGenericType;
        String _genericClassName;
        boolean _isGenericType2;
        boolean _isAnyType;
        boolean _isSetMaxLength;
        Object _switchResult = null;
        boolean _matched = false;
        if (type instanceof TimeType) {
            _matched = true;
            _switchResult = "forte_time";
        }
        if (!_matched && type instanceof LtimeType) {
            _matched = true;
            _switchResult = "forte_ltime";
        }
        if (!_matched && type instanceof DateType) {
            _matched = true;
            _switchResult = "forte_date";
        }
        if (!_matched && type instanceof LdateType) {
            _matched = true;
            _switchResult = "forte_ldate";
        }
        if (!_matched && type instanceof TimeOfDayType) {
            _matched = true;
            _switchResult = "forte_time_of_day";
        }
        if (!_matched && type instanceof LtodType) {
            _matched = true;
            _switchResult = "forte_ltime_of_day";
        }
        if (!_matched && type instanceof DateAndTimeType) {
            _matched = true;
            _switchResult = "forte_date_and_time";
        }
        if (!_matched && type instanceof LdtType) {
            _matched = true;
            _switchResult = "forte_ldate_and_time";
        }
        if (!_matched && type instanceof StringType && (_isSetMaxLength = ((StringType)type).isSetMaxLength())) {
            _matched = true;
            _switchResult = "forte_string_fixed";
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _switchResult = "forte_string";
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _switchResult = "forte_wstring";
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypeBasename((LibraryElement)((ArrayType)type).getBaseType());
        }
        if (!_matched && type instanceof AdapterType) {
            _matched = true;
            String _name = ((AdapterType)type).getName();
            _switchResult = _name + "_adp";
        }
        if (!_matched && type instanceof AnyDerivedType) {
            _matched = true;
            String _name = ((AnyDerivedType)type).getName();
            _switchResult = _name + "_dtp";
        }
        if (!_matched && type instanceof DataType && (_isAnyType = IecTypes.GenericTypes.isAnyType((DataType)((DataType)type)))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("forte_");
            String _lowerCase = ForteNgExportUtil.generateTypeNamePlain(type).toLowerCase();
            _builder.append(_lowerCase);
            _builder.append("_variant");
            _switchResult = _builder.toString();
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("forte_");
            String _lowerCase = ((DataType)type).getName().toLowerCase();
            _builder.append(_lowerCase);
            _switchResult = _builder.toString();
        }
        if (!_matched && type instanceof FunctionFBType && (_isGenericType2 = ForteNgExportUtil.isGenericType(type))) {
            _matched = true;
            _genericClassName = ForteNgExportUtil.getGenericClassName(type);
            _switchResult = _genericClassName + "_fct";
        }
        if (!_matched && type instanceof FunctionFBType) {
            _matched = true;
            String _name = ((FunctionFBType)type).getName();
            _switchResult = _name + "_fct";
        }
        if (!_matched && type instanceof FBType && (_isGenericType = ForteNgExportUtil.isGenericType(type))) {
            _matched = true;
            _genericClassName = ForteNgExportUtil.getGenericClassName(type);
            _switchResult = _genericClassName + "_fbt";
        }
        if (!_matched && type instanceof FBType) {
            _matched = true;
            String _name = ((FBType)type).getName();
            _switchResult = _name + "_fbt";
        }
        if (!_matched && type instanceof GlobalConstants) {
            _matched = true;
            String _name = ((GlobalConstants)type).getName();
            _switchResult = _name + "_gcf";
        }
        if (!_matched) {
            _switchResult = type.getName();
        }
        return _switchResult;
    }

    public static Path generateTypePath(LibraryElement type) {
        Path _switchResult = null;
        boolean _matched = false;
        if (type instanceof ArrayType) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypePath((LibraryElement)((ArrayType)type).getBaseType());
        }
        if (!_matched && type instanceof AnyType) {
            boolean _tripleEquals;
            TypeEntry _typeEntry = ((AnyType)type).getTypeEntry();
            boolean bl = _tripleEquals = _typeEntry == null;
            if (_tripleEquals) {
                _matched = true;
                _switchResult = Path.of("datatypes", new String[0]);
            }
        }
        if (!_matched) {
            _switchResult = Path.of("", PackageNameHelper.getPackageName((LibraryElement)type).split("::"));
        }
        return _switchResult;
    }

    public static String generateTypeNamespace(LibraryElement type) {
        String _xblockexpression = null;
        String packageName = PackageNameHelper.getPackageName((LibraryElement)type);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)packageName);
        if (_isNullOrEmpty) {
            return "forte";
        }
        String _escapePackageName = ForteNgExportUtil.escapePackageName(packageName);
        _xblockexpression = "forte::" + _escapePackageName;
        return _xblockexpression;
    }

    public static String escapePackageName(String packageName) {
        Functions.Function1 _function = it -> ForteNgExportUtil.escapeKeyword(it);
        return IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)packageName.split("::"))), (Functions.Function1)_function), (CharSequence)"::");
    }

    public static String escapeKeyword(String name) {
        Object _xifexpression = null;
        boolean _contains = RESERVED_KEYWORDS.contains(name);
        _xifexpression = _contains ? name + "_" : name;
        return _xifexpression;
    }

    public static String generateTypeNamePlain(LibraryElement type) {
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof TimeType) {
            _matched = true;
            _switchResult = "TIME";
        }
        if (!_matched && type instanceof LtimeType) {
            _matched = true;
            _switchResult = "LTIME";
        }
        if (!_matched && type instanceof DateType) {
            _matched = true;
            _switchResult = "DATE";
        }
        if (!_matched && type instanceof LdateType) {
            _matched = true;
            _switchResult = "LDATE";
        }
        if (!_matched && type instanceof TimeOfDayType) {
            _matched = true;
            _switchResult = "TIME_OF_DAY";
        }
        if (!_matched && type instanceof LtodType) {
            _matched = true;
            _switchResult = "LTIME_OF_DAY";
        }
        if (!_matched && type instanceof DateAndTimeType) {
            _matched = true;
            _switchResult = "DATE_AND_TIME";
        }
        if (!_matched && type instanceof LdtType) {
            _matched = true;
            _switchResult = "LDATE_AND_TIME";
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = "ARRAY";
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _switchResult = "STRING";
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _switchResult = "WSTRING";
        }
        if (!_matched) {
            _switchResult = type.getName();
        }
        return _switchResult;
    }

    public static CharSequence getFORTEStringId(String s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        _builder.append(s);
        _builder.append("\"_STRID");
        return _builder;
    }

    public static int getAbsoluteDataPortIndex(IInterfaceElement element) {
        int _xblockexpression = 0;
        InterfaceList interfaceList = element.getInterfaceList();
        int _xifexpression = 0;
        if (interfaceList != null) {
            int _switchResult = 0;
            EReference _eContainmentFeature = element.eContainmentFeature();
            boolean _matched = false;
            if (Objects.equals(_eContainmentFeature, LibraryElementPackage.Literals.INTERFACE_LIST__INPUT_VARS)) {
                _matched = true;
                _switchResult = 0;
            }
            if (!_matched && Objects.equals(_eContainmentFeature, LibraryElementPackage.Literals.INTERFACE_LIST__OUTPUT_VARS)) {
                _matched = true;
                _switchResult = interfaceList.getInputVars().size();
            }
            if (!_matched) {
                if (Objects.equals(_eContainmentFeature, LibraryElementPackage.Literals.INTERFACE_LIST__IN_OUT_VARS)) {
                    _matched = true;
                }
                if (!_matched && Objects.equals(_eContainmentFeature, LibraryElementPackage.Literals.INTERFACE_LIST__OUT_MAPPED_IN_OUT_VARS)) {
                    _matched = true;
                }
                if (_matched) {
                    int _size = interfaceList.getInputVars().size();
                    int _size_1 = interfaceList.getOutputVars().size();
                    _switchResult = _size + _size_1;
                }
            }
            if (!_matched) {
                _switchResult = 0;
            }
            int _interfaceElementIndex = ForteNgExportUtil.getInterfaceElementIndex(element);
            _xifexpression = _switchResult + _interfaceElementIndex;
        } else {
            _xifexpression = ForteNgExportUtil.getInterfaceElementIndex(element);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static int getInterfaceElementIndex(IInterfaceElement element) {
        int _xifexpression = 0;
        if (element.eContainer() != null && element.eContainingFeature().isMany()) {
            Object _eGet = element.eContainer().eGet(element.eContainingFeature());
            _xifexpression = ((EList)_eGet).indexOf((Object)element);
        } else {
            _xifexpression = 0;
        }
        return _xifexpression;
    }

    public static CharSequence escapeMultilineCommentString(CharSequence string) {
        return END_COMMENT_PATTERN.matcher(string).replaceAll("* /");
    }

    public static boolean isGenericType(LibraryElement type) {
        String _genericClassNameAttributeValue = ForteNgExportUtil.getGenericClassNameAttributeValue(type);
        return _genericClassNameAttributeValue != null;
    }

    public static String getGenericClassName(LibraryElement type) {
        return StringValueConverter.INSTANCE.toValue(ForteNgExportUtil.getGenericClassNameAttributeValue(type));
    }

    private static String getGenericClassNameAttributeValue(LibraryElement type) {
        String _attributeValue_1;
        String _elvis = null;
        String _attributeValue = type.getAttributeValue(GENERIC_CLASS_NAME_ATTRIBUTE_FULL_NAME);
        _elvis = _attributeValue != null ? _attributeValue : (_attributeValue_1 = type.getAttributeValue(GENERIC_CLASS_NAME_ATTRIBUTE_NAME));
        return _elvis;
    }

    private ForteNgExportUtil() {
        throw new UnsupportedOperationException();
    }
}

