/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import org.eclipse.fordiac.ide.contractSpec.Age;
import org.eclipse.fordiac.ide.contractSpec.CausalAge;
import org.eclipse.fordiac.ide.contractSpec.CausalReaction;
import org.eclipse.fordiac.ide.contractSpec.EventExpr;
import org.eclipse.fordiac.ide.contractSpec.EventSpec;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.Reaction;
import org.eclipse.fordiac.ide.contractSpec.Repetition;
import org.eclipse.fordiac.ide.contractSpec.SingleEvent;
import org.eclipse.fordiac.ide.contracts.ContractComponent;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractSystem;

class ContractRuleBuilder {
    ContractSystem system;
    ContractComponent component;

    ContractRuleBuilder(ContractSystem system, ContractComponent component) {
        this.system = system;
        this.component = component;
    }

    void addSingleEvent(SingleEvent se) {
        for (EventSpec e : se.getEvents().getEvents()) {
            this.addRule(new ContractRule(e, se.getInterval()));
        }
    }

    void addRepetition(Repetition re) {
        for (EventSpec e : re.getEvents().getEvents()) {
            this.addRule(new ContractRule(e, re.getInterval(), re.getRepetitionOptions()));
        }
    }

    void addReaction(Reaction re) {
        this.addRule(ContractRule.Type.REACTION, re.getInput(), re.getOutput(), re.getInterval(), re.isOnce(), re.getN(), re.getOutOf());
    }

    void addAge(Age age) {
        this.addRule(ContractRule.Type.AGE, age.getInput(), age.getOutput(), age.getInterval(), age.isOnce(), age.getN(), age.getOutOf());
    }

    void addCausalReaction(CausalReaction cRe) {
        this.addRule(new ContractRule(ContractRule.Type.CAUSAL_REACTION, cRe.getInput(), cRe.getOutput(), cRe.getInterval()));
    }

    void addCausalAge(CausalAge cAge) {
        this.addRule(new ContractRule(ContractRule.Type.CAUSAL_AGE, cAge.getInput(), cAge.getOutput(), cAge.getInterval()));
    }

    private void addRule(ContractRule.Type type, EventExpr input, EventExpr output, Interval interval, boolean once, int n, int m) {
        ContractRule rule = new ContractRule(type, input, output, interval);
        rule.setOnce(once);
        rule.setNOutOfM(new ContractRule.SlidingWindow(n, m));
        this.addRule(rule);
    }

    private void addRule(ContractRule rule) {
        this.component.addRule(rule, this.system);
    }
}

