/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.gef.figures.AbstractShadowBorder;
import org.eclipse.fordiac.ide.gef.figures.BorderedRoundedRectangle;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.swt.graphics.Color;

public class GroupFigure
extends Figure {
    private final RoundedRectangle mainFigure = new BorderedRoundedRectangle();
    private InstanceCommentFigure commentFigure;
    private RoundedRectangle nameFigure;

    public GroupFigure() {
        this.createFigure();
    }

    private void createFigure() {
        this.createMainFigure();
        this.mainFigure.add(this.createCommentFigure(), (Object)new GridData(768));
        GridLayout rootLayout = new GridLayout(1, false);
        rootLayout.verticalSpacing = -1;
        rootLayout.horizontalSpacing = 0;
        rootLayout.marginHeight = 0;
        rootLayout.marginWidth = 0;
        this.setLayoutManager((LayoutManager)rootLayout);
        this.add((IFigure)this.mainFigure, new GridData(1808));
        this.createNameFigure();
        this.add((IFigure)this.nameFigure, 0);
        this.setBorder((Border)new GroupShadowBorder());
    }

    private void createMainFigure() {
        this.mainFigure.setOutline(false);
        this.mainFigure.setCornerDimensions(new Dimension(6, 6));
        this.mainFigure.setFillXOR(false);
        this.mainFigure.setOpaque(false);
        GridLayout mainLayout = new GridLayout(1, true);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 0;
        mainLayout.horizontalSpacing = 0;
        this.mainFigure.setLayoutManager((LayoutManager)mainLayout);
    }

    private IFigure createCommentFigure() {
        int top;
        this.commentFigure = new InstanceCommentFigure();
        this.commentFigure.setCursor(Cursors.SIZEALL);
        AdvancedLineBorder commentBorder = new AdvancedLineBorder(4);
        this.commentFigure.setBorder((Border)commentBorder);
        Figure commentContainer = new Figure();
        commentContainer.setLayoutManager((LayoutManager)new ToolbarLayout());
        int lineHeight = (int)CoordinateConverter.INSTANCE.getLineHeight();
        int bottom = top = lineHeight / 2;
        if (top + bottom != lineHeight) {
            top += lineHeight - (top + bottom);
        }
        commentContainer.setBorder((Border)new MarginBorder(top, 5, bottom, 5));
        commentContainer.add((IFigure)this.commentFigure);
        return commentContainer;
    }

    private void createNameFigure() {
        GridLayout nameLayout = new GridLayout(1, false);
        nameLayout.verticalSpacing = 0;
        nameLayout.horizontalSpacing = 0;
        nameLayout.marginHeight = 0;
        this.nameFigure = new BorderedRoundedRectangle();
        this.nameFigure.setCornerDimensions(new Dimension(6, 6));
        this.nameFigure.setOutline(false);
        this.nameFigure.setLayoutManager((LayoutManager)nameLayout);
    }

    public InstanceCommentFigure getCommentFigure() {
        return this.commentFigure;
    }

    public void setCommentFigure(InstanceCommentFigure commentFigure) {
        this.commentFigure = commentFigure;
    }

    public RoundedRectangle getNameFigure() {
        return this.nameFigure;
    }

    public RoundedRectangle getMainFigure() {
        return this.mainFigure;
    }

    private static class GroupShadowBorder
    extends AbstractShadowBorder {
        private static Rectangle nameShadowRect = new Rectangle();
        private static Rectangle mainShadowRect = new Rectangle();

        private GroupShadowBorder() {
        }

        public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
            Assert.isTrue((boolean)(figure instanceof GroupFigure));
            GroupFigure groupFigure = (GroupFigure)figure;
            Color backgroundColor = graphics.getBackgroundColor();
            int alpha = graphics.getAlpha();
            graphics.setBackgroundColor(figure.getForegroundColor());
            nameShadowRect.setBounds(groupFigure.getNameFigure().getBounds()).expand(2, 2);
            mainShadowRect.setBounds(groupFigure.getMainFigure().getBounds()).expand(2, 2);
            GroupShadowBorder.drawShadowHalo(graphics, nameShadowRect, mainShadowRect);
            GroupShadowBorder.drawDropShadow(graphics, nameShadowRect, mainShadowRect);
            graphics.setBackgroundColor(backgroundColor);
            graphics.setAlpha(alpha);
        }

        private static void drawShadowHalo(Graphics graphics, Rectangle nameShadowRect, Rectangle mainShadowRect) {
            graphics.setAlpha(30);
            GroupShadowBorder.drawShadowFigure(graphics, nameShadowRect, mainShadowRect);
            nameShadowRect.shrink(1, 1);
            mainShadowRect.shrink(1, 1);
            graphics.setAlpha(60);
            GroupShadowBorder.drawShadowFigure(graphics, nameShadowRect, mainShadowRect);
        }

        private static void drawDropShadow(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect) {
            graphics.setAlpha(30);
            double horInc = 0.7;
            double horI = 0.0;
            int i = 0;
            while (i < 4) {
                topShadowRect.translate((int)(horI += 0.7), 1);
                middleShadowRect.translate((int)horI, 1);
                GroupShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect);
                if (horI >= 1.0) {
                    horI -= 1.0;
                }
                ++i;
            }
        }

        private static void drawShadowFigure(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect) {
            graphics.fillRoundRectangle(topShadowRect, 8, 8);
            graphics.fillRoundRectangle(middleShadowRect, 8, 8);
        }
    }
}

