/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.dnd;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.dnd.CustomSourceTransfer;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.handlers.AdvancedGraphicalViewerKeyHandler;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDragSourceListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class CustomDragSourceListener
extends AbstractTransferDragSourceListener {
    private Request lastReq = null;

    public CustomDragSourceListener(EditPartViewer viewer) {
        super(viewer, (Transfer)CustomSourceTransfer.getInstance());
        Assert.isTrue((boolean)(viewer.getKeyHandler() instanceof AdvancedGraphicalViewerKeyHandler));
    }

    public void dragStart(DragSourceEvent event) {
        Request req = this.createRequest(new Point(event.x, event.y));
        if (!this.isAltKeyPressed() || req == null) {
            event.doit = false;
            this.lastReq = null;
            return;
        }
        this.lastReq = req;
        CustomSourceTransfer.getInstance().setObject(req);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.lastReq;
    }

    public void dragFinished(DragSourceEvent event) {
        super.dragFinished(event);
        CustomSourceTransfer.getInstance().setObject(null);
        this.lastReq = null;
    }

    private boolean isAltKeyPressed() {
        AdvancedGraphicalViewerKeyHandler keyHandler = (AdvancedGraphicalViewerKeyHandler)this.getViewer().getKeyHandler();
        return (keyHandler.getCurrentStateMask() & 0x10000) != 0;
    }

    private boolean isCtrlKeyPressed() {
        AdvancedGraphicalViewerKeyHandler keyHandler = (AdvancedGraphicalViewerKeyHandler)this.getViewer().getKeyHandler();
        return (keyHandler.getCurrentStateMask() & 0x40000) != 0;
    }

    private Request createRequest(Point point) {
        EditPart editPart;
        EditPart editPart2;
        List selectedEditParts = this.getViewer().getSelectedEditParts();
        if (this.isCtrlKeyPressed() && !selectedEditParts.isEmpty() && (editPart2 = (EditPart)selectedEditParts.get(0)) instanceof ConnectionEditPart) {
            ConnectionEditPart connEditpart = (ConnectionEditPart)editPart2;
            return CustomDragSourceListener.createConnectionFromEndpointRequest(point, connEditpart);
        }
        if (selectedEditParts.size() == 1 && (editPart = (EditPart)selectedEditParts.get(0)) instanceof InterfaceEditPart) {
            InterfaceEditPart iep = (InterfaceEditPart)editPart;
            return CustomDragSourceListener.createConnectionCreationRequest(iep);
        }
        if (CustomDragSourceListener.atLeastOneFBSelected(selectedEditParts)) {
            return CustomDragSourceListener.createChangeBoundsRequest(selectedEditParts);
        }
        List<ConnectionEditPart> connections = selectedEditParts.stream().filter(ConnectionEditPart.class::isInstance).map(ep -> (ConnectionEditPart)((Object)ep)).toList();
        if (!connections.isEmpty()) {
            return CustomDragSourceListener.createReconnectRequest(connections, point);
        }
        return null;
    }

    private static Request createConnectionFromEndpointRequest(Point point, ConnectionEditPart connEditpart) {
        ConnectionEndpointHandle endpointHandle = CustomDragSourceListener.getConnectionHandle(connEditpart, point);
        if (endpointHandle != null && endpointHandle.getEndPoint() == 2) {
            return CustomDragSourceListener.createConnectionCreationRequest((InterfaceEditPart)connEditpart.getTarget());
        }
        return CustomDragSourceListener.createConnectionCreationRequest((InterfaceEditPart)connEditpart.getSource());
    }

    private static Request createConnectionCreationRequest(InterfaceEditPart iep) {
        CreateConnectionRequest req = new CreateConnectionRequest();
        req.setType((Object)"connection start");
        req.setSourceEditPart((EditPart)iep);
        req.setStartCommand(iep.getCommand((Request)req));
        req.setType((Object)"connection end");
        return req;
    }

    protected static boolean atLeastOneFBSelected(List<? extends EditPart> selectedEditParts) {
        return selectedEditParts.stream().anyMatch(ep -> ep.getModel() instanceof FBNetworkElement);
    }

    private static Request createReconnectRequest(List<ConnectionEditPart> connections, Point point) {
        ConnectionEditPart first = connections.get(0);
        String reconnectType = CustomDragSourceListener.getReconnectType(first, point);
        if (reconnectType != null) {
            ReconnectRequest req = new ReconnectRequest((Object)reconnectType);
            req.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)first);
            if (connections.size() > 1) {
                req.getExtendedData().put("Connections", connections);
            }
            EditPart target = req.getType().equals("Reconnection source") ? first.getSource() : first.getTarget();
            req.setTargetEditPart(target);
            return req;
        }
        return null;
    }

    private static Request createChangeBoundsRequest(List<? extends EditPart> selectedEditParts) {
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setEditParts(selectedEditParts);
        request.setType((Object)"add children");
        return request;
    }

    private static String getReconnectType(ConnectionEditPart first, Point point) {
        ConnectionEndpointHandle connectionHandle = CustomDragSourceListener.getConnectionHandle(first, point);
        if (connectionHandle != null) {
            if (connectionHandle.getEndPoint() == 2) {
                return "Reconnection source";
            }
            return "Reconnection target";
        }
        return null;
    }

    private static ConnectionEndpointHandle getConnectionHandle(ConnectionEditPart first, Point point) {
        List handles = LayerManager.Helper.find((EditPart)first).getLayer((Object)"Handle Layer").getChildren();
        for (IFigure handle : handles) {
            Point pointCopy = point.getCopy();
            handle.translateToRelative((Translatable)pointCopy);
            if (!handle.getBounds().contains(pointCopy) || !(handle instanceof ConnectionEndpointHandle)) continue;
            ConnectionEndpointHandle conHandle = (ConnectionEndpointHandle)handle;
            return conHandle;
        }
        return null;
    }
}

