/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.ui.providers.CommandProvider;
import org.eclipse.fordiac.ide.ui.providers.CreationCommandProvider;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddDeleteReorderListWidget
extends AddDeleteWidget {
    protected static final int MAJOR_BUTTON_INTERLEAVE = 6;
    private Button upButton;
    private Button downButton;

    @Override
    public void createControls(Composite parent, FormToolkit widgetFactory) {
        this.container = AddDeleteReorderListWidget.createContainer(widgetFactory, parent);
        this.createAddButton(widgetFactory, this.container);
        this.createDeleteButton(widgetFactory, this.container);
        this.upButton = widgetFactory.createButton(this.container, "", 132);
        this.upButton.setToolTipText("Move element(s) up");
        this.upButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 6).create());
        this.downButton = widgetFactory.createButton(this.container, "", 1028);
        this.downButton.setToolTipText("Move element(s) down");
        this.downButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.setButtonEnablement(false);
    }

    @Override
    protected void setButtonEnablement(boolean enable) {
        this.upButton.setEnabled(enable);
        this.downButton.setEnabled(enable);
        super.setButtonEnablement(enable);
    }

    public void addUpListener(Listener upListener) {
        this.upButton.addListener(13, upListener);
    }

    public void addDownListener(Listener downListener) {
        this.downButton.addListener(13, downListener);
    }

    public void bindToTableViewer(TableViewer viewer, CommandExecutor executor, CreationCommandProvider addCommand, CommandProvider deleteCommand, CommandProvider moveUpCommand, CommandProvider moveDownCommand) {
        super.bindToTableViewer(viewer, executor, addCommand, deleteCommand);
        this.addUpListener(AddDeleteReorderListWidget.getSelectionListener(viewer, executor, moveUpCommand));
        this.addDownListener(AddDeleteReorderListWidget.getReverseSelectionListener(viewer, executor, moveDownCommand));
    }

    public void bindToTableViewer(NatTable table, CommandExecutor executor, CreationCommandProvider addCommand, CommandProvider deleteCommand, CommandProvider moveUpCommand, CommandProvider moveDownCommand) {
        super.bindToTableViewer(table, executor, addCommand, deleteCommand);
        this.addUpListener(AddDeleteReorderListWidget.getSelectionListener(table, executor, moveUpCommand));
        this.addDownListener(AddDeleteReorderListWidget.getReverseSelectionListener(table, executor, moveDownCommand));
    }

    public static Listener getReverseSelectionListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                List bottomup = viewer.getStructuredSelection().toList();
                Collections.reverse(bottomup);
                AddDeleteReorderListWidget.executeCompoundCommandForList(viewer, bottomup, executor, commandProvider);
                viewer.getTable().forceFocus();
            }
        };
    }

    public static Listener getReverseSelectionListener(NatTable table, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            int row;
            SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
            ListDataProvider dataProvider = (ListDataProvider)NatTableWidgetFactory.getDataLayer(table).getDataProvider();
            if (!selectionLayer.hasRowSelection() || selectionLayer.isRowPositionSelected(dataProvider.getRowCount() - 1)) {
                return;
            }
            int[] rows = selectionLayer.getFullySelectedRowPositions();
            ArrayList<Object> rowObjects = new ArrayList<Object>();
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                row = nArray[n2];
                if (row >= 0) {
                    rowObjects.add(dataProvider.getRowObject(row));
                }
                ++n2;
            }
            if (!rowObjects.isEmpty()) {
                Collections.reverse(rowObjects);
                AddDeleteReorderListWidget.executeCompoundCommandForList(table, rowObjects, executor, commandProvider);
                nArray = rows;
                n = rows.length;
                n2 = 0;
                while (n2 < n) {
                    row = nArray[n2];
                    if (row == dataProvider.getRowCount() - 1) {
                        selectionLayer.selectRow(0, row, true, true);
                    } else {
                        selectionLayer.selectRow(0, row + 1, true, true);
                    }
                    ++n2;
                }
            }
        };
    }
}

